/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;

public class WinIntelliJComboBoxUI
extends DarculaComboBoxUI {
    public WinIntelliJComboBoxUI(JComboBox comboBox) {
        super(comboBox);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJComboBoxUI((JComboBox)c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent;
        int w = c.getWidth();
        int h = c.getHeight();
        if (c.isOpaque() && (parent = c.getParent()) != null) {
            g.setColor(WinIntelliJComboBoxUI.isTableCellEditor(c) && this.editor != null ? this.editor.getBackground() : parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Rectangle r = this.rectangleForCurrentValue();
        g.setColor(this.getComboBackground());
        g.fillRect(JBUI.scale((int)1), JBUI.scale((int)1), w - 2 * JBUI.scale((int)1), h - 2 * JBUI.scale((int)1));
        if (!WinIntelliJComboBoxUI.isTableCellEditor(c)) {
            this.paintBorder(c, g, 0, 0, w, h);
            this.hasFocus = this.comboBox.hasFocus();
            this.paintCurrentValueBackground(g, r, this.hasFocus);
        }
        this.paintCurrentValue(g, r, this.hasFocus);
    }

    protected Color getComboBackground() {
        if (!this.comboBox.isEnabled() && !this.comboBox.isEditable()) {
            return UIManager.getColor("ComboBox.disabledBackground");
        }
        if (this.comboBox.isEditable()) {
            ComboBoxEditor editor = this.comboBox.getEditor();
            if (editor != null && editor.getEditorComponent() != null) {
                return editor.getEditorComponent().getBackground();
            }
            return Gray.xFF;
        }
        return this.comboBox.getBackground();
    }

    @Override
    protected JButton createArrowButton() {
        BasicArrowButton button = new BasicArrowButton(5){

            @Override
            public Dimension getPreferredSize() {
                return JBUI.size((int)14, (int)10);
            }

            @Override
            public void paint(Graphics g) {
                g.setColor(WinIntelliJComboBoxUI.this.getComboBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                IconUtil.paintInCenterOf((Component)this, (Graphics)g, (Icon)MacIntelliJIconCache.getIcon("comboDropTriangle", false, false, this.isEnabled()));
            }
        };
        button.setOpaque(false);
        button.setBorder((Border)JBUI.Borders.empty());
        return button;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        if (this.comboBox == null || this.arrowButton == null) {
            return;
        }
        GraphicsConfig config = new GraphicsConfig(g2);
        this.hasFocus = false;
        this.checkFocus();
        if (this.hasFocus) {
            g2.setColor(UIManager.getColor("ComboBox.activeBorderColor"));
            ((Graphics2D)g2).setStroke(new BasicStroke(JBUI.scale((float)2.0f)));
        } else {
            g2.setColor(UIManager.getColor("ComboBox.borderColor"));
        }
        g2.translate(x, y);
        g2.drawRect(JBUI.scale((int)1), JBUI.scale((int)1), width - 2 * JBUI.scale((int)1), height - 2 * JBUI.scale((int)1));
        g2.translate(-x, -y);
        config.restore();
    }
}

