/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteNameDescriptionLocation;
import com.intellij.ide.util.DeleteTypeDescriptionLocation;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.HashMap;
import java.text.MessageFormat;
import java.util.Map;

public class DeleteUtil {
    private DeleteUtil() {
    }

    public static String generateWarningMessage(String messageTemplate, PsiElement[] elements) {
        if (elements.length == 1) {
            String name = ElementDescriptionUtil.getElementDescription((PsiElement)elements[0], (ElementDescriptionLocation)DeleteNameDescriptionLocation.INSTANCE);
            String type = ElementDescriptionUtil.getElementDescription((PsiElement)elements[0], (ElementDescriptionLocation)DeleteTypeDescriptionLocation.SINGULAR);
            return MessageFormat.format(messageTemplate, type + " \"" + name + "\"");
        }
        FactoryMap<String, Integer> countMap = new FactoryMap<String, Integer>(){

            protected Integer create(String key2) {
                return 0;
            }
        };
        HashMap pluralToSingular = new HashMap();
        int directoryCount = 0;
        String containerType = null;
        for (PsiElement elementToDelete : elements) {
            String type = ElementDescriptionUtil.getElementDescription((PsiElement)elementToDelete, (ElementDescriptionLocation)DeleteTypeDescriptionLocation.PLURAL);
            pluralToSingular.put(type, ElementDescriptionUtil.getElementDescription((PsiElement)elementToDelete, (ElementDescriptionLocation)DeleteTypeDescriptionLocation.SINGULAR));
            int oldCount = (Integer)countMap.get((Object)type);
            countMap.put((Object)type, (Object)(oldCount + 1));
            if (!(elementToDelete instanceof PsiDirectoryContainer)) continue;
            containerType = type;
            directoryCount += ((PsiDirectoryContainer)elementToDelete).getDirectories().length;
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry entry : countMap.entrySet()) {
            if (buffer.length() > 0 && buffer.length() > 0) {
                buffer.append(" ").append(IdeBundle.message((String)"prompt.delete.and", (Object[])new Object[0])).append(" ");
            }
            int count = (Integer)entry.getValue();
            buffer.append(count).append(" ");
            if (count == 1) {
                buffer.append((String)pluralToSingular.get(entry.getKey()));
            } else {
                buffer.append((String)entry.getKey());
            }
            if (!((String)entry.getKey()).equals(containerType)) continue;
            buffer.append(" ").append(IdeBundle.message((String)"prompt.delete.directory.paren", (Object[])new Object[]{directoryCount}));
        }
        return MessageFormat.format(messageTemplate, buffer.toString());
    }
}

