/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.GotoLineNumberDialog;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class EditorGotoLineNumberDialog
extends GotoLineNumberDialog {
    private final Editor myEditor;

    public EditorGotoLineNumberDialog(Project project2, Editor editor) {
        super(project2);
        this.myEditor = editor;
        this.init();
    }

    protected void doOKAction() {
        GotoLineNumberDialog.Coordinates coordinates = this.getCoordinates();
        if (coordinates == null) {
            return;
        }
        LogicalPosition position = new LogicalPosition(coordinates.row, coordinates.column);
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToLogicalPosition(position);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.myEditor.getSelectionModel().removeSelection();
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true);
        super.doOKAction();
    }

    @Override
    protected int getLine() {
        return this.myEditor.getCaretModel().getLogicalPosition().line;
    }

    @Override
    protected int getColumn() {
        return this.myEditor.getCaretModel().getLogicalPosition().column;
    }

    @Override
    protected int getOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    protected int getMaxOffset() {
        return this.myEditor.getDocument().getTextLength();
    }

    @Override
    protected int coordinatesToOffset(@NotNull GotoLineNumberDialog.Coordinates coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/intellij/ide/util/EditorGotoLineNumberDialog", "coordinatesToOffset"));
        }
        LogicalPosition position = new LogicalPosition(coordinates.row, coordinates.column);
        return this.myEditor.logicalPositionToOffset(position);
    }

    @Override
    @NotNull
    protected GotoLineNumberDialog.Coordinates offsetToCoordinates(int offset) {
        LogicalPosition position = this.myEditor.offsetToLogicalPosition(offset);
        GotoLineNumberDialog.Coordinates coordinates = new GotoLineNumberDialog.Coordinates(position.line, position.column);
        if (coordinates == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/EditorGotoLineNumberDialog", "offsetToCoordinates"));
        }
        return coordinates;
    }
}

