/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.ScopeEditorPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class PackageSetChooserCombo
extends ComponentWithBrowseButton<JComponent> {
    private static final Logger LOG = Logger.getInstance((String)("#" + PackageSetChooserCombo.class.getName()));
    private final Project myProject;

    public PackageSetChooserCombo(Project project2, String preselect) {
        this(project2, preselect, true, true);
    }

    public PackageSetChooserCombo(Project project2, @Nullable String preselect, boolean enableBrowseButton, boolean useCombo) {
        super(useCombo ? new JComboBox() : new JBComboBoxTableCellEditorComponent(), null);
        this.myProject = project2;
        final JComponent component = this.getChildComponent();
        if (component instanceof JComboBox) {
            component.setBorder(null);
        }
        if (enableBrowseButton) {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NamedScope scope = component instanceof JComboBox ? (NamedScope)((JComboBox)component).getSelectedItem() : (NamedScope)((JBComboBoxTableCellEditorComponent)component).getEditorValue();
                    if (scope instanceof NamedScope.UnnamedScope) {
                        Map unnamedScopes = DependencyValidationManager.getInstance((Project)PackageSetChooserCombo.this.myProject).getUnnamedScopes();
                        EditUnnamedScopesDialog dlg = new EditUnnamedScopesDialog(scope);
                        if (dlg.showAndGet()) {
                            PackageSet packageSet = scope.getValue();
                            LOG.assertTrue(packageSet != null);
                            unnamedScopes.remove(packageSet.getText());
                            PackageSet editedScope = dlg.getScope();
                            if (editedScope != null) {
                                unnamedScopes.put(editedScope.getText(), editedScope);
                            }
                            PackageSetChooserCombo.this.rebuild();
                            if (editedScope != null) {
                                PackageSetChooserCombo.this.selectScope(editedScope.getText());
                            }
                        }
                    } else {
                        EditScopesDialog dlg = EditScopesDialog.showDialog(PackageSetChooserCombo.this.myProject, scope.getName(), true);
                        if (dlg.isOK()) {
                            PackageSetChooserCombo.this.rebuild();
                            NamedScope namedScope = dlg.getSelectedScope();
                            if (namedScope != null) {
                                PackageSetChooserCombo.this.selectScope(namedScope.getName());
                            }
                        }
                    }
                }
            });
        } else {
            this.getButton().setVisible(false);
        }
        if (component instanceof JComboBox) {
            ((JComboBox)component).setRenderer(new ListCellRendererWrapper<NamedScope>(){

                public void customize(JList list, NamedScope value, int index, boolean selected, boolean hasFocus) {
                    this.setText(value == null ? "" : value.getName());
                }
            });
        } else {
            ((JBComboBoxTableCellEditorComponent)component).setToString(o -> o == null ? "" : ((NamedScope)o).getName());
        }
        this.rebuild();
        this.selectScope(preselect);
    }

    private void selectScope(String preselect) {
        block4: {
            JComponent component = this.getChildComponent();
            if (preselect == null) break block4;
            if (component instanceof JComboBox) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)component).getModel();
                for (int i2 = 0; i2 < model.getSize(); ++i2) {
                    NamedScope descriptor = (NamedScope)model.getElementAt(i2);
                    if (!preselect.equals(descriptor.getName())) continue;
                    ((JComboBox)component).setSelectedIndex(i2);
                    break;
                }
            } else {
                Object[] options;
                for (Object option : options = ((JBComboBoxTableCellEditorComponent)component).getOptions()) {
                    NamedScope descriptor = (NamedScope)option;
                    if (!preselect.equals(descriptor.getName())) continue;
                    ((JBComboBoxTableCellEditorComponent)component).setDefaultValue((Object)descriptor);
                    break;
                }
            }
        }
    }

    private void rebuild() {
        JComponent component = this.getChildComponent();
        Object[] model = this.createModel();
        if (component instanceof JComboBox) {
            ((JComboBox)component).setModel(new DefaultComboBoxModel<Object>(model));
        } else {
            ((JBComboBoxTableCellEditorComponent)component).setOptions(model);
        }
    }

    protected NamedScope[] createModel() {
        ArrayList<Object> model = new ArrayList<Object>();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)this.myProject);
        model.addAll(Arrays.asList(manager.getScopes()));
        for (PackageSet unnamedScope : manager.getUnnamedScopes().values()) {
            model.add(new NamedScope.UnnamedScope(unnamedScope));
        }
        model.remove(DefaultScopesProvider.getInstance(this.myProject).getProblemsScope());
        return model.toArray(new NamedScope[model.size()]);
    }

    @Nullable
    public NamedScope getSelectedScope() {
        JComponent component = this.getChildComponent();
        if (component instanceof JComboBox) {
            int idx = ((JComboBox)component).getSelectedIndex();
            if (idx < 0) {
                return null;
            }
            return (NamedScope)((JComboBox)component).getSelectedItem();
        }
        return (NamedScope)((JBComboBoxTableCellEditorComponent)component).getEditorValue();
    }

    private class EditUnnamedScopesDialog
    extends DialogWrapper {
        private PackageSet myScope;
        private final ScopeEditorPanel myPanel;

        public EditUnnamedScopesDialog(NamedScope scope) {
            super((Component)((Object)PackageSetChooserCombo.this), false);
            this.myScope = scope.getValue();
            this.myPanel = new ScopeEditorPanel(PackageSetChooserCombo.this.myProject, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)PackageSetChooserCombo.this.myProject));
            this.init();
            this.myPanel.reset(this.myScope, null);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel.getPanel();
        }

        protected void doOKAction() {
            this.myScope = this.myPanel.getCurrentScope();
            super.doOKAction();
        }

        public PackageSet getScope() {
            return this.myScope;
        }
    }
}

