/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NotNull;

public class LoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";
    private boolean myInitialized = false;

    private LoggerFactory() {
    }

    @NotNull
    public synchronized com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/idea/LoggerFactory", "getLoggerInstance"));
        }
        try {
            if (!this.myInitialized) {
                this.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IdeaLogger ideaLogger = new IdeaLogger(Logger.getLogger((String)name));
        if (ideaLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/LoggerFactory", "getLoggerInstance"));
        }
        return ideaLogger;
    }

    private void init() {
        try {
            System.setProperty("log4j.defaultInitOverride", "true");
            File logXmlFile = FileUtil.findFirstThatExist((String[])new String[]{PathManager.getHomePath() + "/bin/log.xml", PathManager.getHomePath() + "/community/bin/log.xml"});
            if (logXmlFile == null) {
                throw new RuntimeException("log.xml file does not exist! Path: [ $home/bin/log.xml]");
            }
            String text = FileUtil.loadFile((File)logXmlFile);
            text = StringUtil.replace((String)text, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)LOG_DIR_MACRO, (String)StringUtil.replace((String)PathManager.getLogPath(), (String)"\\", (String)"\\\\"));
            File file2 = new File(PathManager.getLogPath());
            if (!file2.mkdirs() && !file2.exists()) {
                System.err.println("Cannot create log directory: " + file2);
            }
            new DOMConfigurator().doConfigure((Reader)new StringReader(text), LogManager.getLoggerRepository());
            this.myInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

