/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.SystemInfo;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class JdkInfoUsageCollector
extends UsagesCollector {
    JdkInfoUsageCollector() {
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        String vendor = System.getProperty("java.vendor", "Unknown");
        for (String version : new String[]{"1.9", "1.8", "1.7", "1.6"}) {
            if (!SystemInfo.isJavaVersionAtLeast((String)version)) continue;
            Set<UsageDescriptor> set2 = Collections.singleton(new UsageDescriptor(vendor + " " + version, 1));
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/JdkInfoUsageCollector", "getUsages"));
            }
            return set2;
        }
        Set<UsageDescriptor> set3 = Collections.emptySet();
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/JdkInfoUsageCollector", "getUsages"));
        }
        return set3;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("user.jdk");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/JdkInfoUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

