/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    private static final Language[] ourLanguages = new Language[]{JavaLanguage.INSTANCE};

    public Language[] getLanguages() {
        return ourLanguages;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "acceptElement"));
        }
        return e instanceof PsiMember || e instanceof PsiLambdaExpression;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "getElementInfo"));
        }
        if (e instanceof PsiLambdaExpression) {
            boolean isDumb = DumbService.isDumb((Project)e.getProject());
            PsiType type = isDumb ? null : ((PsiFunctionalExpression)e).getFunctionalInterfaceType();
            String string = type == null ? "->" : "-> " + JavaBreadcrumbsInfoProvider.getTypeText(type, false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "getElementInfo"));
            }
            return string;
        }
        if (e instanceof PsiAnonymousClass) {
            String name = ((PsiAnonymousClass)e).getBaseClassReference().getReferenceName();
            String string = "new " + StringUtil.notNullize((String)name, (String)"class");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "getElementInfo"));
            }
            return string;
        }
        String description = ElementDescriptionUtil.getElementDescription((PsiElement)e, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        String suffix = e instanceof PsiParameterListOwner ? "()" : null;
        String string = suffix != null ? description + suffix : description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "getElementInfo"));
        }
        return string;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "getElementTooltip"));
        }
        if (e instanceof PsiLambdaExpression) {
            return JavaBreadcrumbsInfoProvider.getLambdaDescription((PsiLambdaExpression)e);
        }
        if (e instanceof PsiMethod) {
            return JavaBreadcrumbsInfoProvider.getMethodPresentableText((PsiMethod)e);
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)e, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT);
    }

    @NotNull
    private static String getMethodPresentableText(PsiMethod e) {
        boolean isDumb = DumbService.isDumb((Project)e.getProject());
        StringBuilder sb = new StringBuilder(e.isConstructor() ? "constructor" : "method");
        PsiType type = e.getReturnType();
        if (type != null) {
            sb.append(" ").append(StringUtil.htmlEmphasize((String)JavaBreadcrumbsInfoProvider.getTypeText(type, isDumb)));
        }
        sb.append(" ").append(StringUtil.htmlEmphasize((String)e.getName()));
        JavaBreadcrumbsInfoProvider.appendParameters((PsiParameterListOwner)e, sb, false, isDumb);
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "getMethodPresentableText"));
        }
        return string;
    }

    @NotNull
    private static String getLambdaDescription(@NotNull PsiLambdaExpression e) {
        PsiType functionalInterfaceType;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "getLambdaDescription"));
        }
        boolean isDumb = DumbService.isDumb((Project)e.getProject());
        StringBuilder sb = new StringBuilder("lambda");
        PsiType psiType = functionalInterfaceType = isDumb ? null : e.getFunctionalInterfaceType();
        if (functionalInterfaceType != null) {
            sb.append(" ").append(StringUtil.htmlEmphasize((String)JavaBreadcrumbsInfoProvider.getTypeText(functionalInterfaceType, false)));
        }
        JavaBreadcrumbsInfoProvider.appendParameters((PsiParameterListOwner)e, sb, true, isDumb);
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "getLambdaDescription"));
        }
        return string;
    }

    private static void appendParameters(@NotNull PsiParameterListOwner e, StringBuilder sb, boolean skipIfEmpty, boolean isDumb) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "appendParameters"));
        }
        PsiParameter[] parameters = e.getParameterList().getParameters();
        if (parameters.length == 0 && skipIfEmpty) {
            return;
        }
        if (skipIfEmpty) {
            sb.append(" ");
        }
        sb.append("(");
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiTypeElement typeElement;
            if (i2 > 0) {
                sb.append(", ");
            }
            String typeStr = isDumb ? ((typeElement = parameters[i2].getTypeElement()) == null ? "" : PsiNameHelper.getShortClassName((String)typeElement.getText())) : JavaBreadcrumbsInfoProvider.getTypeText(parameters[i2].getType(), false);
            String str = StringUtil.isEmpty((String)typeStr) ? StringUtil.notNullize((String)parameters[i2].getName()) : PsiNameHelper.getShortClassName((String)typeStr);
            sb.append(StringUtil.htmlEmphasize((String)str));
        }
        sb.append(")");
    }

    @NotNull
    private static String getTypeText(@Nullable PsiType type, boolean isDumb) {
        String result2 = type == null ? "" : (!isDumb || type instanceof PsiPrimitiveType ? type.getCanonicalText(false) : (type instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type).getReference().getReferenceName() : ""));
        String string = PsiNameHelper.getShortClassName((String)StringUtil.notNullize((String)result2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaBreadcrumbsInfoProvider", "getTypeText"));
        }
        return string;
    }
}

