/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.parser;

import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.impl.PsiBuilderAdapter;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LimitedPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedParserUtilBase {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.grammar.parser.GeneratedParserUtilBase");
    private static final int MAX_RECURSION_LEVEL = StringUtil.parseInt((String)System.getProperty("grammar.kit.gpub.max.level"), (int)1000);
    private static final int MAX_VARIANTS_SIZE = 10000;
    private static final int MAX_VARIANTS_TO_DISPLAY = 50;
    private static final int MAX_ERROR_TOKEN_TEXT = 20;
    private static final int INITIAL_VARIANTS_SIZE = 1000;
    private static final int VARIANTS_POOL_SIZE = 10000;
    private static final int FRAMES_POOL_SIZE = 500;
    public static final IElementType DUMMY_BLOCK = new DummyBlockElementType();
    public static final Parser TOKEN_ADVANCER = new Parser(){

        @Override
        public boolean parse(PsiBuilder builder, int level) {
            if (builder.eof()) {
                return false;
            }
            builder.advanceLexer();
            return true;
        }
    };
    public static final Parser TRUE_CONDITION = new Parser(){

        @Override
        public boolean parse(PsiBuilder builder, int level) {
            return true;
        }
    };
    public static final Hook<WhitespacesAndCommentsBinder> LEFT_BINDER = new Hook<WhitespacesAndCommentsBinder>(){

        @Override
        public PsiBuilder.Marker run(PsiBuilder builder, PsiBuilder.Marker marker, WhitespacesAndCommentsBinder param) {
            if (marker != null) {
                marker.setCustomEdgeTokenBinders(param, null);
            }
            return marker;
        }
    };
    public static final Hook<WhitespacesAndCommentsBinder> RIGHT_BINDER = new Hook<WhitespacesAndCommentsBinder>(){

        @Override
        public PsiBuilder.Marker run(PsiBuilder builder, PsiBuilder.Marker marker, WhitespacesAndCommentsBinder param) {
            if (marker != null) {
                marker.setCustomEdgeTokenBinders(null, param);
            }
            return marker;
        }
    };
    public static final Hook<WhitespacesAndCommentsBinder[]> WS_BINDERS = new Hook<WhitespacesAndCommentsBinder[]>(){

        @Override
        public PsiBuilder.Marker run(PsiBuilder builder, PsiBuilder.Marker marker, WhitespacesAndCommentsBinder[] param) {
            if (marker != null) {
                marker.setCustomEdgeTokenBinders(param[0], param[1]);
            }
            return marker;
        }
    };
    public static final Hook<String> LOG_HOOK = new Hook<String>(){

        @Override
        public PsiBuilder.Marker run(PsiBuilder builder, PsiBuilder.Marker marker, String param) {
            PsiBuilderImpl.ProductionMarker m = (PsiBuilderImpl.ProductionMarker)marker;
            int start = m == null ? builder.getCurrentOffset() : m.getStartOffset();
            int end = m == null ? start : m.getEndOffset();
            String prefix = "[" + start + ", " + end + "]" + (m == null ? "" : " " + m.getTokenType());
            builder.mark().error(prefix + ": " + param);
            return marker;
        }
    };
    public static final int _NONE_ = 0;
    public static final int _COLLAPSE_ = 1;
    public static final int _LEFT_ = 2;
    public static final int _LEFT_INNER_ = 4;
    public static final int _AND_ = 8;
    public static final int _NOT_ = 16;
    public static final int _UPPER_ = 32;
    public static final Key<CompletionState> COMPLETION_STATE_KEY = Key.create((String)"COMPLETION_STATE_KEY");
    private static final int MAX_CHILDREN_IN_TREE = 10;

    public static boolean eof(PsiBuilder builder, int level) {
        return builder.eof();
    }

    public static int current_position_(PsiBuilder builder) {
        return builder.rawTokenIndex();
    }

    public static boolean recursion_guard_(PsiBuilder builder, int level, String funcName) {
        if (level > MAX_RECURSION_LEVEL) {
            builder.mark().error("Maximum recursion level (" + MAX_RECURSION_LEVEL + ") reached in '" + funcName + "'");
            return false;
        }
        return true;
    }

    public static boolean empty_element_parsed_guard_(PsiBuilder builder, String funcName, int pos) {
        if (pos == GeneratedParserUtilBase.current_position_(builder)) {
            builder.error("Empty element parsed in '" + funcName + "' at offset " + builder.getCurrentOffset());
            return false;
        }
        return true;
    }

    public static boolean invalid_left_marker_guard_(PsiBuilder builder, PsiBuilder.Marker marker, String funcName) {
        boolean goodMarker;
        boolean bl = goodMarker = marker != null;
        if (!goodMarker) {
            return false;
        }
        ErrorState state = ErrorState.get(builder);
        return state.currentFrame != null;
    }

    public static TokenSet create_token_set_(IElementType ... tokenTypes) {
        return TokenSet.create((IElementType[])tokenTypes);
    }

    public static boolean leftMarkerIs(PsiBuilder builder, IElementType type) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        return marker != null && marker.getTokenType() == type;
    }

    private static boolean consumeTokens(PsiBuilder builder, boolean smart, int pin, IElementType ... tokens) {
        ErrorState state = ErrorState.get(builder);
        if (state.completionState != null && state.predicateSign) {
            GeneratedParserUtilBase.addCompletionVariant(builder, state.completionState, tokens);
        }
        CompletionState completionState = state.completionState;
        state.completionState = null;
        boolean result2 = true;
        boolean pinned = false;
        int tokensLength = tokens.length;
        for (int i2 = 0; i2 < tokensLength; ++i2) {
            boolean fast;
            if (pin > 0 && i2 == pin) {
                pinned = result2;
            }
            if (!result2 && !pinned) continue;
            boolean bl = fast = smart && i2 == 0;
            if (!fast ? GeneratedParserUtilBase.consumeToken(builder, tokens[i2]) : GeneratedParserUtilBase.consumeTokenFast(builder, tokens[i2])) continue;
            result2 = false;
            if (pin >= 0 && !pinned) continue;
            GeneratedParserUtilBase.report_error_(builder, state, false);
        }
        state.completionState = completionState;
        return pinned || result2;
    }

    public static boolean consumeTokens(PsiBuilder builder, int pin, IElementType ... token) {
        return GeneratedParserUtilBase.consumeTokens(builder, false, pin, token);
    }

    public static boolean consumeTokensSmart(PsiBuilder builder, int pin, IElementType ... token) {
        return GeneratedParserUtilBase.consumeTokens(builder, true, pin, token);
    }

    public static boolean parseTokens(PsiBuilder builder, int pin, IElementType ... tokens) {
        return GeneratedParserUtilBase.parseTokens(builder, false, pin, tokens);
    }

    public static boolean parseTokensSmart(PsiBuilder builder, int pin, IElementType ... tokens) {
        return GeneratedParserUtilBase.parseTokens(builder, true, pin, tokens);
    }

    public static boolean parseTokens(PsiBuilder builder, boolean smart, int pin, IElementType ... tokens) {
        PsiBuilder.Marker marker = builder.mark();
        boolean result2 = GeneratedParserUtilBase.consumeTokens(builder, smart, pin, tokens);
        if (!result2) {
            marker.rollbackTo();
        } else {
            marker.drop();
        }
        return result2;
    }

    public static boolean consumeTokenSmart(PsiBuilder builder, IElementType token) {
        GeneratedParserUtilBase.addCompletionVariantSmart(builder, token);
        return GeneratedParserUtilBase.consumeTokenFast(builder, token);
    }

    public static boolean consumeTokenSmart(PsiBuilder builder, String token) {
        GeneratedParserUtilBase.addCompletionVariantSmart(builder, token);
        return GeneratedParserUtilBase.consumeTokenFast(builder, token);
    }

    public static boolean consumeToken(PsiBuilder builder, IElementType token) {
        GeneratedParserUtilBase.addVariantSmart(builder, token, true);
        if (GeneratedParserUtilBase.nextTokenIsFast(builder, token)) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeTokenFast(PsiBuilder builder, IElementType token) {
        if (GeneratedParserUtilBase.nextTokenIsFast(builder, token)) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeToken(PsiBuilder builder, String text) {
        return GeneratedParserUtilBase.consumeToken(builder, text, ErrorState.get(builder).caseSensitive);
    }

    public static boolean consumeToken(PsiBuilder builder, String text, boolean caseSensitive) {
        GeneratedParserUtilBase.addVariantSmart(builder, text, true);
        int count = GeneratedParserUtilBase.nextTokenIsFast(builder, text, caseSensitive);
        if (count > 0) {
            while (count-- > 0) {
                builder.advanceLexer();
            }
            return true;
        }
        return false;
    }

    public static boolean consumeTokenFast(PsiBuilder builder, String text) {
        int count = GeneratedParserUtilBase.nextTokenIsFast(builder, text, ErrorState.get(builder).caseSensitive);
        if (count > 0) {
            while (count-- > 0) {
                builder.advanceLexer();
            }
            return true;
        }
        return false;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder, IElementType token) {
        return builder.getTokenType() == token;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder, IElementType ... tokens) {
        IElementType tokenType = builder.getTokenType();
        for (IElementType token : tokens) {
            if (token != tokenType) continue;
            return true;
        }
        return false;
    }

    public static boolean nextTokenIsSmart(PsiBuilder builder, IElementType token) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder, token) || ErrorState.get((PsiBuilder)builder).completionState != null;
    }

    public static boolean nextTokenIsSmart(PsiBuilder builder, IElementType ... tokens) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder, tokens) || ErrorState.get((PsiBuilder)builder).completionState != null;
    }

    public static boolean nextTokenIs(PsiBuilder builder, String frameName, IElementType ... tokens) {
        ErrorState state = ErrorState.get(builder);
        if (state.completionState != null) {
            return true;
        }
        boolean track = !state.suppressErrors && state.predicateCount < 2 && state.predicateSign;
        return !track ? GeneratedParserUtilBase.nextTokenIsFast(builder, tokens) : GeneratedParserUtilBase.nextTokenIsSlow(builder, frameName, tokens);
    }

    public static boolean nextTokenIsSlow(PsiBuilder builder, String frameName, IElementType ... tokens) {
        ErrorState state = ErrorState.get(builder);
        IElementType tokenType = builder.getTokenType();
        if (StringUtil.isNotEmpty((String)frameName)) {
            GeneratedParserUtilBase.addVariantInner(state, builder.rawTokenIndex(), frameName);
        } else {
            for (IElementType token : tokens) {
                GeneratedParserUtilBase.addVariant(builder, state, token);
            }
        }
        if (tokenType == null) {
            return false;
        }
        for (IElementType token : tokens) {
            if (tokenType != token) continue;
            return true;
        }
        return false;
    }

    public static boolean nextTokenIs(PsiBuilder builder, IElementType token) {
        if (!GeneratedParserUtilBase.addVariantSmart(builder, token, false)) {
            return true;
        }
        return GeneratedParserUtilBase.nextTokenIsFast(builder, token);
    }

    public static boolean nextTokenIs(PsiBuilder builder, String tokenText) {
        if (!GeneratedParserUtilBase.addVariantSmart(builder, tokenText, false)) {
            return true;
        }
        return GeneratedParserUtilBase.nextTokenIsFast(builder, tokenText, ErrorState.get(builder).caseSensitive) > 0;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder, String tokenText) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder, tokenText, ErrorState.get(builder).caseSensitive) > 0;
    }

    public static int nextTokenIsFast(PsiBuilder builder, String tokenText, boolean caseSensitive) {
        int nextOffset;
        int endOffset;
        int offset;
        CharSequence sequence = builder.getOriginalText();
        CharSequence subSequence = sequence.subSequence(offset = builder.getCurrentOffset(), Math.min(endOffset = offset + tokenText.length(), sequence.length()));
        if (!Comparing.equal((CharSequence)subSequence, (CharSequence)tokenText, (boolean)caseSensitive)) {
            return 0;
        }
        int count = 0;
        do {
            if ((nextOffset = builder.rawTokenTypeStart(++count)) <= endOffset) continue;
            return -count;
        } while (nextOffset != endOffset);
        return count;
    }

    private static void addCompletionVariantSmart(PsiBuilder builder, Object token) {
        ErrorState state = ErrorState.get(builder);
        CompletionState completionState = state.completionState;
        if (completionState != null && state.predicateSign) {
            GeneratedParserUtilBase.addCompletionVariant(builder, completionState, token);
        }
    }

    private static boolean addVariantSmart(PsiBuilder builder, Object token, boolean force) {
        ErrorState state = ErrorState.get(builder);
        if (state.completionState != null && !force) {
            return false;
        }
        builder.eof();
        if (!state.suppressErrors && state.predicateCount < 2) {
            GeneratedParserUtilBase.addVariant(builder, state, token);
        }
        return true;
    }

    public static void addVariant(PsiBuilder builder, String text) {
        GeneratedParserUtilBase.addVariant(builder, ErrorState.get(builder), text);
    }

    private static void addVariant(PsiBuilder builder, ErrorState state, Object o) {
        builder.eof();
        GeneratedParserUtilBase.addVariantInner(state, builder.rawTokenIndex(), o);
        CompletionState completionState = state.completionState;
        if (completionState != null && state.predicateSign) {
            GeneratedParserUtilBase.addCompletionVariant(builder, completionState, o);
        }
    }

    private static void addVariantInner(ErrorState state, int pos, Object o) {
        Variant variant = ((Variant)state.VARIANTS.alloc()).init(pos, o);
        if (state.predicateSign) {
            state.variants.add(variant);
            if (state.lastExpectedVariantPos < variant.position) {
                state.lastExpectedVariantPos = variant.position;
            }
        } else {
            state.unexpected.add(variant);
        }
    }

    private static void addCompletionVariant(@NotNull PsiBuilder builder, @NotNull CompletionState completionState, Object o) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/parser/GeneratedParserUtilBase", "addCompletionVariant"));
        }
        if (completionState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionState", "com/intellij/lang/parser/GeneratedParserUtilBase", "addCompletionVariant"));
        }
        int offset = builder.getCurrentOffset();
        if (!builder.eof() && offset == builder.rawTokenTypeStart(1)) {
            return;
        }
        String text = completionState.convertItem(o);
        int length = text == null ? 0 : text.length();
        boolean add = length != 0 && completionState.prefixMatches(builder, text);
        boolean bl = add = !(!add || length <= 1 || text.charAt(0) == '<' && text.charAt(length - 1) == '>' || text.charAt(0) == '\'' && text.charAt(length - 1) == '\'' && length < 5);
        if (add) {
            completionState.addItem(builder, text);
        }
    }

    public static boolean isWhitespaceOrComment(@NotNull PsiBuilder builder, @Nullable IElementType type) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/parser/GeneratedParserUtilBase", "isWhitespaceOrComment"));
        }
        return ((PsiBuilderImpl)((Builder)builder).getDelegate()).whitespaceOrComment(type);
    }

    private static boolean wasAutoSkipped(@NotNull PsiBuilder builder, int steps) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/parser/GeneratedParserUtilBase", "wasAutoSkipped"));
        }
        for (int i2 = -1; i2 >= -steps; --i2) {
            if (GeneratedParserUtilBase.isWhitespaceOrComment(builder, builder.rawLookup(i2))) continue;
            return false;
        }
        return true;
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder) {
        ++ErrorState.get((PsiBuilder)builder).level;
        return builder.mark();
    }

    public static void exit_section_(PsiBuilder builder, PsiBuilder.Marker marker, @Nullable IElementType elementType, boolean result2) {
        ErrorState state = ErrorState.get(builder);
        GeneratedParserUtilBase.close_marker_impl_(state.currentFrame, marker, elementType, result2);
        GeneratedParserUtilBase.run_hooks_impl_(builder, state, (IElementType)(result2 ? elementType : null));
        --state.level;
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder, int level, int modifiers, String frameName) {
        return GeneratedParserUtilBase.enter_section_(builder, level, modifiers, null, frameName);
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder, int level, int modifiers) {
        return GeneratedParserUtilBase.enter_section_(builder, level, modifiers, null, null);
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder, int level, int modifiers, IElementType elementType, String frameName) {
        PsiBuilder.Marker marker = builder.mark();
        GeneratedParserUtilBase.enter_section_impl_(builder, level, modifiers, elementType, frameName);
        return marker;
    }

    private static void enter_section_impl_(PsiBuilder builder, int level, int modifiers, IElementType elementType, String frameName) {
        PsiBuilder.Marker left;
        ErrorState state = ErrorState.get(builder);
        ++state.level;
        Frame frame = ((Frame)state.FRAMES.alloc()).init(builder, state, level, modifiers, elementType, frameName);
        Frame prevFrame = state.currentFrame;
        if (prevFrame != null && prevFrame.errorReportedAt > frame.position) {
            GeneratedParserUtilBase.reportError(builder, state, frame, null, true, false);
        }
        if ((frame.modifiers & 2 | frame.modifiers & 4) != 0 && GeneratedParserUtilBase.invalid_left_marker_guard_(builder, left = (PsiBuilder.Marker)builder.getLatestDoneMarker(), frameName)) {
            frame.leftMarker = left;
        }
        state.currentFrame = frame;
        if ((modifiers & 8) != 0) {
            if (state.predicateCount == 0 && !state.predicateSign) {
                throw new AssertionError((Object)"Incorrect false predicate sign");
            }
            ++state.predicateCount;
        } else if ((modifiers & 0x10) != 0) {
            state.predicateSign = state.predicateCount != 0 && !state.predicateSign;
            ++state.predicateCount;
        }
    }

    public static void exit_section_(PsiBuilder builder, int level, PsiBuilder.Marker marker, boolean result2, boolean pinned, @Nullable Parser eatMore) {
        GeneratedParserUtilBase.exit_section_(builder, level, marker, null, result2, pinned, eatMore);
    }

    public static void exit_section_(PsiBuilder builder, int level, PsiBuilder.Marker marker, @Nullable IElementType elementType, boolean result2, boolean pinned, @Nullable Parser eatMore) {
        ErrorState state = ErrorState.get(builder);
        Frame frame = state.currentFrame;
        Frame frame2 = state.currentFrame = frame == null ? null : frame.parentFrame;
        if (frame != null && frame.elementType != null) {
            elementType = frame.elementType;
        }
        if (frame == null || level != frame.level) {
            LOG.error("Unbalanced error section: got " + frame + ", expected level " + level);
            if (frame != null) {
                state.FRAMES.recycle((Object)frame);
            }
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, elementType, result2);
            return;
        }
        if ((frame.modifiers & 8 | frame.modifiers & 0x10) != 0) {
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
            GeneratedParserUtilBase.replace_variants_with_name_(state, frame, builder, result2, pinned);
            --state.predicateCount;
            if ((frame.modifiers & 0x10) != 0) {
                state.predicateSign = !state.predicateSign;
            }
        } else {
            GeneratedParserUtilBase.close_frame_impl_(state, frame, builder, marker, elementType, result2, pinned);
            GeneratedParserUtilBase.exit_section_impl_(state, frame, builder, elementType, result2, pinned, eatMore);
        }
        GeneratedParserUtilBase.run_hooks_impl_(builder, state, (IElementType)(pinned || result2 ? elementType : null));
        state.FRAMES.recycle((Object)frame);
        --state.level;
    }

    public static <T> void register_hook_(PsiBuilder builder, Hook<T> hook, T param) {
        ErrorState state = ErrorState.get(builder);
        state.hooks = Hooks.concat(hook, param, state.level, state.hooks);
    }

    @SafeVarargs
    public static <T> void register_hook_(PsiBuilder builder, Hook<T[]> hook, T ... param) {
        ErrorState state = ErrorState.get(builder);
        state.hooks = Hooks.concat(hook, param, state.level, state.hooks);
    }

    private static void run_hooks_impl_(PsiBuilder builder, ErrorState state, @Nullable IElementType elementType) {
        PsiBuilder.Marker marker;
        if (state.hooks == null) {
            return;
        }
        PsiBuilder.Marker marker2 = marker = elementType == null ? null : (PsiBuilder.Marker)builder.getLatestDoneMarker();
        if (elementType != null && marker == null) {
            builder.mark().error("No expected done marker at offset " + builder.getCurrentOffset());
        }
        while (state.hooks != null && state.hooks.level >= state.level) {
            if (state.hooks.level == state.level) {
                marker = state.hooks.hook.run(builder, marker, state.hooks.param);
            }
            state.hooks = state.hooks.next;
        }
    }

    private static void exit_section_impl_(ErrorState state, Frame frame, PsiBuilder builder, @Nullable IElementType elementType, boolean result2, boolean pinned, @Nullable Parser eatMore) {
        Frame prevFrame;
        int initialPos = builder.rawTokenIndex();
        boolean willFail = !result2 && !pinned;
        GeneratedParserUtilBase.replace_variants_with_name_(state, frame, builder, result2, pinned);
        int lastErrorPos = GeneratedParserUtilBase.getLastVariantPos(state, initialPos);
        if (!state.suppressErrors && eatMore != null) {
            boolean errorReported;
            state.suppressErrors = true;
            boolean eatMoreFlagOnce = !builder.eof() && eatMore.parse(builder, frame.level + 1);
            boolean eatMoreFlag = eatMoreFlagOnce || !result2 && frame.position == initialPos && lastErrorPos > frame.position;
            PsiBuilderImpl.ProductionMarker latestDoneMarker = !(!pinned && !result2 || !state.altMode && elementType == null || !eatMoreFlagOnce) ? (PsiBuilderImpl.ProductionMarker)builder.getLatestDoneMarker() : null;
            PsiBuilder.Marker extensionMarker = null;
            IElementType extensionTokenType = null;
            if (latestDoneMarker != null && frame.position >= latestDoneMarker.getStartIndex() && frame.position <= latestDoneMarker.getEndIndex()) {
                extensionMarker = ((PsiBuilder.Marker)latestDoneMarker).precede();
                extensionTokenType = latestDoneMarker.getTokenType();
                ((PsiBuilder.Marker)latestDoneMarker).drop();
            }
            int parenCount = 0;
            while ((eatMoreFlag || parenCount > 0) && builder.rawTokenIndex() < lastErrorPos) {
                IElementType tokenType = builder.getTokenType();
                if (state.braces != null) {
                    if (tokenType == state.braces[0].getLeftBraceType()) {
                        ++parenCount;
                    } else if (tokenType == state.braces[0].getRightBraceType()) {
                        --parenCount;
                    }
                }
                if (builder.rawTokenIndex() >= lastErrorPos) break;
                builder.advanceLexer();
                eatMoreFlag = eatMore.parse(builder, frame.level + 1);
            }
            boolean bl = errorReported = frame.errorReportedAt == initialPos || !result2 && frame.errorReportedAt >= frame.position;
            if (errorReported) {
                if (eatMoreFlag) {
                    builder.advanceLexer();
                    GeneratedParserUtilBase.parseAsTree(state, builder, frame.level + 1, DUMMY_BLOCK, true, TOKEN_ADVANCER, eatMore);
                }
            } else if (eatMoreFlag) {
                errorReported = GeneratedParserUtilBase.reportError(builder, state, frame, null, true, true);
                GeneratedParserUtilBase.parseAsTree(state, builder, frame.level + 1, DUMMY_BLOCK, true, TOKEN_ADVANCER, eatMore);
            } else if (eatMoreFlagOnce || !result2 && frame.position != builder.rawTokenIndex() || frame.errorReportedAt > initialPos) {
                errorReported = GeneratedParserUtilBase.reportError(builder, state, frame, null, true, false);
            } else if (!result2 && pinned && frame.errorReportedAt < 0) {
                errorReported = GeneratedParserUtilBase.reportError(builder, state, frame, elementType, false, false);
            }
            if (extensionMarker != null) {
                extensionMarker.done(extensionTokenType);
            }
            state.suppressErrors = false;
            if (errorReported || result2) {
                state.clearVariants(true, 0);
                state.clearVariants(false, 0);
                state.lastExpectedVariantPos = -1;
            }
        } else if (!result2 && pinned && frame.errorReportedAt < 0) {
            if (lastErrorPos == initialPos) {
                GeneratedParserUtilBase.reportError(builder, state, frame, elementType, false, false);
            } else if (lastErrorPos > initialPos) {
                frame.errorReportedAt = lastErrorPos;
            }
        }
        Frame frame2 = prevFrame = willFail && eatMore == null ? null : state.currentFrame;
        if (prevFrame != null && prevFrame.errorReportedAt < frame.errorReportedAt) {
            prevFrame.errorReportedAt = frame.errorReportedAt;
        }
    }

    private static void close_frame_impl_(ErrorState state, Frame frame, PsiBuilder builder, PsiBuilder.Marker marker, IElementType elementType, boolean result2, boolean pinned) {
        if (elementType != null && marker != null) {
            if (result2 || pinned) {
                PsiBuilderImpl.ProductionMarker last;
                if ((frame.modifiers & 1) != 0 && (last = (PsiBuilderImpl.ProductionMarker)builder.getLatestDoneMarker()) != null && last.getStartIndex() == frame.position && state.typeExtends(last.getTokenType(), elementType) && GeneratedParserUtilBase.wasAutoSkipped(builder, builder.rawTokenIndex() - last.getEndIndex())) {
                    elementType = last.getTokenType();
                    ((PsiBuilder.Marker)last).drop();
                }
                if ((frame.modifiers & 0x20) != 0) {
                    marker.drop();
                    Frame f = frame.parentFrame;
                    while (f != null) {
                        if (f.elementType != null) {
                            f.elementType = elementType;
                            break;
                        }
                        f = f.parentFrame;
                    }
                } else if ((frame.modifiers & 4) != 0 && frame.leftMarker != null) {
                    marker.done(elementType);
                    frame.leftMarker.precede().done(((LighterASTNode)frame.leftMarker).getTokenType());
                    frame.leftMarker.drop();
                } else if ((frame.modifiers & 2) != 0 && frame.leftMarker != null) {
                    marker.drop();
                    frame.leftMarker.precede().done(elementType);
                } else {
                    if (frame.level == 0) {
                        builder.eof();
                    }
                    marker.done(elementType);
                }
            } else {
                GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
            }
        } else if (result2 || pinned) {
            if (marker != null) {
                marker.drop();
            }
            if ((frame.modifiers & 4) != 0 && frame.leftMarker != null) {
                frame.leftMarker.precede().done(((LighterASTNode)frame.leftMarker).getTokenType());
                frame.leftMarker.drop();
            }
        } else {
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
        }
    }

    private static void close_marker_impl_(Frame frame, PsiBuilder.Marker marker, IElementType elementType, boolean result2) {
        if (marker == null) {
            return;
        }
        if (result2) {
            if (elementType != null) {
                marker.done(elementType);
            } else {
                marker.drop();
            }
        } else {
            int position;
            if (frame != null && frame.errorReportedAt > (position = ((PsiBuilderImpl.ProductionMarker)marker).getStartIndex()) && frame.parentFrame != null) {
                frame.errorReportedAt = frame.parentFrame.errorReportedAt;
            }
            marker.rollbackTo();
        }
    }

    private static void replace_variants_with_name_(ErrorState state, Frame frame, PsiBuilder builder, boolean result2, boolean pinned) {
        boolean willFail;
        int initialPos = builder.rawTokenIndex();
        boolean bl = willFail = !result2 && !pinned;
        if (willFail && initialPos == frame.position && state.lastExpectedVariantPos == frame.position && frame.name != null && state.variants.size() - frame.variantCount > 1) {
            state.clearVariants(true, frame.variantCount);
            GeneratedParserUtilBase.addVariantInner(state, initialPos, frame.name);
        }
    }

    public static boolean report_error_(PsiBuilder builder, boolean result2) {
        if (!result2) {
            GeneratedParserUtilBase.report_error_(builder, ErrorState.get(builder), false);
        }
        return result2;
    }

    public static void report_error_(PsiBuilder builder, ErrorState state, boolean advance) {
        Frame frame = state.currentFrame;
        if (frame == null) {
            LOG.error("unbalanced enter/exit section call: got null");
            return;
        }
        int position = builder.rawTokenIndex();
        if (frame.errorReportedAt < position && GeneratedParserUtilBase.getLastVariantPos(state, position + 1) <= position) {
            GeneratedParserUtilBase.reportError(builder, state, frame, null, true, advance);
        }
    }

    public static boolean withProtectedLastVariantPos(PsiBuilder builder, int level, Parser parser) {
        ErrorState state = ErrorState.get(builder);
        int backup = state.lastExpectedVariantPos;
        boolean result2 = parser.parse(builder, level);
        state.lastExpectedVariantPos = backup;
        return result2;
    }

    private static int getLastVariantPos(ErrorState state, int defValue) {
        return state.lastExpectedVariantPos < 0 ? defValue : state.lastExpectedVariantPos;
    }

    private static boolean reportError(PsiBuilder builder, ErrorState state, Frame frame, IElementType elementType, boolean force, boolean advance) {
        String expectedText = state.getExpectedText(builder);
        boolean notEmpty = StringUtil.isNotEmpty((String)expectedText);
        if (!(force || notEmpty || advance)) {
            return false;
        }
        String actual = "'" + StringUtil.first((String)StringUtil.notNullize((String)builder.getTokenText(), (String)"null"), (int)20, (boolean)true) + "'";
        String message = expectedText + (builder.eof() ? "unexpected end of file" : (notEmpty ? "got " + actual : actual + " unexpected"));
        if (advance) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.error(message);
        } else if (!force) {
            PsiBuilderImpl.ProductionMarker latestDoneMarker;
            PsiBuilder.Marker extensionMarker = null;
            IElementType extensionTokenType = null;
            PsiBuilderImpl.ProductionMarker productionMarker = latestDoneMarker = elementType == null ? null : (PsiBuilderImpl.ProductionMarker)builder.getLatestDoneMarker();
            if (latestDoneMarker != null && frame.position >= latestDoneMarker.getStartIndex() && frame.position <= latestDoneMarker.getEndIndex()) {
                extensionMarker = ((PsiBuilder.Marker)latestDoneMarker).precede();
                extensionTokenType = latestDoneMarker.getTokenType();
                ((PsiBuilder.Marker)latestDoneMarker).drop();
            }
            builder.error(message);
            if (extensionMarker != null) {
                extensionMarker.done(extensionTokenType);
            }
        } else {
            builder.error(message);
        }
        builder.eof();
        frame.errorReportedAt = builder.rawTokenIndex();
        return true;
    }

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder, PsiParser parser) {
        return GeneratedParserUtilBase.adapt_builder_(root, builder, parser, null);
    }

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder, PsiParser parser, TokenSet[] extendsSets) {
        ErrorState state = new ErrorState();
        ErrorState.initState(state, builder, root, extendsSets);
        return new Builder(builder, state, parser);
    }

    public static boolean parseAsTree(ErrorState state, PsiBuilder builder, int level, IElementType chunkType, boolean checkBraces, Parser parser, Parser eatMoreCondition) {
        LinkedList<Pair> parenList = new LinkedList<Pair>();
        LinkedList<Pair> siblingList = new LinkedList<Pair>();
        PsiBuilder.Marker marker = null;
        Runnable checkSiblingsRunnable = () -> {
            block0: while (!siblingList.isEmpty()) {
                Pair parenPair = (Pair)parenList.peek();
                int rating = (Integer)((Pair)siblingList.getFirst()).second;
                int count = 0;
                for (Pair pair : siblingList) {
                    if ((Integer)pair.second != rating || parenPair != null && pair.first == parenPair.second) break block0;
                    if (++count < 10) continue;
                    PsiBuilder.Marker parentMarker = ((PsiBuilder.Marker)pair.first).precede();
                    parentMarker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
                    while (count-- > 0) {
                        siblingList.removeFirst();
                    }
                    parentMarker.done(chunkType);
                    siblingList.addFirst(Pair.create((Object)parentMarker, (Object)(rating + 1)));
                    continue block0;
                }
            }
        };
        boolean checkParens = state.braces != null && checkBraces;
        int totalCount = 0;
        int tokenCount = 0;
        if (checkParens) {
            LighterASTNode doneMarker;
            int tokenIdx = -1;
            while (builder.rawLookup(tokenIdx) == TokenType.WHITE_SPACE) {
                --tokenIdx;
            }
            LighterASTNode lighterASTNode = doneMarker = builder.rawLookup(tokenIdx) == state.braces[0].getLeftBraceType() ? builder.getLatestDoneMarker() : null;
            if (doneMarker != null && doneMarker.getStartOffset() == builder.rawTokenTypeStart(tokenIdx) && doneMarker.getTokenType() == TokenType.ERROR_ELEMENT) {
                parenList.add(Pair.create((Object)((PsiBuilder.Marker)doneMarker).precede(), null));
            }
        }
        int c = GeneratedParserUtilBase.current_position_(builder);
        while (true) {
            IElementType tokenType = builder.getTokenType();
            if (checkParens && (tokenType == state.braces[0].getLeftBraceType() || tokenType == state.braces[0].getRightBraceType() && !parenList.isEmpty())) {
                if (marker != null) {
                    marker.done(chunkType);
                    siblingList.addFirst(Pair.create((Object)marker, (Object)1));
                    marker = null;
                    tokenCount = 0;
                }
                if (tokenType == state.braces[0].getLeftBraceType()) {
                    Pair prev = (Pair)siblingList.peek();
                    parenList.addFirst(Pair.create((Object)builder.mark(), prev == null ? null : (PsiBuilder.Marker)prev.first));
                }
                checkSiblingsRunnable.run();
                builder.advanceLexer();
                if (tokenType == state.braces[0].getRightBraceType()) {
                    Pair pair = (Pair)parenList.removeFirst();
                    ((PsiBuilder.Marker)pair.first).done(chunkType);
                    while (!siblingList.isEmpty() && ((Pair)siblingList.getFirst()).first != pair.second) {
                        siblingList.removeFirst();
                    }
                    siblingList.addFirst(Pair.create((Object)pair.first, (Object)1));
                    checkSiblingsRunnable.run();
                }
            } else {
                boolean result2;
                if (marker == null) {
                    marker = builder.mark();
                    marker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
                }
                boolean bl = result2 = (!parenList.isEmpty() || eatMoreCondition.parse(builder, level + 1)) && parser.parse(builder, level + 1);
                if (result2) {
                    ++tokenCount;
                    ++totalCount;
                }
                if (!result2) break;
            }
            if (tokenCount >= 10) {
                marker.done(chunkType);
                siblingList.addFirst(Pair.create((Object)marker, (Object)1));
                checkSiblingsRunnable.run();
                marker = null;
                tokenCount = 0;
            }
            if (!GeneratedParserUtilBase.empty_element_parsed_guard_(builder, "parseAsTree", c)) break;
            c = GeneratedParserUtilBase.current_position_(builder);
        }
        if (marker != null) {
            marker.drop();
        }
        for (Pair pair : parenList) {
            ((PsiBuilder.Marker)pair.first).drop();
        }
        return totalCount != 0;
    }

    private static class MyList<E>
    extends ArrayList<E> {
        MyList(int initialCapacity) {
            super(initialCapacity);
        }

        protected void setSize(int fromIndex) {
            this.removeRange(fromIndex, this.size());
        }

        @Override
        public boolean add(E e) {
            int size = this.size();
            if (size >= 10000) {
                this.removeRange(2500, size - 2500);
            }
            return super.add(e);
        }
    }

    public static class DummyBlock
    extends CompositePsiElement {
        DummyBlock() {
            super(DUMMY_BLOCK);
        }

        @Override
        @NotNull
        public PsiReference[] getReferences() {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/parser/GeneratedParserUtilBase$DummyBlock", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public Language getLanguage() {
            Language language = this.getParent().getLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/parser/GeneratedParserUtilBase$DummyBlock", "getLanguage"));
            }
            return language;
        }
    }

    private static class DummyBlockElementType
    extends IElementType
    implements ICompositeElementType {
        DummyBlockElementType() {
            super("DUMMY_BLOCK", Language.ANY);
        }

        @NotNull
        public ASTNode createCompositeNode() {
            DummyBlock dummyBlock = new DummyBlock();
            if (dummyBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/parser/GeneratedParserUtilBase$DummyBlockElementType", "createCompositeNode"));
            }
            return dummyBlock;
        }
    }

    private static class Hooks<T> {
        final Hook<T> hook;
        final T param;
        final int level;
        final Hooks<?> next;

        Hooks(Hook<T> hook, T param, int level, Hooks next) {
            this.hook = hook;
            this.param = param;
            this.level = level;
            this.next = next;
        }

        static <E> Hooks<E> concat(Hook<E> hook, E param, int level, Hooks<?> hooks) {
            return new Hooks<E>(hook, param, level, hooks);
        }
    }

    private static class Variant {
        int position;
        Object object;

        private Variant() {
        }

        public Variant init(int pos, Object o) {
            this.position = pos;
            this.object = o;
            return this;
        }

        public String toString() {
            return "<" + this.position + ", " + this.object + ">";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variant variant = (Variant)o;
            if (this.position != variant.position) {
                return false;
            }
            return this.object.equals(variant.object);
        }

        public int hashCode() {
            int result2 = this.position;
            result2 = 31 * result2 + this.object.hashCode();
            return result2;
        }
    }

    public static class Frame {
        public Frame parentFrame;
        public IElementType elementType;
        public int offset;
        public int position;
        public int level;
        public int modifiers;
        public String name;
        public int variantCount;
        public int errorReportedAt;
        public PsiBuilder.Marker leftMarker;

        public Frame init(PsiBuilder builder, ErrorState state, int level_, int modifiers_, IElementType elementType_, String name_) {
            this.parentFrame = state.currentFrame;
            this.elementType = elementType_;
            this.offset = builder.getCurrentOffset();
            this.position = builder.rawTokenIndex();
            this.level = level_;
            this.modifiers = modifiers_;
            this.name = name_;
            this.variantCount = state.variants.size();
            this.errorReportedAt = -1;
            this.leftMarker = null;
            return this;
        }

        public String toString() {
            String mod = this.modifiers == 0 ? "_NONE_, " : ((this.modifiers & 1) != 0 ? "_CAN_COLLAPSE_, " : "") + ((this.modifiers & 2) != 0 ? "_LEFT_, " : "") + ((this.modifiers & 4) != 0 ? "_LEFT_INNER_, " : "") + ((this.modifiers & 8) != 0 ? "_AND_, " : "") + ((this.modifiers & 0x10) != 0 ? "_NOT_, " : "") + ((this.modifiers & 0x20) != 0 ? "_UPPER_, " : "");
            return String.format("{%s:%s:%d, %d, %s%s, %s}", this.offset, this.position, this.level, this.errorReportedAt, mod, this.elementType, this.name);
        }
    }

    public static class ErrorState {
        TokenSet[] extendsSets;
        public PairProcessor<IElementType, IElementType> altExtendsChecker;
        int predicateCount;
        int level;
        boolean predicateSign = true;
        boolean suppressErrors;
        Hooks<?> hooks;
        public Frame currentFrame;
        public CompletionState completionState;
        private boolean caseSensitive;
        public BracePair[] braces;
        public boolean altMode;
        int lastExpectedVariantPos = -1;
        MyList<Variant> variants = new MyList(1000);
        MyList<Variant> unexpected = new MyList(100);
        final LimitedPool<Variant> VARIANTS = new LimitedPool(10000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<Variant>(){

            @NotNull
            public Variant create() {
                Variant variant = new Variant();
                if (variant == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState$1", "create"));
                }
                return variant;
            }

            public void cleanup(@NotNull Variant o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState$1", "cleanup"));
                }
            }
        });
        final LimitedPool<Frame> FRAMES = new LimitedPool(500, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<Frame>(){

            @NotNull
            public Frame create() {
                Frame frame = new Frame();
                if (frame == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState$2", "create"));
                }
                return frame;
            }

            public void cleanup(@NotNull Frame o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState$2", "cleanup"));
                }
            }
        });

        public static ErrorState get(PsiBuilder builder) {
            return ((Builder)builder).state;
        }

        public static void initState(ErrorState state, PsiBuilder builder, IElementType root, TokenSet[] extendsSets) {
            state.extendsSets = extendsSets;
            PsiFile file2 = (PsiFile)builder.getUserDataUnprotected(FileContextUtil.CONTAINING_FILE_KEY);
            state.completionState = file2 == null ? null : (CompletionState)file2.getUserData(COMPLETION_STATE_KEY);
            Language language = file2 == null ? root.getLanguage() : file2.getLanguage();
            state.caseSensitive = language.isCaseSensitive();
            PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(language);
            BracePair[] bracePairArray = state.braces = matcher == null ? null : matcher.getPairs();
            if (state.braces != null && state.braces.length == 0) {
                state.braces = null;
            }
        }

        public String getExpectedText(PsiBuilder builder) {
            StringBuilder sb = new StringBuilder();
            int position = builder.rawTokenIndex();
            if (this.addExpected(sb, position, true)) {
                sb.append(" expected, ");
            }
            return sb.toString();
        }

        private boolean addExpected(StringBuilder sb, int position, boolean expected) {
            MyList<Variant> list = expected ? this.variants : this.unexpected;
            Object[] strings = new String[list.size()];
            long[] hashes = new long[strings.length];
            Arrays.fill(strings, "");
            int count = 0;
            block0: for (Variant variant : list) {
                if (position != variant.position) continue;
                String text = variant.object.toString();
                long hash = StringHash.calc((String)text);
                for (int i2 = 0; i2 < count; ++i2) {
                    if (hashes[i2] == hash) continue block0;
                }
                hashes[count] = hash;
                strings[count] = text;
                ++count;
            }
            Arrays.sort(strings);
            count = 0;
            for (Object s : strings) {
                char c;
                if (((String)s).length() == 0) continue;
                if (count++ > 0) {
                    if (count > 50) {
                        sb.append(" and ...");
                        break;
                    }
                    sb.append(", ");
                }
                Object displayText = (c = ((String)s).charAt(0)) == '<' || StringUtil.isJavaIdentifierStart((char)c) ? s : '\'' + (String)s + '\'';
                sb.append((String)displayText);
            }
            if (count > 1 && count < 50) {
                int idx = sb.lastIndexOf(", ");
                sb.replace(idx, idx + 1, " or");
            }
            return count > 0;
        }

        public void clearVariants(Frame frame) {
            this.clearVariants(true, frame == null ? 0 : frame.variantCount);
        }

        void clearVariants(boolean expected, int start) {
            MyList<Variant> list;
            MyList<Variant> myList = list = expected ? this.variants : this.unexpected;
            if (start < 0 || start >= list.size()) {
                return;
            }
            int len = list.size();
            for (int i2 = start; i2 < len; ++i2) {
                this.VARIANTS.recycle(list.get(i2));
            }
            list.setSize(start);
        }

        public boolean typeExtends(IElementType child, IElementType parent) {
            if (child == parent) {
                return true;
            }
            if (this.extendsSets != null) {
                for (TokenSet set2 : this.extendsSets) {
                    if (!set2.contains(child) || !set2.contains(parent)) continue;
                    return true;
                }
            }
            return this.altExtendsChecker != null && this.altExtendsChecker.process((Object)child, (Object)parent);
        }
    }

    public static class Builder
    extends PsiBuilderAdapter {
        public final ErrorState state;
        public final PsiParser parser;

        public Builder(PsiBuilder builder, ErrorState state_, PsiParser parser_) {
            super(builder);
            this.state = state_;
            this.parser = parser_;
        }

        public Lexer getLexer() {
            return ((PsiBuilderImpl)this.myDelegate).getLexer();
        }
    }

    public static class CompletionState
    implements Function<Object, String> {
        public final int offset;
        public final Collection<String> items = ContainerUtil.newTroveSet();

        public CompletionState(int offset_) {
            this.offset = offset_;
        }

        @Nullable
        public String convertItem(Object o) {
            return o instanceof Object[] ? StringUtil.join((Object[])((Object[])o), (Function)this, (String)" ") : o.toString();
        }

        public String fun(Object o) {
            return this.convertItem(o);
        }

        public void addItem(@NotNull PsiBuilder builder, @NotNull String text) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/parser/GeneratedParserUtilBase$CompletionState", "addItem"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/parser/GeneratedParserUtilBase$CompletionState", "addItem"));
            }
            this.items.add(text);
        }

        public boolean prefixMatches(@NotNull PsiBuilder builder, @NotNull String text) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/parser/GeneratedParserUtilBase$CompletionState", "prefixMatches"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/parser/GeneratedParserUtilBase$CompletionState", "prefixMatches"));
            }
            int builderOffset = builder.getCurrentOffset();
            int diff = this.offset - builderOffset;
            int length = text.length();
            if (diff == 0) {
                return true;
            }
            if (diff > 0 && diff <= length) {
                CharSequence fragment = builder.getOriginalText().subSequence(builderOffset, this.offset);
                return this.prefixMatches(fragment.toString(), text);
            }
            if (diff < 0) {
                int i2 = -1;
                while (true) {
                    IElementType type = builder.rawLookup(i2);
                    int tokenStart = builder.rawTokenTypeStart(i2);
                    if (!GeneratedParserUtilBase.isWhitespaceOrComment(builder, type)) {
                        CharSequence fragment;
                        if (type == null || tokenStart >= this.offset || !this.prefixMatches((fragment = builder.getOriginalText().subSequence(tokenStart, this.offset)).toString(), text)) break;
                        diff = this.offset - tokenStart;
                        break;
                    }
                    diff = this.offset - tokenStart;
                    --i2;
                }
                return diff >= 0 && diff < length;
            }
            return false;
        }

        public boolean prefixMatches(@NotNull String prefix, @NotNull String variant) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/parser/GeneratedParserUtilBase$CompletionState", "prefixMatches"));
            }
            if (variant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/intellij/lang/parser/GeneratedParserUtilBase$CompletionState", "prefixMatches"));
            }
            boolean matches = new CamelHumpMatcher(prefix, false).prefixMatches(variant.replace(' ', '_'));
            if (matches && StringUtil.isWhiteSpace((char)prefix.charAt(prefix.length() - 1))) {
                return StringUtil.startsWithIgnoreCase((String)variant, (String)prefix);
            }
            return matches;
        }
    }

    public static interface Hook<T> {
        @Contract(value="_,null,_->null")
        public PsiBuilder.Marker run(PsiBuilder var1, PsiBuilder.Marker var2, T var3);
    }

    public static interface Parser {
        public boolean parse(PsiBuilder var1, int var2);
    }
}

