/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.notification.EventLogCategory;
import com.intellij.notification.EventLogConsole;
import com.intellij.notification.EventLogToolWindowFactory;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsAdapter;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLog {
    public static final String LOG_REQUESTOR = "Internal log requestor";
    public static final String LOG_TOOL_WINDOW_ID = "Event Log";
    public static final String HELP_ID = "reference.toolwindows.event.log";
    private static final String A_CLOSING = "</a>";
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static final Pattern A_PATTERN = Pattern.compile("<a ([^>]* )?href=[\"']([^>]*)[\"'][^>]*>");
    private static final Set<String> NEW_LINES = ContainerUtil.newHashSet((Object[])new String[]{"<br>", "</br>", "<br/>", "<p>", "</p>", "<p/>", "<pre>", "</pre>"});
    private static final String DEFAULT_CATEGORY = "";
    private final LogModel myModel = new LogModel(null, (Disposable)ApplicationManager.getApplication());
    private static final String[] HTML_TAGS = new String[]{"a", "abbr", "acronym", "address", "applet", "area", "article", "aside", "audio", "b", "base", "basefont", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "command", "datalist", "dd", "del", "details", "dfn", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "font", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "iframe", "img", "input", "ins", "kbd", "keygen", "label", "legend", "li", "link", "map", "mark", "menu", "meta", "meter", "nav", "noframes", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "small", "source", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"};
    private static final String[] SKIP_TAGS = new String[]{"html", "body", "b", "i", "font"};

    public EventLog() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new NotificationsAdapter(){

            public void notify(@NotNull Notification notification) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$1", "notify"));
                }
                Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                if (openProjects.length == 0) {
                    EventLog.this.myModel.addNotification(notification);
                }
                for (Project p : openProjects) {
                    EventLog.getProjectComponent(p).printNotification(notification);
                }
            }
        });
    }

    public static void expireNotification(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog", "expireNotification"));
        }
        EventLog.getApplicationComponent().myModel.removeNotification(notification);
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            EventLog.getProjectComponent(p).myProjectModel.removeNotification(notification);
        }
    }

    public static void showNotification(@NotNull Project project2, @NotNull String groupId, @NotNull List<String> ids) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/EventLog", "showNotification"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/EventLog", "showNotification"));
        }
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/notification/EventLog", "showNotification"));
        }
        EventLog.getProjectComponent(project2).showNotification(groupId, ids);
    }

    private static EventLog getApplicationComponent() {
        return (EventLog)ApplicationManager.getApplication().getComponent(EventLog.class);
    }

    @NotNull
    public static LogModel getLogModel(@Nullable Project project2) {
        LogModel logModel = project2 != null ? EventLog.getProjectComponent(project2).myProjectModel : EventLog.getApplicationComponent().myModel;
        if (logModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "getLogModel"));
        }
        return logModel;
    }

    public static void markAllAsRead(@Nullable Project project2) {
        LogModel model = EventLog.getLogModel(project2);
        HashSet<String> groups = new HashSet<String>();
        for (Notification notification : model.getNotifications()) {
            groups.add(notification.getGroupId());
            model.removeNotification(notification);
            notification.expire();
        }
        if (project2 != null && !groups.isEmpty()) {
            EventLog.clearNMore(project2, groups);
        }
    }

    public static void clearNMore(@NotNull Project project2, @NotNull Collection<String> groups) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/EventLog", "clearNMore"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/notification/EventLog", "clearNMore"));
        }
        EventLog.getProjectComponent(project2).clearNMore(groups);
    }

    @Nullable
    public static Trinity<Notification, String, Long> getStatusMessage(@Nullable Project project2) {
        return EventLog.getLogModel(project2).getStatusMessage();
    }

    public static LogEntry formatForLog(final @NotNull Notification notification, String indent) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog", "formatForLog"));
        }
        DocumentImpl logDoc = new DocumentImpl(DEFAULT_CATEGORY, true);
        AtomicBoolean showMore = new AtomicBoolean(false);
        LinkedHashMap links = new LinkedHashMap();
        ArrayList<RangeMarker> lineSeparators = new ArrayList<RangeMarker>();
        String title = notification.getTitle();
        String subtitle = notification.getSubtitle();
        if (StringUtil.isNotEmpty((String)title) && StringUtil.isNotEmpty((String)subtitle)) {
            title = title + " (" + subtitle + ")";
        }
        title = EventLog.truncateLongString(showMore, title);
        String content = EventLog.truncateLongString(showMore, notification.getContent());
        RangeMarker afterTitle = null;
        boolean hasHtml = EventLog.parseHtmlContent(EventLog.addIndents(title, indent), notification, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        if (StringUtil.isNotEmpty((String)title) && StringUtil.isNotEmpty((String)content)) {
            EventLog.appendText(logDoc, ": ");
            afterTitle = logDoc.createRangeMarker(logDoc.getTextLength() - 2, logDoc.getTextLength());
        }
        int titleLength = logDoc.getTextLength();
        hasHtml |= EventLog.parseHtmlContent(EventLog.addIndents(content, indent), notification, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        List actions = notification.getActions();
        if (!actions.isEmpty()) {
            String text = "<p>" + StringUtil.join((Collection)actions, (Function)new Function<AnAction, String>(){
                private int index;

                public String fun(AnAction action) {
                    return "<a href=\"" + this.index++ + "\">" + action.getTemplatePresentation().getText() + EventLog.A_CLOSING;
                }
            }, (String)(EventLog.isLongLine(actions) ? "<br>" : "&nbsp;")) + "</p>";
            Notification n = new Notification(DEFAULT_CATEGORY, DEFAULT_CATEGORY, ".", NotificationType.INFORMATION, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification n, @NotNull HyperlinkEvent event) {
                    if (n == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/intellij/notification/EventLog$3", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/EventLog$3", "hyperlinkUpdate"));
                    }
                    Notification.fire((Notification)notification, (AnAction)((AnAction)notification.getActions().get(Integer.parseInt(event.getDescription()))));
                }
            });
            if (title.length() > 0 || content.length() > 0) {
                lineSeparators.add(logDoc.createRangeMarker(TextRange.from((int)logDoc.getTextLength(), (int)0)));
            }
            hasHtml |= EventLog.parseHtmlContent(text, n, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        }
        String status = EventLog.getStatusText(logDoc, showMore, lineSeparators, indent, hasHtml);
        EventLog.indentNewLines(logDoc, lineSeparators, afterTitle, hasHtml, indent);
        ArrayList<Pair<TextRange, HyperlinkInfo>> list = new ArrayList<Pair<TextRange, HyperlinkInfo>>();
        for (RangeMarker marker : links.keySet()) {
            if (!marker.isValid()) {
                showMore.set(true);
                continue;
            }
            list.add((Pair<TextRange, HyperlinkInfo>)Pair.create((Object)new TextRange(marker.getStartOffset(), marker.getEndOffset()), links.get(marker)));
        }
        if (showMore.get()) {
            String sb = "show balloon";
            if (!logDoc.getText().endsWith(" ")) {
                EventLog.appendText(logDoc, " ");
            }
            EventLog.appendText(logDoc, "(" + sb + ")");
            list.add((Pair<TextRange, HyperlinkInfo>)new Pair((Object)TextRange.from((int)(logDoc.getTextLength() - 1 - sb.length()), (int)sb.length()), (Object)new ShowBalloon(notification)));
        }
        return new LogEntry(logDoc.getText(), status, list, titleLength);
    }

    @NotNull
    private static String addIndents(@NotNull String text, @NotNull String indent) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/notification/EventLog", "addIndents"));
        }
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/notification/EventLog", "addIndents"));
        }
        String string = StringUtil.replace((String)text, (String)"\n", (String)("\n" + indent));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "addIndents"));
        }
        return string;
    }

    private static boolean isLongLine(@NotNull List<AnAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/notification/EventLog", "isLongLine"));
        }
        int size = actions.size();
        if (size > 3) {
            return true;
        }
        if (size > 1) {
            int length = 0;
            for (AnAction action : actions) {
                length += StringUtil.length((CharSequence)action.getTemplatePresentation().getText());
            }
            return length > 30;
        }
        return false;
    }

    @NotNull
    private static String truncateLongString(AtomicBoolean showMore, String title) {
        if (title.length() > 1000) {
            showMore.set(true);
            String string = title.substring(0, 1000) + "...";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "truncateLongString"));
            }
            return string;
        }
        String string = title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "truncateLongString"));
        }
        return string;
    }

    private static void indentNewLines(DocumentImpl logDoc, List<RangeMarker> lineSeparators, RangeMarker afterTitle, boolean hasHtml, String indent) {
        if (!hasHtml) {
            int i2 = -1;
            while ((i2 = StringUtil.indexOf((CharSequence)logDoc.getText(), (char)'\n', (int)(i2 + 1))) >= 0) {
                lineSeparators.add(logDoc.createRangeMarker(i2, i2 + 1));
            }
        }
        if (!lineSeparators.isEmpty() && afterTitle != null && afterTitle.isValid()) {
            lineSeparators.add(afterTitle);
        }
        int nextLineStart = -1;
        for (RangeMarker separator : lineSeparators) {
            int start;
            if (!separator.isValid() || (start = separator.getStartOffset()) == nextLineStart) continue;
            logDoc.replaceString(start, separator.getEndOffset(), "\n" + indent);
            nextLineStart = start + 1 + indent.length();
            while (nextLineStart < logDoc.getTextLength() && Character.isWhitespace(logDoc.getCharsSequence().charAt(nextLineStart))) {
                logDoc.deleteString(nextLineStart, nextLineStart + 1);
            }
        }
    }

    private static String getStatusText(DocumentImpl logDoc, AtomicBoolean showMore, List<RangeMarker> lineSeparators, String indent, boolean hasHtml) {
        DocumentImpl statusDoc = new DocumentImpl(logDoc.getImmutableCharSequence(), true);
        ArrayList<RangeMarker> statusSeparators = new ArrayList<RangeMarker>();
        for (RangeMarker separator : lineSeparators) {
            if (!separator.isValid()) continue;
            statusSeparators.add(statusDoc.createRangeMarker(separator.getStartOffset(), separator.getEndOffset()));
        }
        EventLog.removeJavaNewLines(statusDoc, statusSeparators, indent, hasHtml);
        EventLog.insertNewLineSubstitutors(statusDoc, showMore, statusSeparators);
        return statusDoc.getText();
    }

    private static boolean parseHtmlContent(String text, Notification notification, Document document, AtomicBoolean showMore, Map<RangeMarker, HyperlinkInfo> links, List<RangeMarker> lineSeparators) {
        String content = StringUtil.convertLineSeparators((String)text);
        int initialLen = document.getTextLength();
        boolean hasHtml = false;
        while (true) {
            Matcher tagMatcher;
            if (!(tagMatcher = TAG_PATTERN.matcher(content)).find()) break;
            String tagStart = tagMatcher.group();
            EventLog.appendText(document, content.substring(0, tagMatcher.start()));
            Matcher aMatcher = A_PATTERN.matcher(tagStart);
            if (aMatcher.matches()) {
                String href = aMatcher.group(2);
                int linkEnd = content.indexOf(A_CLOSING, tagMatcher.end());
                if (linkEnd > 0) {
                    String linkText = content.substring(tagMatcher.end(), linkEnd).replaceAll(TAG_PATTERN.pattern(), DEFAULT_CATEGORY);
                    int linkStart = document.getTextLength();
                    EventLog.appendText(document, linkText);
                    links.put(document.createRangeMarker(new TextRange(linkStart, document.getTextLength())), new NotificationHyperlinkInfo(notification, href));
                    content = content.substring(linkEnd + A_CLOSING.length());
                    continue;
                }
            }
            if (EventLog.isTag(HTML_TAGS, tagStart)) {
                hasHtml = true;
                if (NEW_LINES.contains(tagStart)) {
                    if (initialLen != document.getTextLength()) {
                        lineSeparators.add(document.createRangeMarker(TextRange.from((int)document.getTextLength(), (int)0)));
                    }
                } else if (!EventLog.isTag(SKIP_TAGS, tagStart)) {
                    showMore.set(true);
                }
            } else {
                EventLog.appendText(document, content.substring(tagMatcher.start(), tagMatcher.end()));
            }
            content = content.substring(tagMatcher.end());
        }
        EventLog.appendText(document, content);
        Iterator<RangeMarker> iterator = lineSeparators.iterator();
        while (iterator.hasNext()) {
            RangeMarker next = iterator.next();
            if (next.getEndOffset() != document.getTextLength()) continue;
            iterator.remove();
        }
        return hasHtml;
    }

    private static boolean isTag(@NotNull String[] tags, @NotNull String tag) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/notification/EventLog", "isTag"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/notification/EventLog", "isTag"));
        }
        tag = tag.substring(1, tag.length() - 1);
        int index = (tag = StringUtil.trimEnd((String)StringUtil.trimStart((String)tag, (String)"/"), (String)"/")).indexOf(32);
        if (index != -1) {
            tag = tag.substring(0, index);
        }
        return ArrayUtil.indexOf((Object[])tags, (Object)tag) != -1;
    }

    private static void insertNewLineSubstitutors(Document document, AtomicBoolean showMore, List<RangeMarker> lineSeparators) {
        for (RangeMarker marker : lineSeparators) {
            boolean spaceBefore;
            if (!marker.isValid()) {
                showMore.set(true);
                continue;
            }
            int offset = marker.getStartOffset();
            if (offset == 0 || offset == document.getTextLength()) continue;
            boolean bl = spaceBefore = offset > 0 && Character.isWhitespace(document.getCharsSequence().charAt(offset - 1));
            if (offset < document.getTextLength()) {
                boolean spaceAfter = Character.isWhitespace(document.getCharsSequence().charAt(offset));
                int next = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
                if (next < document.getTextLength() && !Character.isLowerCase(document.getCharsSequence().charAt(next))) {
                    document.insertString(offset, (CharSequence)((spaceBefore ? DEFAULT_CATEGORY : " ") + "//" + (spaceAfter ? DEFAULT_CATEGORY : " ")));
                    continue;
                }
                if (spaceAfter) continue;
            }
            if (spaceBefore) continue;
            document.insertString(offset, (CharSequence)" ");
        }
    }

    private static void removeJavaNewLines(Document document, List<RangeMarker> lineSeparators, String indent, boolean hasHtml) {
        CharSequence text = document.getCharsSequence();
        int i2 = 0;
        while ((i2 = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)i2)) >= 0) {
            int j = i2 + 1;
            if (StringUtil.startsWith((CharSequence)text, (int)j, (CharSequence)indent)) {
                j += indent.length();
            }
            document.deleteString(i2, j);
            if (hasHtml) continue;
            lineSeparators.add(document.createRangeMarker(TextRange.from((int)i2, (int)0)));
        }
    }

    private static void appendText(Document document, String text) {
        text = StringUtil.replace((String)text, (String)"&nbsp;", (String)" ");
        text = StringUtil.replace((String)text, (String)"&raquo;", (String)">>");
        text = StringUtil.replace((String)text, (String)"&laquo;", (String)"<<");
        text = StringUtil.replace((String)text, (String)"&hellip;", (String)"...");
        document.insertString(document.getTextLength(), (CharSequence)StringUtil.unescapeXml((String)text));
    }

    @Nullable
    public static ToolWindow getEventLog(Project project2) {
        return project2 == null ? null : ToolWindowManager.getInstance((Project)project2).getToolWindow(LOG_TOOL_WINDOW_ID);
    }

    public static void toggleLog(@Nullable Project project2, @Nullable Notification notification) {
        ToolWindow eventLog = EventLog.getEventLog(project2);
        if (eventLog != null) {
            if (!eventLog.isVisible()) {
                EventLog.activate(eventLog, notification == null ? null : notification.getGroupId(), null);
            } else {
                eventLog.hide(null);
            }
        }
    }

    private static void activate(@NotNull ToolWindow eventLog, @Nullable String groupId, @Nullable Runnable r) {
        if (eventLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLog", "com/intellij/notification/EventLog", "activate"));
        }
        eventLog.activate(() -> {
            if (eventLog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLog", "com/intellij/notification/EventLog", "lambda$activate$0"));
            }
            if (groupId == null) {
                return;
            }
            String contentName = EventLog.getContentName(groupId);
            Content content = eventLog.getContentManager().findContent(contentName);
            if (content != null) {
                eventLog.getContentManager().setSelectedContent(content);
            }
            if (r != null) {
                r.run();
            }
        }, true);
    }

    @NotNull
    private static String getContentName(String groupId) {
        for (EventLogCategory category : (EventLogCategory[])EventLogCategory.EP_NAME.getExtensions()) {
            if (!category.acceptsNotification(groupId)) continue;
            String string = category.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "getContentName"));
            }
            return string;
        }
        if (DEFAULT_CATEGORY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "getContentName"));
        }
        return DEFAULT_CATEGORY;
    }

    static ProjectTracker getProjectComponent(Project project2) {
        return (ProjectTracker)((Object)project2.getComponent(ProjectTracker.class));
    }

    static class ShowBalloon
    implements HyperlinkInfo {
        private final Notification myNotification;
        private RangeHighlighter myRangeHighlighter;

        public ShowBalloon(Notification notification) {
            this.myNotification = notification;
        }

        public void setRangeHighlighter(RangeHighlighter rangeHighlighter) {
            this.myRangeHighlighter = rangeHighlighter;
        }

        public void navigate(Project project2) {
            ShowBalloon.hideBalloon(this.myNotification);
            for (Notification notification : EventLog.getLogModel(project2).getNotifications()) {
                ShowBalloon.hideBalloon(notification);
            }
            EventLogConsole console = (EventLogConsole)ObjectUtils.assertNotNull((Object)EventLog.getProjectComponent(project2).getConsole(this.myNotification));
            if (this.myRangeHighlighter == null || !this.myRangeHighlighter.isValid()) {
                return;
            }
            RelativePoint target = console.getRangeHighlighterLocation(this.myRangeHighlighter);
            if (target != null) {
                IdeFrame frame = WindowManager.getInstance().getIdeFrame(project2);
                assert (frame != null);
                Balloon balloon = NotificationsManagerImpl.createBalloon(frame, this.myNotification, true, true, BalloonLayoutData.fullContent(), (Disposable)project2);
                balloon.show(target, Balloon.Position.above);
            }
        }

        private static void hideBalloon(Notification notification) {
            Balloon balloon = notification.getBalloon();
            if (balloon != null) {
                balloon.hide(true);
            }
        }
    }

    private static class NotificationHyperlinkInfo
    implements HyperlinkInfo {
        private final Notification myNotification;
        private final String myHref;

        public NotificationHyperlinkInfo(Notification notification, String href) {
            this.myNotification = notification;
            this.myHref = href;
        }

        public void navigate(Project project2) {
            NotificationListener listener2 = this.myNotification.getListener();
            if (listener2 != null) {
                EventLogConsole console = (EventLogConsole)ObjectUtils.assertNotNull((Object)EventLog.getProjectComponent(project2).getConsole(this.myNotification));
                JComponent component = console.getConsoleEditor().getContentComponent();
                listener2.hyperlinkUpdate(this.myNotification, IJSwingUtilities.createHyperlinkEvent(this.myHref, component));
            }
        }
    }

    public static class ProjectTracker
    extends AbstractProjectComponent {
        private final Map<String, EventLogConsole> myCategoryMap;
        private final List<Notification> myInitial;
        private final LogModel myProjectModel;

        public ProjectTracker(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/EventLog$ProjectTracker", "<init>"));
            }
            super(project2);
            this.myCategoryMap = ContainerUtil.newConcurrentMap();
            this.myInitial = ContainerUtil.createLockFreeCopyOnWriteList();
            this.myProjectModel = new LogModel(project2, (Disposable)project2);
            for (Notification notification : EventLog.getApplicationComponent().myModel.takeNotifications()) {
                this.printNotification(notification);
            }
            project2.getMessageBus().connect((Disposable)project2).subscribe(Notifications.TOPIC, (Object)new NotificationsAdapter(){

                public void notify(@NotNull Notification notification) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$ProjectTracker$1", "notify"));
                    }
                    this.printNotification(notification);
                }
            });
        }

        void initDefaultContent() {
            this.createNewContent(EventLog.DEFAULT_CATEGORY);
            for (Notification notification : this.myInitial) {
                this.doPrintNotification(notification, (EventLogConsole)ObjectUtils.assertNotNull((Object)this.getConsole(notification)));
            }
            this.myInitial.clear();
        }

        public void projectOpened() {
        }

        public void projectClosed() {
            EventLog.getApplicationComponent().myModel.setStatusMessage(null, 0L);
            StatusBar.Info.set((String)EventLog.DEFAULT_CATEGORY, null, (String)EventLog.LOG_REQUESTOR);
        }

        private void printNotification(Notification notification) {
            if (!NotificationsConfigurationImpl.getSettings(notification.getGroupId()).isShouldLog()) {
                return;
            }
            this.myProjectModel.addNotification(notification);
            EventLogConsole console = this.getConsole(notification);
            if (console == null) {
                this.myInitial.add(notification);
            } else {
                this.doPrintNotification(notification, console);
            }
        }

        private void doPrintNotification(final @NotNull Notification notification, final @NotNull EventLogConsole console) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$ProjectTracker", "doPrintNotification"));
            }
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/notification/EventLog$ProjectTracker", "doPrintNotification"));
            }
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

                public void run() {
                    if (!ShutDownTracker.isShutdownHookRunning() && !myProject.isDisposed()) {
                        ApplicationManager.getApplication().runReadAction(() -> {
                            if (console == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/notification/EventLog$ProjectTracker$2", "lambda$run$0"));
                            }
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$ProjectTracker$2", "lambda$run$0"));
                            }
                            console.doPrintNotification(notification);
                        });
                    }
                }
            });
        }

        private void showNotification(@NotNull String groupId, @NotNull List<String> ids) {
            if (groupId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/EventLog$ProjectTracker", "showNotification"));
            }
            if (ids == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/notification/EventLog$ProjectTracker", "showNotification"));
            }
            ToolWindow eventLog = EventLog.getEventLog(this.myProject);
            if (eventLog != null) {
                EventLog.activate(eventLog, groupId, () -> {
                    if (groupId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/EventLog$ProjectTracker", "lambda$showNotification$0"));
                    }
                    if (ids == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/notification/EventLog$ProjectTracker", "lambda$showNotification$0"));
                    }
                    EventLogConsole console = this.getConsole(groupId);
                    if (console != null) {
                        console.showNotification(ids);
                    }
                });
            }
        }

        private void clearNMore(@NotNull Collection<String> groups) {
            if (groups == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/notification/EventLog$ProjectTracker", "clearNMore"));
            }
            for (String group : groups) {
                EventLogConsole console = this.myCategoryMap.get(EventLog.getContentName(group));
                if (console == null) continue;
                console.clearNMore();
            }
        }

        @Nullable
        private EventLogConsole getConsole(@NotNull Notification notification) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$ProjectTracker", "getConsole"));
            }
            return this.getConsole(notification.getGroupId());
        }

        @Nullable
        private EventLogConsole getConsole(@NotNull String groupId) {
            if (groupId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/EventLog$ProjectTracker", "getConsole"));
            }
            if (this.myCategoryMap.get(EventLog.DEFAULT_CATEGORY) == null) {
                return null;
            }
            String name = EventLog.getContentName(groupId);
            EventLogConsole console = this.myCategoryMap.get(name);
            return console != null ? console : this.createNewContent(name);
        }

        @NotNull
        private EventLogConsole createNewContent(String name) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            EventLogConsole newConsole = new EventLogConsole(this.myProjectModel);
            EventLogToolWindowFactory.createContent(this.myProject, EventLog.getEventLog(this.myProject), newConsole, name);
            this.myCategoryMap.put(name, newConsole);
            EventLogConsole eventLogConsole = newConsole;
            if (eventLogConsole == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog$ProjectTracker", "createNewContent"));
            }
            return eventLogConsole;
        }
    }

    public static class LogEntry {
        public final String message;
        public final String status;
        public final List<Pair<TextRange, HyperlinkInfo>> links;
        public final int titleLength;

        public LogEntry(@NotNull String message, @NotNull String status, @NotNull List<Pair<TextRange, HyperlinkInfo>> links, int titleLength) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/notification/EventLog$LogEntry", "<init>"));
            }
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/notification/EventLog$LogEntry", "<init>"));
            }
            if (links == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "links", "com/intellij/notification/EventLog$LogEntry", "<init>"));
            }
            this.message = message;
            this.status = status;
            this.links = links;
            this.titleLength = titleLength;
        }
    }
}

