/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickList
extends ExternalizableSchemeAdapter
implements SerializableScheme {
    public static final String QUICK_LIST_PREFIX = "QuickList.";
    public static final String SEPARATOR_ID = "QuickList.$Separator$";
    private static final String ID_TAG = "id";
    private static final String ACTION_TAG = "action";
    static final String DISPLAY_NAME_TAG = "display";
    private static final String DESCRIPTION_TAG = "description";
    private String myDescription;
    private String[] myActionIds;
    private SchemeState schemeState;

    QuickList() {
        this.myActionIds = ArrayUtil.EMPTY_STRING_ARRAY;
        this.setName("");
    }

    public QuickList(@NotNull String name, @Nullable String description, String[] actionIds) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/actionSystem/ex/QuickList", "<init>"));
        }
        this.myActionIds = ArrayUtil.EMPTY_STRING_ARRAY;
        this.setName(name);
        this.myDescription = StringUtil.nullize((String)description);
        this.myActionIds = actionIds;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String value) {
        this.myDescription = StringUtil.nullize((String)value);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public String[] getActionIds() {
        return this.myActionIds;
    }

    public void setActionIds(@NotNull String[] value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/actionSystem/ex/QuickList", "setActionIds"));
        }
        this.myActionIds = value;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuickList)) {
            return false;
        }
        QuickList quickList = (QuickList)o;
        return Arrays.equals(this.myActionIds, quickList.myActionIds) && Comparing.strEqual((String)this.myDescription, (String)quickList.myDescription) && this.getName().equals(quickList.getName());
    }

    public int hashCode() {
        return 29 * this.getName().hashCode() + Comparing.hashcode((Object)this.myDescription);
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.getName() + " " + this.getDescription();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickList", "toString"));
        }
        return string;
    }

    @NotNull
    public String getActionId() {
        String string = QUICK_LIST_PREFIX + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickList", "getActionId"));
        }
        return string;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/actionSystem/ex/QuickList", "readExternal"));
        }
        this.setName(element.getAttributeValue(DISPLAY_NAME_TAG));
        this.myDescription = StringUtil.nullize((String)element.getAttributeValue(DESCRIPTION_TAG));
        List actionElements = element.getChildren(ACTION_TAG);
        this.myActionIds = new String[actionElements.size()];
        int n = actionElements.size();
        for (int i2 = 0; i2 < n; ++i2) {
            this.myActionIds[i2] = ((Element)actionElements.get(i2)).getAttributeValue(ID_TAG);
        }
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element element = new Element("list");
        element.setAttribute(DISPLAY_NAME_TAG, this.getName());
        if (this.myDescription != null) {
            element.setAttribute(DESCRIPTION_TAG, this.myDescription);
        }
        for (String actionId : this.getActionIds()) {
            element.addContent(new Element(ACTION_TAG).setAttribute(ID_TAG, actionId));
        }
        this.schemeState = SchemeState.UNCHANGED;
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickList", "writeScheme"));
        }
        return element2;
    }

    @Override
    @Nullable
    public SchemeState getSchemeState() {
        return this.schemeState;
    }
}

