/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import org.jetbrains.annotations.NotNull;

final class ProxyShortcutSet
implements ShortcutSet {
    private final String myActionId;
    private final KeymapManager myKeymapManager;

    public ProxyShortcutSet(@NotNull String actionId, @NotNull KeymapManager keymapManager2) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/impl/ProxyShortcutSet", "<init>"));
        }
        if (keymapManager2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymapManager", "com/intellij/openapi/actionSystem/impl/ProxyShortcutSet", "<init>"));
        }
        this.myActionId = actionId;
        this.myKeymapManager = keymapManager2;
    }

    @NotNull
    public Shortcut[] getShortcuts() {
        Keymap keymap = this.myKeymapManager.getActiveKeymap();
        Shortcut[] shortcutArray = keymap.getShortcuts(this.myActionId);
        if (shortcutArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ProxyShortcutSet", "getShortcuts"));
        }
        return shortcutArray;
    }
}

