/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class PathManagerEx {
    private static final ConcurrentMap<Class, TestDataLookupStrategy> CLASS_STRATEGY_CACHE = ContainerUtil.newConcurrentMap();
    private static final ConcurrentMap<String, Class> CLASS_CACHE = ContainerUtil.newConcurrentMap();
    private static Set<String> ourCommunityModules;
    private static final Map<TestDataLookupStrategy, List<String>> TEST_DATA_RELATIVE_PATHS;

    private PathManagerEx() {
    }

    @NonNls
    public static String getTestDataPath() throws IllegalStateException {
        TestDataLookupStrategy strategy = PathManagerEx.guessTestDataLookupStrategy();
        return PathManagerEx.getTestDataPath(strategy);
    }

    public static String getTestDataPath(String path) throws IllegalStateException {
        return PathManagerEx.getTestDataPath() + path.replace('/', File.separatorChar);
    }

    public static String getTestDataPath(Class<?> testClass) throws IllegalStateException {
        TestDataLookupStrategy strategy = PathManagerEx.isLocatedInCommunity() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.determineLookupStrategy(testClass);
        return PathManagerEx.getTestDataPath(strategy);
    }

    @NotNull
    public static String getCommunityHomePath() {
        String path = PathManager.getHomePath();
        String string = PathManagerEx.isLocatedInCommunity() ? path : path + File.separator + "community";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ex/PathManagerEx", "getCommunityHomePath"));
        }
        return string;
    }

    public static String getHomePath(Class<?> testClass) {
        TestDataLookupStrategy strategy = PathManagerEx.isLocatedInCommunity() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.determineLookupStrategy(testClass);
        return strategy == TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE ? PathManagerEx.getCommunityHomePath() : PathManager.getHomePath();
    }

    public static File findFileUnderCommunityHome(String relativePath) {
        File file2 = new File(PathManagerEx.getCommunityHomePath(), FileUtil.toSystemDependentName((String)relativePath));
        if (!file2.exists()) {
            throw new IllegalArgumentException("Cannot find file '" + relativePath + "' under '" + PathManagerEx.getCommunityHomePath() + "' directory");
        }
        return file2;
    }

    public static File findFileUnderProjectHome(String relativePath, Class<? extends TestCase> testClass) {
        String homePath = PathManagerEx.getHomePath(testClass);
        File file2 = new File(homePath, FileUtil.toSystemDependentName((String)relativePath));
        if (!file2.exists()) {
            throw new IllegalArgumentException("Cannot find file '" + relativePath + "' under '" + homePath + "' directory");
        }
        return file2;
    }

    private static boolean isLocatedInCommunity() {
        FileSystemLocation projectLocation = PathManagerEx.parseProjectLocation();
        return projectLocation == FileSystemLocation.COMMUNITY;
    }

    @NonNls
    public static String getTestDataPath(TestDataLookupStrategy strategy) throws IllegalStateException {
        String homePath = PathManager.getHomePath();
        List<String> relativePaths = TEST_DATA_RELATIVE_PATHS.get((Object)strategy);
        if (relativePaths.isEmpty()) {
            throw new IllegalStateException(String.format("Can't determine test data path. Reason: no predefined relative paths are configured for test data lookup strategy %s. Configured mappings: %s", new Object[]{strategy, TEST_DATA_RELATIVE_PATHS}));
        }
        File candidate = null;
        for (String relativePath : relativePaths) {
            candidate = new File(homePath, relativePath);
            if (!candidate.isDirectory()) continue;
            return candidate.getPath();
        }
        if (candidate == null) {
            throw new IllegalStateException("Can't determine test data path. Looks like programming error - reached 'if' block that was never expected to be executed");
        }
        return candidate.getPath();
    }

    public static TestDataLookupStrategy guessTestDataLookupStrategy() {
        TestDataLookupStrategy result2 = PathManagerEx.guessTestDataLookupStrategyOnClassLocation();
        if (result2 == null) {
            result2 = PathManagerEx.guessTestDataLookupStrategyOnDirectoryAvailability();
        }
        return result2;
    }

    @Nullable
    private static TestDataLookupStrategy guessTestDataLookupStrategyOnClassLocation() {
        StackTraceElement[] stackTrace;
        if (PathManagerEx.isLocatedInCommunity()) {
            return TestDataLookupStrategy.COMMUNITY;
        }
        Class<?> testClass = null;
        Class<?> abstractTestClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new Exception().getStackTrace()) {
            String className = stackTraceElement.getClassName();
            Class<?> clazz = PathManagerEx.loadClass(className);
            if (clazz == null || TestCase.class == clazz || !PathManagerEx.isJUnitClass(clazz)) continue;
            if (PathManagerEx.determineLookupStrategy(clazz) == TestDataLookupStrategy.ULTIMATE) {
                return TestDataLookupStrategy.ULTIMATE;
            }
            if ((clazz.getModifiers() & 0x400) == 0) {
                testClass = clazz;
                continue;
            }
            abstractTestClass = clazz;
        }
        Class<?> classToUse = testClass == null ? abstractTestClass : testClass;
        return classToUse == null ? null : PathManagerEx.determineLookupStrategy(classToUse);
    }

    @Nullable
    private static Class<?> loadClass(String className) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = (Class<?>)CLASS_CACHE.get(className);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader definingClassLoader = PathManagerEx.class.getClassLoader();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        for (ClassLoader classLoader : Arrays.asList(contextClassLoader, definingClassLoader, systemClassLoader)) {
            clazz = PathManagerEx.loadClass(className, classLoader);
            if (clazz == null) continue;
            CLASS_CACHE.put(className, clazz);
            return clazz;
        }
        CLASS_CACHE.put(className, TestCase.class);
        return null;
    }

    @Nullable
    private static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    private static boolean isJUnitClass(Class<?> clazz) {
        return TestCase.class.isAssignableFrom(clazz) || TestRunnerUtil.isJUnit4TestClass(clazz) || Parameterized.class.isAssignableFrom(clazz);
    }

    @Nullable
    private static TestDataLookupStrategy determineLookupStrategy(Class<?> clazz) {
        TestDataLookupStrategy result2 = (TestDataLookupStrategy)((Object)CLASS_STRATEGY_CACHE.get(clazz));
        if (result2 != null) {
            return result2;
        }
        FileSystemLocation classFileLocation = PathManagerEx.computeClassLocation(clazz);
        result2 = classFileLocation == FileSystemLocation.COMMUNITY ? TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE : TestDataLookupStrategy.ULTIMATE;
        CLASS_STRATEGY_CACHE.put(clazz, result2);
        return result2;
    }

    public static void replaceLookupStrategy(Class<?> substitutor, Class<?> ... initial) {
        CLASS_STRATEGY_CACHE.clear();
        for (Class<?> aClass : initial) {
            CLASS_STRATEGY_CACHE.put(aClass, PathManagerEx.determineLookupStrategy(substitutor));
        }
    }

    private static FileSystemLocation computeClassLocation(Class<?> clazz) {
        String chunkPrefix;
        String classRootPath = PathManager.getJarPathForClass(clazz);
        if (classRootPath == null) {
            throw new IllegalStateException("Cannot find root directory for " + clazz);
        }
        File root = new File(classRootPath);
        if (!root.exists()) {
            throw new IllegalStateException("Classes root " + root + " doesn't exist");
        }
        if (!root.isDirectory()) {
            return FileSystemLocation.ULTIMATE;
        }
        String moduleName = root.getName();
        if (moduleName.startsWith(chunkPrefix = "ModuleChunk(")) {
            moduleName = StringUtil.trimStart((String)moduleName, (String)chunkPrefix);
            moduleName = moduleName.substring(0, moduleName.indexOf(44));
        }
        return PathManagerEx.getCommunityModules().contains(moduleName) ? FileSystemLocation.COMMUNITY : FileSystemLocation.ULTIMATE;
    }

    private static synchronized Set<String> getCommunityModules() {
        if (ourCommunityModules != null) {
            return ourCommunityModules;
        }
        ourCommunityModules = new THashSet();
        File modulesXml = PathManagerEx.findFileUnderCommunityHome(".idea/modules.xml");
        if (!modulesXml.exists()) {
            throw new IllegalStateException("Cannot obtain test data path: " + modulesXml.getAbsolutePath() + " not found");
        }
        try {
            Element element = JDomSerializationUtil.findComponent((Element)JDOMUtil.load((File)modulesXml), (String)"ProjectModuleManager");
            assert (element != null);
            for (ModulePath file2 : ModuleManagerImpl.getPathsToModuleFiles(element)) {
                ourCommunityModules.add(file2.getModuleName());
            }
            return ourCommunityModules;
        }
        catch (IOException | JDOMException e) {
            throw new RuntimeException("Cannot read modules from " + modulesXml.getAbsolutePath(), e);
        }
    }

    private static FileSystemLocation parseProjectLocation() {
        return new File(PathManager.getHomePath(), "community/.idea").isDirectory() ? FileSystemLocation.ULTIMATE : FileSystemLocation.COMMUNITY;
    }

    private static TestDataLookupStrategy guessTestDataLookupStrategyOnDirectoryAvailability() {
        String homePath = PathManager.getHomePath();
        for (Map.Entry<TestDataLookupStrategy, List<String>> entry : TEST_DATA_RELATIVE_PATHS.entrySet()) {
            for (String relativePath : entry.getValue()) {
                if (!new File(homePath, relativePath).isDirectory()) continue;
                return entry.getKey();
            }
        }
        return TestDataLookupStrategy.ULTIMATE;
    }

    static {
        TEST_DATA_RELATIVE_PATHS = new EnumMap<TestDataLookupStrategy, List<String>>(TestDataLookupStrategy.class);
        TEST_DATA_RELATIVE_PATHS.put(TestDataLookupStrategy.ULTIMATE, Collections.singletonList(FileUtil.toSystemDependentName((String)"testData")));
        TEST_DATA_RELATIVE_PATHS.put(TestDataLookupStrategy.COMMUNITY, Collections.singletonList(FileUtil.toSystemDependentName((String)"java/java-tests/testData")));
        TEST_DATA_RELATIVE_PATHS.put(TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE, Collections.singletonList(FileUtil.toSystemDependentName((String)"community/java/java-tests/testData")));
    }

    public static enum TestDataLookupStrategy {
        ULTIMATE,
        COMMUNITY,
        COMMUNITY_FROM_ULTIMATE;

    }

    private static enum FileSystemLocation {
        ULTIMATE,
        COMMUNITY;

    }
}

