/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.generic;

import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.VirtualFilePersistentState;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public abstract class VirtualFileCompileItem<OutputState>
extends CompileItem<String, VirtualFilePersistentState, OutputState> {
    protected final VirtualFile myFile;

    public VirtualFileCompileItem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/compiler/generic/VirtualFileCompileItem", "<init>"));
        }
        this.myFile = file2;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/generic/VirtualFileCompileItem", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFilePersistentState computeSourceState() {
        VirtualFilePersistentState virtualFilePersistentState = new VirtualFilePersistentState(this.myFile.getTimeStamp());
        if (virtualFilePersistentState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/generic/VirtualFileCompileItem", "computeSourceState"));
        }
        return virtualFilePersistentState;
    }

    @Override
    public boolean isSourceUpToDate(@NotNull VirtualFilePersistentState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/compiler/generic/VirtualFileCompileItem", "isSourceUpToDate"));
        }
        return this.myFile.getTimeStamp() == state.getSourceTimestamp();
    }

    @Override
    @NotNull
    public String getKey() {
        String string = this.myFile.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/generic/VirtualFileCompileItem", "getKey"));
        }
        return string;
    }
}

