/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.actions.DiffPanelComboBoxAction;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import org.jetbrains.annotations.NotNull;

public class IgnoreWhiteSpacesAction
extends DiffPanelComboBoxAction<ComparisonPolicy> {
    private static final ComparisonPolicy[] ourActionOrder = new ComparisonPolicy[]{ComparisonPolicy.DEFAULT, ComparisonPolicy.TRIM_SPACE, ComparisonPolicy.IGNORE_SPACE};

    public IgnoreWhiteSpacesAction() {
        super(ourActionOrder);
        this.addAction(ComparisonPolicy.DEFAULT, (AnAction)new IgnoringPolicyAction(DiffBundle.message((String)"diff.acton.ignore.whitespace.policy.do.not.ignore", (Object[])new Object[0]), ComparisonPolicy.DEFAULT));
        this.addAction(ComparisonPolicy.TRIM_SPACE, (AnAction)new IgnoringPolicyAction(DiffBundle.message((String)"diff.acton.ignore.whitespace.policy.leading.and.trailing", (Object[])new Object[0]), ComparisonPolicy.TRIM_SPACE));
        this.addAction(ComparisonPolicy.IGNORE_SPACE, (AnAction)new IgnoringPolicyAction(DiffBundle.message((String)"diff.acton.ignore.whitespace.policy.all", (Object[])new Object[0]), ComparisonPolicy.IGNORE_SPACE));
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = DiffBundle.message((String)"ignore.whitespace.acton.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/IgnoreWhiteSpacesAction", "getActionName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected ComparisonPolicy getCurrentOption(@NotNull DiffPanelEx diffPanel) {
        if (diffPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffPanel", "com/intellij/openapi/diff/actions/IgnoreWhiteSpacesAction", "getCurrentOption"));
        }
        ComparisonPolicy comparisonPolicy = diffPanel.getComparisonPolicy();
        if (comparisonPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/IgnoreWhiteSpacesAction", "getCurrentOption"));
        }
        return comparisonPolicy;
    }

    private static class IgnoringPolicyAction
    extends DiffPanelComboBoxAction.DiffPanelAction {
        private final ComparisonPolicy myPolicy;

        public IgnoringPolicyAction(String text, ComparisonPolicy policy) {
            super(text);
            this.myPolicy = policy;
        }

        @Override
        protected void perform(@NotNull DiffPanelEx diffPanel) {
            if (diffPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffPanel", "com/intellij/openapi/diff/actions/IgnoreWhiteSpacesAction$IgnoringPolicyAction", "perform"));
            }
            diffPanel.setComparisonPolicy(this.myPolicy);
        }
    }
}

