/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.diff.actions.MergeActionGroup;
import com.intellij.openapi.diff.actions.ToggleAutoScrollAction;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.ContentChangeListener;
import com.intellij.openapi.diff.impl.DiffHighlighterFactory;
import com.intellij.openapi.diff.impl.DiffHighlighterFactoryImpl;
import com.intellij.openapi.diff.impl.DiffSideView;
import com.intellij.openapi.diff.impl.DiffSplitter;
import com.intellij.openapi.diff.impl.DiffSplitterI;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.EditorSource;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.diff.impl.Rediffers;
import com.intellij.openapi.diff.impl.TwoSidesContainer;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.FragmentList;
import com.intellij.openapi.diff.impl.highlighting.DiffPanelState;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.processing.HighlightMode;
import com.intellij.openapi.diff.impl.processing.HorizontalDiffSplitter;
import com.intellij.openapi.diff.impl.settings.DiffMergeEditorSetting;
import com.intellij.openapi.diff.impl.settings.DiffMergeSettings;
import com.intellij.openapi.diff.impl.settings.DiffMergeSettingsAction;
import com.intellij.openapi.diff.impl.settings.DiffToolSettings;
import com.intellij.openapi.diff.impl.splitter.DiffDividerPaint;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.diff.impl.util.DiffPanelOuterComponent;
import com.intellij.openapi.diff.impl.util.FocusDiffSide;
import com.intellij.openapi.diff.impl.util.FontSizeSynchronizer;
import com.intellij.openapi.diff.impl.util.SyncScrollSupport;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.CacheOneStepIterator;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.ui.PlatformColors;
import gnu.trove.TIntFunction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffPanelImpl
implements DiffPanelEx,
ContentChangeListener,
TwoSidesContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.DiffPanelImpl");
    private final DiffSplitterI mySplitter;
    private final DiffPanelOuterComponent myPanel;
    private final Window myOwnerWindow;
    private final DiffPanelOptions myOptions;
    private final DiffPanelState myData;
    private final Rediffers myDiffUpdater;
    private final DiffSideView myLeftSide;
    private final DiffSideView myRightSide;
    private DiffSideView myCurrentSide;
    private LineBlocks myLineBlocks;
    private final SyncScrollSupport myScrollSupport;
    private final FontSizeSynchronizer myFontSizeSynchronizer;
    private DiffRequest myDiffRequest;
    private boolean myIsRequestFocus;
    private boolean myIsSyncScroll;
    private boolean myDisposed;
    private final GenericDataProvider myDataProvider;
    @NotNull
    private final Project myProject;
    private final boolean myIsHorizontal;
    private final DiffTool myParentTool;
    private EditorNotificationPanel myTopMessageDiffPanel;
    private final VisibleAreaListener myVisibleAreaListener;
    private final int myDiffDividerPolygonsOffset;

    private DiffRequest.ToolbarAddons createToolbar() {
        return new DiffRequest.ToolbarAddons(){

            public void customize(DiffToolbar toolbar) {
                ActionManager actionManager = ActionManager.getInstance();
                toolbar.addAction(actionManager.getAction("DiffPanel.Toolbar"));
                toolbar.addSeparator();
                toolbar.addAction((AnAction)new ToggleAutoScrollAction());
                toolbar.addSeparator();
                toolbar.addAction(actionManager.getAction("ContextHelp"));
                toolbar.addAction(this.getEditSourceAction());
                toolbar.addSeparator();
                toolbar.addAction((AnAction)new DiffMergeSettingsAction(Arrays.asList(DiffPanelImpl.this.getEditor1(), DiffPanelImpl.this.getEditor2()), (DiffMergeSettings)ServiceManager.getService((Project)DiffPanelImpl.this.myProject, DiffToolSettings.class)));
            }

            @NotNull
            private AnAction getEditSourceAction() {
                EditSourceAction editSourceAction = new EditSourceAction();
                editSourceAction.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
                editSourceAction.getTemplatePresentation().setText(ActionsBundle.actionText((String)"EditSource"));
                editSourceAction.getTemplatePresentation().setDescription(ActionsBundle.actionText((String)"EditSource"));
                editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), DiffPanelImpl.this.myPanel, DiffPanelImpl.this);
                EditSourceAction editSourceAction2 = editSourceAction;
                if (editSourceAction2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/DiffPanelImpl$1", "getEditSourceAction"));
                }
                return editSourceAction2;
            }
        };
    }

    public DiffPanelImpl(Window owner, @NotNull Project project2, boolean enableToolbar, boolean horizontal, int diffDividerPolygonsOffset, DiffTool parentTool) {
        HighlightMode defaultHighlightMode;
        HighlightMode highlightMode;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/DiffPanelImpl", "<init>"));
        }
        this.myLineBlocks = LineBlocks.EMPTY;
        this.myScrollSupport = new SyncScrollSupport();
        this.myFontSizeSynchronizer = new FontSizeSynchronizer();
        this.myIsRequestFocus = true;
        this.myDisposed = false;
        UsageTrigger.trigger("diff.DiffPanelImpl");
        this.myProject = project2;
        this.myIsHorizontal = horizontal;
        this.myParentTool = parentTool;
        this.myOptions = new DiffPanelOptions(this);
        this.myPanel = new DiffPanelOuterComponent(TextDiffType.DIFF_TYPES, null);
        this.myPanel.disableToolbar(!enableToolbar);
        if (enableToolbar) {
            this.myPanel.resetToolbar();
        }
        this.myOwnerWindow = owner;
        this.myIsSyncScroll = true;
        boolean v = !horizontal;
        this.myLeftSide = new DiffSideView(this, (Border)new CustomLineBorder(1, 0, v ? 0 : 1, v ? 0 : 1));
        this.myRightSide = new DiffSideView(this, (Border)new CustomLineBorder(v ? 0 : 1, v ? 0 : 1, 1, 0));
        this.myLeftSide.becomeMaster();
        this.myDiffUpdater = new Rediffers(this);
        this.myDiffDividerPolygonsOffset = diffDividerPolygonsOffset;
        this.myData = this.createDiffPanelState(this);
        this.mySplitter = horizontal ? new DiffSplitter(this.myLeftSide.getComponent(), this.myRightSide.getComponent(), new DiffDividerPaint(this, FragmentSide.SIDE1, diffDividerPolygonsOffset), this.myData) : new HorizontalDiffSplitter(this.myLeftSide.getComponent(), this.myRightSide.getComponent());
        this.myPanel.insertDiffComponent(this.mySplitter.getComponent(), new MyScrollingPanel());
        this.myDataProvider = new MyGenericDataProvider(this);
        this.myPanel.setDataProvider(this.myDataProvider);
        ComparisonPolicy comparisonPolicy = this.getComparisonPolicy();
        ComparisonPolicy defaultComparisonPolicy = DiffManagerImpl.getInstanceEx().getComparisonPolicy();
        if (comparisonPolicy != defaultComparisonPolicy) {
            this.setComparisonPolicy(defaultComparisonPolicy, false);
        }
        if ((highlightMode = this.getHighlightMode()) != (defaultHighlightMode = DiffManagerImpl.getInstanceEx().getHighlightMode())) {
            this.setHighlightMode(defaultHighlightMode, false);
        }
        this.myVisibleAreaListener = new VisibleAreaListener(){

            public void visibleAreaChanged(VisibleAreaEvent e) {
                Editor editor2;
                Editor editor1 = DiffPanelImpl.this.getEditor1();
                if (editor1 != null) {
                    editor1.getComponent().repaint();
                }
                if ((editor2 = DiffPanelImpl.this.getEditor2()) != null) {
                    editor2.getComponent().repaint();
                }
            }
        };
        this.registerActions();
    }

    private void registerActions() {
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (DiffPanelImpl.this.getEditor1() != null && DiffPanelImpl.this.getEditor2() != null) {
                    Editor focus = DiffPanelImpl.this.getEditor1().getContentComponent().hasFocus() ? DiffPanelImpl.this.getEditor2() : DiffPanelImpl.this.getEditor1();
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)focus.getContentComponent(), true);
                    focus.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"control TAB"}), (JComponent)this.myPanel, (Disposable)this);
    }

    protected DiffPanelState createDiffPanelState(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/DiffPanelImpl", "createDiffPanelState"));
        }
        return new DiffPanelState(this, this.myProject, this.getDiffDividerPolygonsOffset(), parentDisposable);
    }

    public int getDiffDividerPolygonsOffset() {
        return this.myDiffDividerPolygonsOffset;
    }

    public boolean isHorisontal() {
        return this.myIsHorizontal;
    }

    public DiffPanelState getDiffPanelState() {
        return this.myData;
    }

    public void noSynchScroll() {
        this.myIsSyncScroll = false;
    }

    public DiffSplitterI getSplitter() {
        return this.mySplitter;
    }

    public void reset() {
        this.myPanel.setPreferredHeightGetter(null);
    }

    public void prefferedSizeByContents(int maximumLines) {
        if (this.getEditor1() == null && this.getEditor2() == null) {
            return;
        }
        if (this.getEditor1() != null) {
            this.getEditor1().getSettings().setAdditionalLinesCount(0);
            this.getEditor1().getSettings().setAdditionalPageAtBottom(false);
        }
        if (this.getEditor2() != null) {
            this.getEditor2().getSettings().setAdditionalLinesCount(0);
            this.getEditor2().getSettings().setAdditionalPageAtBottom(false);
        }
        this.myPanel.setPrefferedWidth(20);
        this.myPanel.setPreferredHeightGetter((Getter<Integer>)((Getter)() -> {
            int size1 = this.getEditor1() == null ? 10 : this.getEditor1().getComponent().getPreferredSize().height;
            int size2 = this.getEditor2() == null ? 10 : this.getEditor2().getComponent().getPreferredSize().height;
            int lineHeight = this.getEditor1() == null ? this.getEditor2().getLineHeight() : this.getEditor1().getLineHeight();
            int size = Math.max(size1, size2);
            if (maximumLines > 0) {
                return Math.min(size, maximumLines * lineHeight);
            }
            return size;
        }));
    }

    @Override
    @Nullable
    public Editor getEditor1() {
        return this.myLeftSide.getEditor();
    }

    @Override
    @Nullable
    public Editor getEditor2() {
        Editor editor;
        if (this.myDisposed) {
            LOG.error("Disposed");
        }
        if ((editor = this.myRightSide.getEditor()) != null) {
            return editor;
        }
        if (this.myData.getContent2() == null) {
            LOG.error("No content 2");
        }
        return editor;
    }

    public void setContents(DiffContent content1, DiffContent content2) {
        LOG.assertTrue(content1 != null && content2 != null);
        LOG.assertTrue(!this.myDisposed);
        this.myData.setContents(content1, content2);
        Project project2 = this.myData.getProject();
        FileType[] types = DiffUtil.chooseContentTypes(new DiffContent[]{content1, content2});
        VirtualFile beforeFile = content1.getFile();
        VirtualFile afterFile = content2.getFile();
        String path = this.myDiffRequest == null ? null : this.myDiffRequest.getWindowTitle();
        this.myLeftSide.setHighlighterFactory(DiffPanelImpl.createHighlighter(types[0], beforeFile, afterFile, path, project2));
        this.myRightSide.setHighlighterFactory(DiffPanelImpl.createHighlighter(types[1], afterFile, beforeFile, path, project2));
        this.setSplitterProportion(content1, content2);
        this.rediff();
        if (this.myIsRequestFocus) {
            this.myPanel.requestScrollEditors();
        }
    }

    private void setSplitterProportion(DiffContent content1, DiffContent content2) {
        if (content1.isEmpty()) {
            this.mySplitter.setProportion(0.0f);
            this.mySplitter.setResizeEnabled(false);
            return;
        }
        if (content2.isEmpty()) {
            this.mySplitter.setProportion(1.0f);
            this.mySplitter.setResizeEnabled(false);
            return;
        }
        this.mySplitter.setProportion(0.5f);
        this.mySplitter.setResizeEnabled(true);
    }

    public void removeStatusBar() {
        this.myPanel.removeStatusBar();
    }

    public void enableToolbar(boolean value) {
        this.myPanel.disableToolbar(!value);
    }

    public void setLineNumberConvertors(@NotNull TIntFunction old, @NotNull TIntFunction newConvertor) {
        if (old == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "old", "com/intellij/openapi/diff/impl/DiffPanelImpl", "setLineNumberConvertors"));
        }
        if (newConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConvertor", "com/intellij/openapi/diff/impl/DiffPanelImpl", "setLineNumberConvertors"));
        }
        if (this.getEditor1() != null) {
            ((EditorGutterComponentEx)this.getEditor1().getGutter()).setLineNumberConvertor(old);
        }
        if (this.getEditor2() != null) {
            ((EditorGutterComponentEx)this.getEditor2().getGutter()).setLineNumberConvertor(newConvertor);
        }
    }

    private static DiffHighlighterFactory createHighlighter(FileType contentType, VirtualFile file2, VirtualFile otherFile, String path, Project project2) {
        VirtualFile baseFile = file2;
        if (baseFile == null) {
            baseFile = otherFile;
        }
        if (baseFile == null && path != null) {
            baseFile = LocalFileSystem.getInstance().findFileByPath(path);
        }
        return new DiffHighlighterFactoryImpl(contentType, baseFile, project2);
    }

    void rediff() {
        try {
            LineBlocks blocks;
            if (this.myTopMessageDiffPanel != null) {
                this.myPanel.removeTopComponent((JComponent)this.myTopMessageDiffPanel);
            }
            this.setLineBlocks((blocks = this.myData.updateEditors()) != null ? blocks : LineBlocks.EMPTY);
            if (blocks != null && blocks.getCount() == 0 && this.myData.isContentsEqual()) {
                this.setFileContentsAreIdentical();
            }
        }
        catch (FilesTooBigForDiffException e) {
            this.setTooBigFileErrorContents();
        }
    }

    public void setTooBigFileErrorContents() {
        this.setLineBlocks(LineBlocks.EMPTY);
        this.myTopMessageDiffPanel = new CanNotCalculateDiffPanel();
        this.myPanel.insertTopComponent((JComponent)this.myTopMessageDiffPanel);
    }

    public void setPatchAppliedApproximately() {
        if (!(this.myTopMessageDiffPanel instanceof CanNotCalculateDiffPanel)) {
            this.myTopMessageDiffPanel = new DiffIsApproximate();
            this.myPanel.insertTopComponent((JComponent)this.myTopMessageDiffPanel);
        }
    }

    public void setFileContentsAreIdentical() {
        if (this.myTopMessageDiffPanel == null || this.myTopMessageDiffPanel instanceof FileContentsAreIdenticalDiffPanel) {
            LineSeparator sep1 = this.myData.getContent1() == null ? null : this.myData.getContent1().getLineSeparator();
            LineSeparator sep2 = this.myData.getContent2() == null ? null : this.myData.getContent2().getLineSeparator();
            this.myTopMessageDiffPanel = LineSeparator.knownAndDifferent((LineSeparator)sep1, (LineSeparator)sep2) ? new LineSeparatorsOnlyDiffPanel() : new FileContentsAreIdenticalDiffPanel();
            this.myPanel.insertTopComponent((JComponent)this.myTopMessageDiffPanel);
        }
    }

    public void setTitle1(String title) {
        this.setTitle(title, true);
    }

    private void setTitle(String title, boolean left) {
        Editor editor;
        Editor editor2 = editor = left ? this.getEditor1() : this.getEditor2();
        if (editor == null) {
            return;
        }
        title = DiffPanelImpl.addReadOnly(title, editor);
        JLabel label = new JLabel(title);
        if (left) {
            this.myLeftSide.setTitle(label);
        } else {
            this.myRightSide.setTitle(label);
        }
    }

    @Nullable
    private static String addReadOnly(@Nullable String title, @Nullable Editor editor) {
        boolean readonly;
        if (editor == null || title == null) {
            return title;
        }
        boolean bl = readonly = editor.isViewer() || !editor.getDocument().isWritable();
        if (readonly) {
            title = title + " " + DiffBundle.message((String)"diff.content.read.only.content.title.suffix", (Object[])new Object[0]);
        }
        return title;
    }

    public void setTitle2(String title) {
        this.setTitle(title, false);
    }

    private void setLineBlocks(@NotNull LineBlocks blocks) {
        if (blocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/openapi/diff/impl/DiffPanelImpl", "setLineBlocks"));
        }
        this.myLineBlocks = blocks;
        this.mySplitter.redrawDiffs();
        this.updateStatusBar();
    }

    public void invalidateDiff() {
        this.setLineBlocks(LineBlocks.EMPTY);
        this.myData.removeActions();
    }

    public FragmentList getFragments() {
        return this.myData.getFragmentList();
    }

    private int[] getFragmentBeginnings() {
        return this.getFragmentBeginnings(this.myCurrentSide.getSide());
    }

    int[] getFragmentBeginnings(FragmentSide side) {
        return this.getLineBlocks().getBeginnings(side);
    }

    public void dispose() {
        this.myDisposed = true;
        this.myDiffUpdater.dispose();
        Disposer.dispose((Disposable)this.myScrollSupport);
        Disposer.dispose((Disposable)this.myData);
        this.myPanel.cancelScrollEditors();
        JComponent component = this.myPanel.getBottomComponent();
        if (component instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)component));
        }
        this.myPanel.setBottomComponent(null);
        this.myPanel.setDataProvider(null);
        this.myPanel.setScrollingPanel(null);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void updateStatusBar() {
        this.myPanel.setStatusBarText(this.getNumDifferencesText());
    }

    public String getNumDifferencesText() {
        return DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{this.getLineBlocks().getCount()});
    }

    public boolean hasDifferences() {
        return this.getLineBlocks().getCount() > 0 || this.myTopMessageDiffPanel != null;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myCurrentSide.getFocusableComponent();
    }

    public int getContentsNumber() {
        return 2;
    }

    public boolean acceptsType(DiffViewerType type) {
        return DiffViewerType.contents.equals((Object)type);
    }

    @Override
    public ComparisonPolicy getComparisonPolicy() {
        return this.myData.getComparisonPolicy();
    }

    @Override
    public void setComparisonPolicy(@NotNull ComparisonPolicy comparisonPolicy) {
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/openapi/diff/impl/DiffPanelImpl", "setComparisonPolicy"));
        }
        this.setComparisonPolicy(comparisonPolicy, true);
    }

    private void setComparisonPolicy(@NotNull ComparisonPolicy policy, boolean notifyManager) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/openapi/diff/impl/DiffPanelImpl", "setComparisonPolicy"));
        }
        this.myData.setComparisonPolicy(policy);
        this.rediff();
        if (notifyManager) {
            DiffManagerImpl.getInstanceEx().setComparisonPolicy(policy);
        }
    }

    @Override
    @NotNull
    public HighlightMode getHighlightMode() {
        HighlightMode highlightMode = this.myData.getHighlightMode();
        if (highlightMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/DiffPanelImpl", "getHighlightMode"));
        }
        return highlightMode;
    }

    @Override
    public void setHighlightMode(@NotNull HighlightMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/diff/impl/DiffPanelImpl", "setHighlightMode"));
        }
        this.setHighlightMode(mode, true);
    }

    public void setHighlightMode(@NotNull HighlightMode mode, boolean notifyManager) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/diff/impl/DiffPanelImpl", "setHighlightMode"));
        }
        this.myData.setHighlightMode(mode);
        this.rediff();
        if (notifyManager) {
            DiffManagerImpl.getInstanceEx().setHighlightMode(mode);
        }
    }

    @Override
    public void setAutoScrollEnabled(boolean enabled) {
        this.myScrollSupport.setEnabled(enabled);
    }

    @Override
    public boolean isAutoScrollEnabled() {
        return this.myScrollSupport.isEnabled();
    }

    public Rediffers getDiffUpdater() {
        return this.myDiffUpdater;
    }

    @Override
    public void onContentChangedIn(EditorSource source) {
        this.myDiffUpdater.contentRemoved(source);
        final EditorEx editor = source.getEditor();
        if (this.myIsHorizontal && source.getSide() == FragmentSide.SIDE1 && editor != null) {
            editor.setVerticalScrollbarOrientation(0);
        }
        DiffSideView viewSide = this.getSideView(source.getSide());
        viewSide.setEditorSource(this.getProject(), source);
        Disposer.dispose((Disposable)this.myScrollSupport);
        if (editor == null) {
            if (!this.myDisposed) {
                this.rediff();
            }
            return;
        }
        final MouseListener mouseListener = PopupHandler.installUnknownPopupHandler((JComponent)editor.getContentComponent(), (ActionGroup)new MergeActionGroup(this, source.getSide()), (ActionManager)ActionManager.getInstance());
        this.myDiffUpdater.contentAdded(source);
        editor.getSettings().setLineNumbersShown(true);
        editor.getSettings().setFoldingOutlineShown(false);
        editor.getFoldingModel().setFoldingEnabled(false);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
        Editor editor1 = this.getEditor(FragmentSide.SIDE1);
        Editor editor2 = this.getEditor(FragmentSide.SIDE2);
        if (editor1 != null && editor2 != null && this.myIsSyncScroll) {
            this.myScrollSupport.install(new EditingSides[]{this});
        }
        final VisibleAreaListener visibleAreaListener = this.mySplitter.getVisibleAreaListener();
        final ScrollingModelEx scrollingModel = editor.getScrollingModel();
        if (visibleAreaListener != null) {
            scrollingModel.addVisibleAreaListener(visibleAreaListener);
            scrollingModel.addVisibleAreaListener(this.myVisibleAreaListener);
        }
        this.myFontSizeSynchronizer.synchronize(editor);
        source.addDisposable(new Disposable(){

            public void dispose() {
                DiffPanelImpl.this.myFontSizeSynchronizer.stopSynchronize(editor);
            }
        });
        source.addDisposable(new Disposable(){

            public void dispose() {
                if (visibleAreaListener != null) {
                    scrollingModel.removeVisibleAreaListener(visibleAreaListener);
                    scrollingModel.removeVisibleAreaListener(DiffPanelImpl.this.myVisibleAreaListener);
                }
                editor.getContentComponent().removeMouseListener(mouseListener);
            }
        });
    }

    @Override
    public void setCurrentSide(@NotNull DiffSideView viewSide) {
        if (viewSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSide", "com/intellij/openapi/diff/impl/DiffPanelImpl", "setCurrentSide"));
        }
        LOG.assertTrue(viewSide != this.myCurrentSide);
        if (this.myCurrentSide != null) {
            this.myCurrentSide.beSlave();
        }
        this.myCurrentSide = viewSide;
    }

    public DiffSideView getCurrentSide() {
        return this.myCurrentSide;
    }

    @Override
    public Project getProject() {
        return this.myData.getProject();
    }

    @Override
    public void showSource(@Nullable OpenFileDescriptor descriptor) {
        this.myOptions.showSource(descriptor);
    }

    @Override
    public DiffPanelOptions getOptions() {
        return this.myOptions;
    }

    @Override
    public Editor getEditor(FragmentSide side) {
        return this.getSideView(side).getEditor();
    }

    public DiffSideView getSideView(FragmentSide side) {
        if (side == FragmentSide.SIDE1) {
            return this.myLeftSide;
        }
        if (side == FragmentSide.SIDE2) {
            return this.myRightSide;
        }
        throw new IllegalArgumentException(String.valueOf(side));
    }

    @Override
    public LineBlocks getLineBlocks() {
        return this.myLineBlocks;
    }

    static JComponent createComponentForTitle(@Nullable String title, @Nullable LineSeparator sep1, @Nullable LineSeparator sep2, boolean left) {
        if (sep1 != null && sep2 != null && !sep1.equals((Object)sep2)) {
            LineSeparator separator = left ? sep1 : sep2;
            JPanel bottomPanel = new JPanel(new BorderLayout());
            JLabel sepLabel = new JLabel(separator.name());
            sepLabel.setForeground((Color)(separator.equals((Object)LineSeparator.CRLF) ? JBColor.RED : PlatformColors.BLUE));
            bottomPanel.add((Component)sepLabel, left ? "East" : "West");
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add(new JLabel(title == null ? "" : title));
            panel2.add((Component)bottomPanel, "South");
            return panel2;
        }
        return new JBLabel(title == null ? "" : title);
    }

    public boolean canShowRequest(DiffRequest request) {
        return this.myParentTool != null && this.myParentTool.canShow(request);
    }

    public void setDiffRequest(DiffRequest data) {
        this.myDiffRequest = data;
        if (data.getHints().contains(DiffTool.HINT_DO_NOT_IGNORE_WHITESPACES)) {
            this.setComparisonPolicy(ComparisonPolicy.DEFAULT, false);
        }
        this.myDataProvider.putData(this.myDiffRequest.getGenericData());
        DiffContent content1 = data.getContents()[0];
        DiffContent content2 = data.getContents()[1];
        this.setContents(content1, content2);
        this.setTitles(data);
        DiffPanelImpl.setWindowTitle(this.myOwnerWindow, data.getWindowTitle());
        this.myPanel.setToolbarActions(this.createToolbar());
        data.customizeToolbar(this.myPanel.resetToolbar());
        this.myPanel.registerToolbarActions();
        DiffPanelImpl.initEditorSettings(this.getEditor1());
        DiffPanelImpl.initEditorSettings(this.getEditor2());
        JComponent oldBottomComponent = this.myPanel.getBottomComponent();
        if (oldBottomComponent instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)oldBottomComponent));
        }
        JComponent newBottomComponent = data.getBottomComponent();
        this.myPanel.setBottomComponent(newBottomComponent);
        if (this.myIsRequestFocus) {
            boolean isEditor2Focused;
            IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
            boolean isEditor1Focused = this.getEditor1() != null && fm.getFocusedDescendantFor((Component)this.getEditor1().getComponent()) != null;
            boolean bl = isEditor2Focused = this.myData.getContent2() != null && this.getEditor2() != null && fm.getFocusedDescendantFor((Component)this.getEditor2().getComponent()) != null;
            if (isEditor1Focused || isEditor2Focused) {
                Editor e;
                Editor editor = e = isEditor2Focused ? this.getEditor2() : this.getEditor1();
                if (e != null) {
                    fm.requestFocus((Component)e.getContentComponent(), true);
                }
            }
            this.myPanel.requestScrollEditors();
        }
    }

    private static void initEditorSettings(@Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        Project project2 = editor.getProject();
        DiffMergeSettings settings = project2 == null ? null : (DiffMergeSettings)ServiceManager.getService((Project)project2, DiffToolSettings.class);
        for (DiffMergeEditorSetting property : DiffMergeEditorSetting.values()) {
            property.apply(editor, settings == null ? property.getDefault() : settings.getPreference(property));
        }
        ((EditorEx)editor).getGutterComponentEx().setShowDefaultGutterPopup(false);
    }

    private void setTitles(@NotNull DiffRequest data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/diff/impl/DiffPanelImpl", "setTitles"));
        }
        LineSeparator sep1 = data.getContents()[0].getLineSeparator();
        LineSeparator sep2 = data.getContents()[1].getLineSeparator();
        String title1 = DiffPanelImpl.addReadOnly(data.getContentTitles()[0], this.myLeftSide.getEditor());
        String title2 = DiffPanelImpl.addReadOnly(data.getContentTitles()[1], this.myRightSide.getEditor());
        this.setTitle1(DiffPanelImpl.createComponentForTitle(title1, sep1, sep2, true));
        this.setTitle2(DiffPanelImpl.createComponentForTitle(title2, sep1, sep2, false));
    }

    private void setTitle1(JComponent title) {
        this.myLeftSide.setTitle(title);
    }

    private void setTitle2(JComponent title) {
        this.myRightSide.setTitle(title);
    }

    private static void setWindowTitle(Window window, String title) {
        if (window instanceof JDialog) {
            ((JDialog)window).setTitle(title);
        } else if (window instanceof JFrame) {
            ((JFrame)window).setTitle(title);
        }
    }

    @Nullable
    public static DiffPanelImpl fromDataContext(DataContext dataContext) {
        DiffViewer viewer = (DiffViewer)PlatformDataKeys.DIFF_VIEWER.getData(dataContext);
        return viewer instanceof DiffPanelImpl ? (DiffPanelImpl)viewer : null;
    }

    public Window getOwnerWindow() {
        return this.myOwnerWindow;
    }

    public void focusOppositeSide() {
        if (this.myCurrentSide == this.myLeftSide) {
            this.myRightSide.getEditor().getContentComponent().requestFocus();
        } else {
            this.myLeftSide.getEditor().getContentComponent().requestFocus();
        }
    }

    public void setRequestFocus(boolean isRequestFocus) {
        this.myIsRequestFocus = isRequestFocus;
    }

    private class DiffNavigatable
    implements Navigatable {
        private final DiffSideView mySide;

        public DiffNavigatable(DiffSideView side) {
            this.mySide = side;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public boolean canNavigate() {
            return true;
        }

        public void navigate(boolean requestFocus) {
            DiffPanelImpl.this.showSource(this.mySide.getCurrentOpenFileDescriptor());
        }
    }

    public static class DiffIsApproximate
    extends EditorNotificationPanel {
        public DiffIsApproximate() {
            this.myLabel.setText("<html>Couldn't find context for patch. Some fragments were applied at the best possible place. <b>Please check carefully.</b></html>");
        }
    }

    public static class CanNotCalculateDiffPanel
    extends EditorNotificationPanel {
        public CanNotCalculateDiffPanel() {
            this.myLabel.setText("Can not calculate diff. File is too big and there are too many changes.");
        }
    }

    public static class LineSeparatorsOnlyDiffPanel
    extends FileContentsAreIdenticalDiffPanel {
        public LineSeparatorsOnlyDiffPanel() {
            this.myLabel.setText(DiffBundle.message((String)"diff.contents.have.differences.only.in.line.separators.message.text", (Object[])new Object[0]));
        }
    }

    public static class FileContentsAreIdenticalDiffPanel
    extends EditorNotificationPanel {
        public FileContentsAreIdenticalDiffPanel() {
            this.myLabel.setText(DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]));
        }
    }

    private class MyGenericDataProvider
    extends GenericDataProvider {
        private final DiffPanelImpl myDiffPanel;
        private final FocusDiffSide myFocusDiffSide = new FocusDiffSide(){

            @Override
            public Editor getEditor() {
                return MyGenericDataProvider.this.myDiffPanel.getCurrentSide().getEditor();
            }

            @Override
            public int[] getFragmentStartingLines() {
                return MyGenericDataProvider.this.myDiffPanel.getFragmentBeginnings();
            }
        };

        private MyGenericDataProvider(DiffPanelImpl diffPanel) {
            this.myDiffPanel = diffPanel;
        }

        @Override
        public Object getData(String dataId) {
            DiffSideView currentSide;
            if (PlatformDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myDiffPanel;
            }
            if (FocusDiffSide.DATA_KEY.is(dataId)) {
                return this.myDiffPanel.myCurrentSide == null ? null : this.myFocusDiffSide;
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && (currentSide = this.myDiffPanel.myCurrentSide) != null) {
                return new DiffNavigatable(currentSide);
            }
            return super.getData(dataId);
        }
    }

    private static class NavigationContextChecker {
        private final Iterator<Pair<Integer, String>> myChangedLinesIterator;
        private final DiffNavigationContext myContext;

        private NavigationContextChecker(Iterator<Pair<Integer, String>> changedLinesIterator, DiffNavigationContext context) {
            this.myChangedLinesIterator = changedLinesIterator;
            this.myContext = context;
        }

        public int contextMatchCheck() {
            Pair<Integer, String> pair;
            Iterable contextLines = this.myContext.getPreviousLinesIterable();
            Iterator iterator = contextLines.iterator();
            if (iterator.hasNext()) {
                String contextLine = ((String)iterator.next()).trim();
                while (this.myChangedLinesIterator.hasNext()) {
                    pair = this.myChangedLinesIterator.next();
                    if (!((String)pair.getSecond()).trim().equals(contextLine)) continue;
                    if (!iterator.hasNext()) break;
                    contextLine = ((String)iterator.next()).trim();
                }
                if (iterator.hasNext()) {
                    return -1;
                }
            }
            if (!this.myChangedLinesIterator.hasNext()) {
                return -1;
            }
            String targetLine = this.myContext.getTargetString().trim();
            while (this.myChangedLinesIterator.hasNext()) {
                pair = this.myChangedLinesIterator.next();
                if (!((String)pair.getSecond()).trim().equals(targetLine)) continue;
                return (Integer)pair.getFirst();
            }
            return -1;
        }
    }

    private static class ChangedLinesIterator
    implements Iterator<Pair<Integer, String>> {
        private final Document myDocument;
        private final boolean myIgnoreFragmentsType;
        private final Iterator<Fragment> myFragmentsIterator;
        private final List<Pair<Integer, String>> myBuffer;

        private ChangedLinesIterator(Iterator<Fragment> fragmentsIterator, Document document, boolean ignoreFragmentsType) {
            this.myFragmentsIterator = fragmentsIterator;
            this.myDocument = document;
            this.myIgnoreFragmentsType = ignoreFragmentsType;
            this.myBuffer = new LinkedList<Pair<Integer, String>>();
        }

        @Override
        public boolean hasNext() {
            return !this.myBuffer.isEmpty() || this.myFragmentsIterator.hasNext();
        }

        @Override
        public Pair<Integer, String> next() {
            if (!this.myBuffer.isEmpty()) {
                return this.myBuffer.remove(0);
            }
            Fragment fragment = null;
            while (this.myFragmentsIterator.hasNext()) {
                fragment = this.myFragmentsIterator.next();
                TextDiffTypeEnum type = fragment.getType();
                if (!this.myIgnoreFragmentsType && (type == null || TextDiffTypeEnum.DELETED.equals((Object)type) || TextDiffTypeEnum.NONE.equals((Object)type))) continue;
            }
            if (fragment == null) {
                return null;
            }
            TextRange textRange = fragment.getRange(FragmentSide.SIDE2);
            ApplicationManager.getApplication().runReadAction(() -> {
                int startLine = this.myDocument.getLineNumber(textRange.getStartOffset());
                int endFragmentOffset = textRange.getEndOffset();
                int endLine = this.myDocument.getLineNumber(endFragmentOffset);
                for (int i2 = startLine; i2 <= endLine; ++i2) {
                    int lineEndOffset = this.myDocument.getLineEndOffset(i2);
                    int lineStartOffset = this.myDocument.getLineStartOffset(i2);
                    if (lineEndOffset > endFragmentOffset && endFragmentOffset == lineStartOffset) {
                        lineEndOffset = endFragmentOffset;
                    }
                    if (lineStartOffset > lineEndOffset) continue;
                    String text = this.myDocument.getText().substring(lineStartOffset, lineEndOffset);
                    this.myBuffer.add((Pair<Integer, String>)new Pair((Object)i2, (Object)text));
                }
            });
            if (this.myBuffer.isEmpty()) {
                return null;
            }
            return this.myBuffer.remove(0);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyScrollingPanel
    implements DiffPanelOuterComponent.ScrollingPanel {
        private MyScrollingPanel() {
        }

        @Override
        public void scrollEditors() {
            DiffNavigationContext scrollContext;
            DiffPanelImpl.this.getOptions().onNewContent(DiffPanelImpl.this.myCurrentSide);
            DiffNavigationContext diffNavigationContext = scrollContext = DiffPanelImpl.this.myDiffRequest == null ? null : (DiffNavigationContext)DiffPanelImpl.this.myDiffRequest.getGenericData().get(DiffTool.SCROLL_TO_LINE.getName());
            if (scrollContext == null) {
                this.scrollCurrentToFirstDiff();
            } else {
                Document document = DiffPanelImpl.this.myRightSide.getEditor().getDocument();
                FragmentList fragmentList = DiffPanelImpl.this.getFragments();
                Application application = ApplicationManager.getApplication();
                application.executeOnPooledThread(() -> {
                    ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(fragmentList.iterator(), document, false);
                    CacheOneStepIterator cacheOneStepIterator = new CacheOneStepIterator((Iterator)changedLinesIterator);
                    NavigationContextChecker checker = new NavigationContextChecker((Iterator)cacheOneStepIterator, scrollContext);
                    int line = checker.contextMatchCheck();
                    if (line < 0) {
                        ChangedLinesIterator changedLinesIterator2 = new ChangedLinesIterator(fragmentList.iterator(), document, true);
                        CacheOneStepIterator cacheOneStepIterator2 = new CacheOneStepIterator((Iterator)changedLinesIterator2);
                        NavigationContextChecker checker2 = new NavigationContextChecker((Iterator)cacheOneStepIterator2, scrollContext);
                        line = checker2.contextMatchCheck();
                    }
                    int finalLine = line;
                    ModalityState modalityState = DiffPanelImpl.this.myOwnerWindow == null ? ModalityState.NON_MODAL : ModalityState.stateForComponent((Component)DiffPanelImpl.this.myOwnerWindow);
                    application.invokeLater(() -> {
                        if (finalLine >= 0) {
                            int line1 = DiffPanelImpl.this.myLineBlocks.transform(DiffPanelImpl.this.myRightSide.getSide(), finalLine);
                            DiffPanelImpl.this.myLeftSide.scrollToFirstDiff(line1);
                        } else {
                            this.scrollCurrentToFirstDiff();
                        }
                    }, modalityState);
                });
            }
        }

        private void scrollCurrentToFirstDiff() {
            int[] fragments = DiffPanelImpl.this.getFragmentBeginnings();
            if (fragments.length > 0) {
                DiffPanelImpl.this.myCurrentSide.scrollToFirstDiff(fragments[0]);
            }
        }
    }
}

