/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.JarFileDiffElement;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.diff.impl.dir.DirDiffDialog;
import com.intellij.openapi.diff.impl.dir.DirDiffFrame;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffManagerImpl
extends DirDiffManager {
    private final Project myProject;

    public DirDiffManagerImpl(Project project2) {
        this.myProject = project2;
    }

    public void showDiff(@NotNull DiffElement dir1, @NotNull DiffElement dir2, DirDiffSettings settings, @Nullable Runnable onWindowClosing) {
        if (dir1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir1", "com/intellij/openapi/diff/impl/dir/DirDiffManagerImpl", "showDiff"));
        }
        if (dir2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir2", "com/intellij/openapi/diff/impl/dir/DirDiffManagerImpl", "showDiff"));
        }
        DirDiffTableModel model = new DirDiffTableModel(this.myProject, dir1, dir2, settings);
        if (settings.showInFrame) {
            DirDiffFrame frame = new DirDiffFrame(this.myProject, model);
            this.setWindowListener(onWindowClosing, frame.getFrame());
            frame.show();
        } else {
            DirDiffDialog dirDiffDialog = new DirDiffDialog(this.myProject, model);
            if (this.myProject == null || this.myProject.isDefault()) {
                dirDiffDialog.setModal(true);
            }
            this.setWindowListener(onWindowClosing, dirDiffDialog.getOwner());
            dirDiffDialog.show();
        }
    }

    public static boolean isFromModalDialog(Project project2) {
        Component owner = IdeFocusManager.getInstance((Project)project2).getFocusOwner();
        if (owner != null) {
            DialogWrapper instance = DialogWrapper.findInstance((Component)owner);
            return instance != null && instance.isModal();
        }
        return false;
    }

    private void setWindowListener(final Runnable onWindowClosing, final Window window) {
        if (onWindowClosing != null) {
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    onWindowClosing.run();
                    window.removeWindowListener(this);
                }
            });
        }
    }

    public void showDiff(@NotNull DiffElement dir1, @NotNull DiffElement dir2, DirDiffSettings settings) {
        if (dir1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir1", "com/intellij/openapi/diff/impl/dir/DirDiffManagerImpl", "showDiff"));
        }
        if (dir2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir2", "com/intellij/openapi/diff/impl/dir/DirDiffManagerImpl", "showDiff"));
        }
        this.showDiff(dir1, dir2, settings, null);
    }

    public void showDiff(@NotNull DiffElement dir1, @NotNull DiffElement dir2) {
        if (dir1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir1", "com/intellij/openapi/diff/impl/dir/DirDiffManagerImpl", "showDiff"));
        }
        if (dir2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir2", "com/intellij/openapi/diff/impl/dir/DirDiffManagerImpl", "showDiff"));
        }
        this.showDiff(dir1, dir2, new DirDiffSettings());
    }

    public boolean canShow(@NotNull DiffElement dir1, @NotNull DiffElement dir2) {
        if (dir1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir1", "com/intellij/openapi/diff/impl/dir/DirDiffManagerImpl", "canShow"));
        }
        if (dir2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir2", "com/intellij/openapi/diff/impl/dir/DirDiffManagerImpl", "canShow"));
        }
        return dir1.isContainer() && dir2.isContainer();
    }

    public DiffElement createDiffElement(Object obj) {
        if (obj instanceof VirtualFile) {
            VirtualFile file2 = (VirtualFile)obj;
            return "jar".equalsIgnoreCase(file2.getExtension()) ? new JarFileDiffElement(file2) : new VirtualFileDiffElement(file2);
        }
        return null;
    }

    public DirDiffModel createDiffModel(DiffElement e1, DiffElement e2, DirDiffSettings settings) {
        DirDiffTableModel newModel = new DirDiffTableModel(this.myProject, e1, e2, settings);
        newModel.reloadModelSynchronously();
        return newModel;
    }
}

