/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.SelectOccurrencesActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnselectPreviousOccurrenceAction
extends EditorAction {
    protected UnselectPreviousOccurrenceAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends SelectOccurrencesActionHandler {
        private Handler() {
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/UnselectPreviousOccurrenceAction$Handler", "isEnabledForCaret"));
            }
            if (caret == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actions/UnselectPreviousOccurrenceAction$Handler", "isEnabledForCaret"));
            }
            return editor.getCaretModel().supportsMultipleCarets();
        }

        public void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor.getCaretModel().getCaretCount() > 1) {
                editor.getCaretModel().removeCaret(editor.getCaretModel().getPrimaryCaret());
            } else {
                editor.getSelectionModel().removeSelection();
            }
            Handler.getAndResetNotFoundStatus(editor);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }
}

