/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    public EditorColorsSchemeImpl(EditorColorsScheme parentScheme) {
        super(parentScheme);
    }

    public void setAttributes(@NotNull TextAttributesKey key2, @NotNull TextAttributes attributes) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "setAttributes"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "setAttributes"));
        }
        if (attributes == TextAttributes.USE_INHERITED_MARKER || attributes != this.getAttributes(key2)) {
            this.myAttributesMap.put(key2, attributes);
        }
    }

    public void setColor(ColorKey key2, Color color) {
        if (!Comparing.equal((Object)color, (Object)this.getColor(key2))) {
            this.myColorsMap.put(key2, color);
        }
    }

    public TextAttributes getAttributes(@Nullable TextAttributesKey key2) {
        if (key2 != null) {
            TextAttributes attributes = this.getDirectlyDefinedAttributes(key2);
            if (attributes != null && attributes != TextAttributes.USE_INHERITED_MARKER) {
                return attributes;
            }
            TextAttributesKey fallbackKey = key2.getFallbackAttributeKey();
            if (fallbackKey != null && (attributes = this.getFallbackAttributes(fallbackKey)) != null) {
                return attributes;
            }
        }
        return this.myParentScheme.getAttributes(key2);
    }

    @Nullable
    public Color getColor(ColorKey key2) {
        if (this.myColorsMap.containsKey(key2)) {
            return (Color)this.myColorsMap.get(key2);
        }
        return this.myParentScheme.getColor(key2);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.myParentScheme);
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }

    @Override
    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.compareAttributes(otherScheme, new ArrayList<Function<TextAttributesKey, Boolean>>());
    }

    @Override
    protected boolean colorsEqual(AbstractColorsScheme otherScheme) {
        return this.compareColors(otherScheme, new ArrayList<Function<ColorKey, Boolean>>());
    }

    private boolean compareAttributes(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Function<TextAttributesKey, Boolean>> filters) {
        if (otherScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherScheme", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "compareAttributes"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "compareAttributes"));
        }
        for (TextAttributesKey key3 : this.myAttributesMap.keySet()) {
            if (EditorColorsSchemeImpl.isTextAttributeKeyIgnored(filters, key3) || this.getAttributes(key3).equals((Object)otherScheme.getAttributes(key3))) continue;
            return false;
        }
        filters.add(key2 -> this.myAttributesMap.containsKey(key2));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareAttributes(otherScheme, filters);
    }

    private static boolean isTextAttributeKeyIgnored(@NotNull Collection<Function<TextAttributesKey, Boolean>> filters, TextAttributesKey key2) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "isTextAttributeKeyIgnored"));
        }
        for (Function<TextAttributesKey, Boolean> filter : filters) {
            if (!filter.apply(key2).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean compareColors(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Function<ColorKey, Boolean>> filters) {
        if (otherScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherScheme", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "compareColors"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "compareColors"));
        }
        for (ColorKey key3 : this.myColorsMap.keySet()) {
            Color thisColor = this.getColor(key3);
            Color otherColor = otherScheme.getColor(key3);
            if (thisColor == null) {
                return otherColor == null;
            }
            if (EditorColorsSchemeImpl.isColorKeyIgnored(filters, key3) || thisColor.equals(otherColor)) continue;
            return false;
        }
        filters.add(key2 -> this.myColorsMap.containsKey(key2));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareColors(otherScheme, filters);
    }

    private static boolean isColorKeyIgnored(@NotNull Collection<Function<ColorKey, Boolean>> filters, ColorKey key2) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "isColorKeyIgnored"));
        }
        for (Function<ColorKey, Boolean> filter : filters) {
            if (!filter.apply(key2).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

