/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedSoftWrapsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"forced.soft.wraps.notification.panel");
    private static final String DISABLED_NOTIFICATION_KEY = "disable.forced.soft.wraps.notification";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key2 = KEY;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ForcedSoftWrapsNotificationProvider", "getKey"));
        }
        return key2;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/ForcedSoftWrapsNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/openapi/editor/impl/ForcedSoftWrapsNotificationProvider", "createNotificationPanel"));
        }
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Project project2 = editor.getProject();
        if (project2 == null || !Boolean.TRUE.equals(editor.getUserData(EditorImpl.FORCED_SOFT_WRAPS)) || PropertiesComponent.getInstance().isTrueValue(DISABLED_NOTIFICATION_KEY)) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(EditorBundle.message((String)"forced.soft.wrap.message", (Object[])new Object[0]));
        panel2.createActionLabel(EditorBundle.message((String)"forced.soft.wrap.hide.message", (Object[])new Object[0]), () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/ForcedSoftWrapsNotificationProvider", "lambda$createNotificationPanel$0"));
            }
            editor.putUserData(EditorImpl.FORCED_SOFT_WRAPS, null);
            EditorNotifications.getInstance((Project)project2).updateNotifications(file2);
        });
        panel2.createActionLabel(EditorBundle.message((String)"forced.soft.wrap.dont.show.again.message", (Object[])new Object[0]), () -> {
            PropertiesComponent.getInstance().setValue(DISABLED_NOTIFICATION_KEY, "true");
            EditorNotifications.getInstance((Project)project2).updateAllNotifications();
        });
        return panel2;
    }
}

