/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.TIntArrayList;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorSizeManager
extends InlayModel.SimpleAdapter
implements PrioritizedDocumentListener,
Disposable,
FoldingListener,
Dumpable {
    private static final Logger LOG = Logger.getInstance(EditorSizeManager.class);
    private static final int UNKNOWN_WIDTH = Integer.MAX_VALUE;
    private final EditorView myView;
    private final EditorImpl myEditor;
    private final DocumentEx myDocument;
    private final TIntArrayList myLineWidths = new TIntArrayList();
    private int myWidthInPixels;
    private int myMaxLineWithExtensionWidth;
    private int myWidestLineWithExtension;
    private int myDocumentChangeStartOffset;
    private int myDocumentChangeEndOffset;
    private int myFoldingChangeStartOffset = Integer.MAX_VALUE;
    private int myFoldingChangeEndOffset = Integer.MIN_VALUE;
    private int myVirtualPageHeight;
    private boolean myDirty;
    private final List<TextRange> myDeferredRanges = new ArrayList<TextRange>();
    private final SoftWrapAwareDocumentParsingListenerAdapter mySoftWrapChangeListener = new SoftWrapAwareDocumentParsingListenerAdapter(){

        @Override
        public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/view/EditorSizeManager$1", "onRecalculationEnd"));
            }
            EditorSizeManager.this.onSoftWrapRecalculationEnd(event);
        }
    };

    EditorSizeManager(EditorView view) {
        this.myView = view;
        this.myEditor = view.getEditor();
        this.myDocument = this.myEditor.getDocument();
        this.myDocument.addDocumentListener(this, this);
        this.myEditor.getFoldingModel().addListener(this, this);
        this.myEditor.getSoftWrapModel().getApplianceManager().addListener(this.mySoftWrapChangeListener);
        this.myEditor.getInlayModel().addListener((InlayModel.Listener)this, this);
    }

    public void dispose() {
        this.myEditor.getSoftWrapModel().getApplianceManager().removeListener(this.mySoftWrapChangeListener);
    }

    @Override
    public int getPriority() {
        return 110;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.myDocumentChangeStartOffset = event.getOffset();
        this.myDocumentChangeEndOffset = event.getOffset() + event.getNewLength();
    }

    public void documentChanged(DocumentEvent event) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.doInvalidateRange(this.myDocumentChangeStartOffset, this.myDocumentChangeEndOffset);
        this.assertValidState();
    }

    @Override
    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/openapi/editor/impl/view/EditorSizeManager", "onFoldRegionStateChange"));
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (region.isValid()) {
            this.myFoldingChangeStartOffset = Math.min(this.myFoldingChangeStartOffset, region.getStartOffset());
            this.myFoldingChangeEndOffset = Math.max(this.myFoldingChangeEndOffset, region.getEndOffset());
        }
    }

    @Override
    public void onFoldProcessingEnd() {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myFoldingChangeStartOffset <= this.myFoldingChangeEndOffset) {
            this.doInvalidateRange(this.myFoldingChangeStartOffset, this.myFoldingChangeEndOffset);
        }
        this.myFoldingChangeStartOffset = Integer.MAX_VALUE;
        this.myFoldingChangeEndOffset = Integer.MIN_VALUE;
        for (TextRange range : this.myDeferredRanges) {
            this.onTextLayoutPerformed(range.getStartOffset(), range.getEndOffset());
        }
        this.myDeferredRanges.clear();
        this.assertValidState();
    }

    public void onUpdated(@NotNull Inlay inlay) {
        if (inlay == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/openapi/editor/impl/view/EditorSizeManager", "onUpdated"));
        }
        if (this.myDocument.isInEventsHandling() || this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.doInvalidateRange(inlay.getOffset(), inlay.getOffset());
    }

    private void onSoftWrapRecalculationEnd(IncrementalCacheUpdateEvent event) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        boolean invalidate = true;
        if (this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
            this.myFoldingChangeStartOffset = Math.min(this.myFoldingChangeStartOffset, event.getStartOffset());
            this.myFoldingChangeEndOffset = Math.max(this.myFoldingChangeEndOffset, event.getActualEndOffset());
            invalidate = false;
        }
        if (this.myDocument.isInEventsHandling()) {
            this.myDocumentChangeStartOffset = Math.min(this.myDocumentChangeStartOffset, event.getStartOffset());
            this.myDocumentChangeEndOffset = Math.max(this.myDocumentChangeEndOffset, event.getActualEndOffset());
            invalidate = false;
        }
        if (invalidate) {
            this.doInvalidateRange(event.getStartOffset(), event.getActualEndOffset());
        }
    }

    Dimension getPreferredSize() {
        int widthWithoutCaret;
        int width = widthWithoutCaret = this.getPreferredWidth();
        if (!this.myDocument.isInBulkUpdate()) {
            CaretModelImpl caretModel = this.myEditor.getCaretModel();
            int caretMaxX = (caretModel.isIteratingOverCarets() ? Stream.of(caretModel.getCurrentCaret()) : caretModel.getAllCarets().stream()).filter(Caret::isUpToDate).mapToInt(c -> (int)this.myView.visualPositionToXY(c.getVisualPosition()).getX()).max().orElse(0);
            width = Math.max(width, caretMaxX);
        }
        if (this.shouldRespectAdditionalColumns(widthWithoutCaret)) {
            width += this.myEditor.getSettings().getAdditionalColumnsCount() * this.myView.getPlainSpaceWidth();
        }
        Insets insets = this.myView.getInsets();
        return new Dimension(width + insets.left + insets.right, this.getPreferredHeight());
    }

    int getPreferredWidth(int beginLine, int endLine) {
        int widthWithoutCaret;
        int width = widthWithoutCaret = this.getPreferredWidthWithoutCaret(beginLine, endLine);
        if (!this.myDocument.isInBulkUpdate()) {
            CaretModelImpl caretModel = this.myEditor.getCaretModel();
            int caretMaxX = (caretModel.isIteratingOverCarets() ? Stream.of(caretModel.getCurrentCaret()) : caretModel.getAllCarets().stream()).filter(Caret::isUpToDate).filter(caret -> caret.getVisualPosition().line >= beginLine && caret.getVisualPosition().line < endLine).mapToInt(c -> (int)this.myView.visualPositionToXY(c.getVisualPosition()).getX()).max().orElse(0);
            width = Math.max(width, caretMaxX);
        }
        if (this.shouldRespectAdditionalColumns(widthWithoutCaret)) {
            width += this.myEditor.getSettings().getAdditionalColumnsCount() * this.myView.getPlainSpaceWidth();
        }
        Insets insets = this.myView.getInsets();
        return width + insets.left + insets.right;
    }

    int getPreferredHeight() {
        int lineHeight = this.myView.getLineHeight();
        if (this.myEditor.isOneLineMode()) {
            return lineHeight;
        }
        int size = Math.max(this.myEditor.getVisibleLineCount(), 1) * lineHeight;
        EditorSettings settings = this.myEditor.getSettings();
        if (settings.isAdditionalPageAtBottom()) {
            int visibleAreaHeight = this.myEditor.getScrollingModel().getVisibleArea().height;
            if (visibleAreaHeight > 0 || this.myVirtualPageHeight <= 0) {
                this.myVirtualPageHeight = Math.max(visibleAreaHeight - 2 * lineHeight, lineHeight);
            }
            size += Math.max(this.myVirtualPageHeight, 0);
        } else {
            size += settings.getAdditionalLinesCount() * lineHeight;
        }
        Insets insets = this.myView.getInsets();
        return size + insets.top + insets.bottom;
    }

    private boolean shouldRespectAdditionalColumns(int widthWithoutCaret) {
        return !this.myEditor.getSoftWrapModel().isSoftWrappingEnabled() || this.myEditor.getSoftWrapModel().isRespectAdditionalColumns() || (double)widthWithoutCaret > this.myEditor.getScrollingModel().getVisibleArea().getWidth();
    }

    private int getPreferredWidth() {
        if (this.myWidthInPixels < 0) {
            assert (!this.myDocument.isInBulkUpdate());
            this.myWidthInPixels = this.calculatePreferredWidth();
        }
        this.validateMaxLineWithExtension();
        return Math.max(this.myWidthInPixels, this.myMaxLineWithExtensionWidth);
    }

    private int getPreferredWidthWithoutCaret(int beginLine, int endLine) {
        if (this.myWidthInPixels < 0) {
            assert (!this.myDocument.isInBulkUpdate());
            this.calculatePreferredWidth();
        }
        int maxWidth = 0;
        for (int i2 = beginLine; i2 < endLine && i2 < this.myLineWidths.size(); ++i2) {
            maxWidth = Math.max(maxWidth, Math.abs(this.myLineWidths.get(i2)));
        }
        this.validateMaxLineWithExtension();
        return Math.max(maxWidth, this.myMaxLineWithExtensionWidth);
    }

    private void validateMaxLineWithExtension() {
        if (this.myMaxLineWithExtensionWidth > 0) {
            Project project2 = this.myEditor.getProject();
            VirtualFile virtualFile = this.myEditor.getVirtualFile();
            if (project2 != null && virtualFile != null) {
                for (EditorLinePainter painter : (EditorLinePainter[])EditorLinePainter.EP_NAME.getExtensions()) {
                    Collection<LineExtensionInfo> extensions = painter.getLineExtensions(project2, virtualFile, this.myWidestLineWithExtension);
                    if (extensions == null || extensions.isEmpty()) continue;
                    return;
                }
            }
            this.myMaxLineWithExtensionWidth = 0;
        }
    }

    private int calculatePreferredWidth() {
        if (this.checkDirty()) {
            return 1;
        }
        this.assertValidState();
        VisualLinesIterator iterator = new VisualLinesIterator(this.myEditor, 0);
        int maxWidth = 0;
        while (!iterator.atEnd()) {
            int visualLine = iterator.getVisualLine();
            int width = this.myLineWidths.get(visualLine);
            if (width == Integer.MAX_VALUE) {
                Ref approximateValue = new Ref((Object)Boolean.FALSE);
                width = this.getVisualLineWidth(iterator, () -> approximateValue.set((Object)Boolean.TRUE));
                if (((Boolean)approximateValue.get()).booleanValue()) {
                    width = -width;
                }
                this.myLineWidths.set(visualLine, width);
            }
            maxWidth = Math.max(maxWidth, Math.abs(width));
            iterator.advance();
        }
        return maxWidth;
    }

    int getVisualLineWidth(VisualLinesIterator visualLinesIterator, @Nullable Runnable quickEvaluationListener) {
        assert (!visualLinesIterator.atEnd());
        int visualLine = visualLinesIterator.getVisualLine();
        FoldRegion[] topLevelRegions = this.myEditor.getFoldingModel().fetchTopLevel();
        if (quickEvaluationListener != null && (topLevelRegions == null || topLevelRegions.length == 0) && this.myEditor.getSoftWrapModel().getRegisteredSoftWraps().isEmpty() && !this.myView.getTextLayoutCache().hasCachedLayoutFor(visualLine)) {
            quickEvaluationListener.run();
            return this.myView.getLogicalPositionCache().offsetToLogicalColumn(visualLine, this.myDocument.getLineEndOffset(visualLine) - this.myDocument.getLineStartOffset(visualLine)) * this.myView.getMaxCharWidth();
        }
        float x = 0.0f;
        int maxOffset = visualLinesIterator.getVisualLineStartOffset();
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, visualLinesIterator, quickEvaluationListener)) {
            x = fragment.getEndX();
            maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
        }
        if (this.myEditor.getSoftWrapModel().getSoftWrap(maxOffset) != null) {
            x += (float)this.myEditor.getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
        }
        return (int)x;
    }

    void reset() {
        assert (!this.myDocument.isInBulkUpdate());
        this.doInvalidateRange(0, this.myDocument.getTextLength());
    }

    void invalidateRange(int startOffset, int endOffset) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myDocument.isInEventsHandling()) {
            this.myDocumentChangeStartOffset = Math.min(this.myDocumentChangeStartOffset, startOffset);
            this.myDocumentChangeEndOffset = Math.max(this.myDocumentChangeEndOffset, endOffset);
        } else if (this.myFoldingChangeEndOffset != Integer.MIN_VALUE) {
            this.myFoldingChangeStartOffset = Math.min(this.myFoldingChangeStartOffset, startOffset);
            this.myFoldingChangeEndOffset = Math.max(this.myFoldingChangeEndOffset, endOffset);
        } else {
            this.doInvalidateRange(startOffset, endOffset);
        }
    }

    private void doInvalidateRange(int startOffset, int endOffset) {
        if (this.checkDirty()) {
            return;
        }
        this.myWidthInPixels = -1;
        int startVisualLine = this.myView.offsetToVisualLine(startOffset, false);
        int endVisualLine = this.myView.offsetToVisualLine(endOffset, true);
        int lineDiff = this.myEditor.getVisibleLineCount() - this.myLineWidths.size();
        if (lineDiff > 0) {
            int[] newEntries = new int[lineDiff];
            this.myLineWidths.insert(startVisualLine, newEntries);
        } else if (lineDiff < 0) {
            this.myLineWidths.remove(startVisualLine, -lineDiff);
        }
        for (int i2 = startVisualLine; i2 <= endVisualLine && i2 < this.myLineWidths.size(); ++i2) {
            this.myLineWidths.set(i2, Integer.MAX_VALUE);
        }
    }

    int getMaxLineWithExtensionWidth() {
        return this.myMaxLineWithExtensionWidth;
    }

    void setMaxLineWithExtensionWidth(int lineNumber, int width) {
        this.myWidestLineWithExtension = lineNumber;
        this.myMaxLineWithExtensionWidth = width;
    }

    void textLayoutPerformed(int startOffset, int endOffset) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
            this.myDeferredRanges.add(new TextRange(startOffset, endOffset));
        } else {
            this.onTextLayoutPerformed(startOffset, endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTextLayoutPerformed(int startOffset, int endOffset) {
        if (this.checkDirty()) {
            return;
        }
        boolean purePaintingMode = this.myEditor.isPurePaintingMode();
        boolean foldingEnabled = this.myEditor.getFoldingModel().isFoldingEnabled();
        this.myEditor.setPurePaintingMode(false);
        this.myEditor.getFoldingModel().setFoldingEnabled(true);
        try {
            int startVisualLine = this.myView.offsetToVisualLine(startOffset, false);
            int endVisualLine = this.myView.offsetToVisualLine(endOffset, true);
            boolean sizeInvalidated = false;
            for (int i2 = startVisualLine; i2 <= endVisualLine; ++i2) {
                if (this.myLineWidths.get(i2) >= 0) continue;
                this.myLineWidths.set(i2, Integer.MAX_VALUE);
                sizeInvalidated = true;
            }
            if (sizeInvalidated) {
                this.myWidthInPixels = -1;
                this.myEditor.getContentComponent().revalidate();
            }
        }
        finally {
            this.myEditor.setPurePaintingMode(purePaintingMode);
            this.myEditor.getFoldingModel().setFoldingEnabled(foldingEnabled);
        }
    }

    private boolean checkDirty() {
        if (this.myEditor.getSoftWrapModel().isDirty()) {
            this.myDirty = true;
            return true;
        }
        if (this.myDirty) {
            int visibleLineCount = this.myEditor.getVisibleLineCount();
            int lineDiff = visibleLineCount - this.myLineWidths.size();
            if (lineDiff > 0) {
                this.myLineWidths.add(new int[lineDiff]);
            } else if (lineDiff < 0) {
                this.myLineWidths.remove(visibleLineCount, -lineDiff);
            }
            for (int i2 = 0; i2 < visibleLineCount; ++i2) {
                this.myLineWidths.set(i2, Integer.MAX_VALUE);
            }
            this.myDirty = false;
        }
        return false;
    }

    @NotNull
    public String dumpState() {
        String string = "[cached width: " + this.myWidthInPixels + ", max line with extension width: " + this.myMaxLineWithExtensionWidth + ", line widths: " + this.myLineWidths + "]";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorSizeManager", "dumpState"));
        }
        return string;
    }

    private void assertValidState() {
        if (this.myDocument.isInBulkUpdate() || this.myDirty) {
            return;
        }
        if (this.myLineWidths.size() != this.myEditor.getVisibleLineCount()) {
            LOG.error("Inconsistent state", new Attachment[]{new Attachment("editor.txt", this.myEditor.dumpState())});
            this.reset();
        }
        assert (this.myLineWidths.size() == this.myEditor.getVisibleLineCount());
    }

    public void validateState() {
        this.assertValidState();
    }
}

