/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.RawTextWithMarkup;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.StringBuilderSpinAllocator;
import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyntaxAwareInputStreamTransferableData
extends InputStream
implements RawTextWithMarkup {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractSyntaxAwareInputStreamTransferableData.class.getName()));
    protected String myRawText;
    @NotNull
    protected final SyntaxInfo mySyntaxInfo;
    @NotNull
    private final DataFlavor myDataFlavor;
    @Nullable
    private transient InputStream myDelegate;

    public AbstractSyntaxAwareInputStreamTransferableData(@NotNull SyntaxInfo syntaxInfo, @NotNull DataFlavor flavor) {
        if (syntaxInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxInfo", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareInputStreamTransferableData", "<init>"));
        }
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareInputStreamTransferableData", "<init>"));
        }
        this.mySyntaxInfo = syntaxInfo;
        this.myDataFlavor = flavor;
    }

    @Override
    public DataFlavor getFlavor() {
        return this.myDataFlavor;
    }

    @Override
    public int getOffsetCount() {
        return 0;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        return index;
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        return index;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareInputStreamTransferableData", "read"));
        }
        return this.getDelegate().read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.myDelegate = null;
    }

    @Override
    public void setRawText(String rawText) {
        this.myRawText = rawText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private InputStream getDelegate() {
        if (this.myDelegate != null) {
            InputStream inputStream = this.myDelegate;
            if (inputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareInputStreamTransferableData", "getDelegate"));
            }
            return inputStream;
        }
        int maxLength = Registry.intValue((String)"editor.richcopy.max.size.megabytes") * 0x100000;
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            this.build(buffer, maxLength);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        String s = buffer.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting text: \n" + s);
        }
        try {
            this.myDelegate = new ByteArrayInputStream(s.getBytes(this.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        InputStream inputStream = this.myDelegate;
        InputStream inputStream2 = inputStream;
        if (inputStream2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareInputStreamTransferableData", "getDelegate"));
        }
        return inputStream2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    protected abstract void build(@NotNull StringBuilder var1, int var2);

    @NotNull
    protected abstract String getCharset();
}

