/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RemoveExternalSystemRunConfigurationAction
extends ExternalSystemAction {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return false;
        }
        return selectedNodes.get(0) instanceof RunConfigurationNode;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/action/RemoveExternalSystemRunConfigurationAction", "actionPerformed"));
        }
        Project project2 = this.getProject(e);
        assert (project2 != null);
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1 || !(selectedNodes.get(0) instanceof RunConfigurationNode)) {
            return;
        }
        RunnerAndConfigurationSettings settings = ((RunConfigurationNode)selectedNodes.get(0)).getSettings();
        assert (settings != null);
        int res = Messages.showYesNoDialog((Project)project2, (String)("Delete \"" + settings.getName() + "\"?"), (String)"Confirmation", (Icon)Messages.getQuestionIcon());
        if (res == 0) {
            ((RunManagerEx)RunManager.getInstance((Project)project2)).removeConfiguration(settings);
        }
    }
}

