/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemRunConfigurationProducer
extends RunConfigurationProducer<ExternalSystemRunConfiguration> {
    public AbstractExternalSystemRunConfigurationProducer(@NotNull AbstractExternalSystemTaskConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemRunConfigurationProducer", "<init>"));
        }
        super((ConfigurationType)type);
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "self", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemRunConfigurationProducer", "shouldReplace"));
        }
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemRunConfigurationProducer", "shouldReplace"));
        }
        return true;
    }

    protected boolean setupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Project project2 = AbstractExternalSystemRunConfigurationProducer.getProjectFromContext(context);
        if (project2 == null) {
            return false;
        }
        ExternalSystemTaskExecutionSettings contextTaskExecutionSettings = AbstractExternalSystemRunConfigurationProducer.getTaskSettingsFromContext(context);
        if (contextTaskExecutionSettings == null) {
            return false;
        }
        ExternalSystemTaskExecutionSettings taskExecutionSettings = configuration.getSettings();
        if (!contextTaskExecutionSettings.getExternalSystemId().equals((Object)taskExecutionSettings.getExternalSystemId())) {
            return false;
        }
        taskExecutionSettings.setExternalProjectPath(contextTaskExecutionSettings.getExternalProjectPath());
        taskExecutionSettings.setTaskNames(contextTaskExecutionSettings.getTaskNames());
        configuration.setName(AbstractExternalSystemTaskConfigurationType.generateName(project2, taskExecutionSettings));
        return true;
    }

    public boolean isConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        Project project2 = AbstractExternalSystemRunConfigurationProducer.getProjectFromContext(context);
        if (project2 == null) {
            return false;
        }
        ExternalSystemTaskExecutionSettings contextTaskExecutionSettings = AbstractExternalSystemRunConfigurationProducer.getTaskSettingsFromContext(context);
        if (contextTaskExecutionSettings == null) {
            return false;
        }
        ExternalSystemTaskExecutionSettings taskExecutionSettings = configuration.getSettings();
        if (!contextTaskExecutionSettings.getExternalSystemId().equals((Object)taskExecutionSettings.getExternalSystemId())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)contextTaskExecutionSettings.getExternalProjectPath(), (CharSequence)taskExecutionSettings.getExternalProjectPath())) {
            return false;
        }
        return contextTaskExecutionSettings.getTaskNames().equals(taskExecutionSettings.getTaskNames());
    }

    @Nullable
    private static ExternalSystemTaskExecutionSettings getTaskSettingsFromContext(ConfigurationContext context) {
        Location contextLocation = context.getLocation();
        if (!(contextLocation instanceof ExternalSystemTaskLocation)) {
            return null;
        }
        return ((ExternalSystemTaskLocation)contextLocation).getTaskInfo().getSettings();
    }

    @Nullable
    private static Project getProjectFromContext(ConfigurationContext context) {
        Location contextLocation = context.getLocation();
        if (!(contextLocation instanceof ExternalSystemTaskLocation)) {
            return null;
        }
        return contextLocation.getProject();
    }
}

