/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemBeforeRunTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEditTaskDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ExternalSystemBeforeRunTaskProvider
extends BeforeRunTaskProvider<ExternalSystemBeforeRunTask> {
    private static final Logger LOG = Logger.getInstance(ExternalSystemBeforeRunTaskProvider.class);
    @NotNull
    private final ProjectSystemId mySystemId;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Key<ExternalSystemBeforeRunTask> myId;

    public ExternalSystemBeforeRunTaskProvider(@NotNull ProjectSystemId systemId, @NotNull Project project2, @NotNull Key<ExternalSystemBeforeRunTask> id) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider", "<init>"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider", "<init>"));
        }
        this.mySystemId = systemId;
        this.myProject = project2;
        this.myId = id;
    }

    @NotNull
    public Key<ExternalSystemBeforeRunTask> getId() {
        Key<ExternalSystemBeforeRunTask> key2 = this.myId;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider", "getId"));
        }
        return key2;
    }

    public String getName() {
        return ExternalSystemBundle.message((String)"tasks.before.run.empty", (Object[])new Object[]{this.mySystemId.getReadableName()});
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(RunConfiguration runConfiguration, ExternalSystemBeforeRunTask task) {
        ExternalSystemEditTaskDialog dialog2 = new ExternalSystemEditTaskDialog(this.myProject, task.getTaskExecutionSettings(), this.mySystemId);
        dialog2.setTitle(ExternalSystemBundle.message((String)"tasks.select.task.title", (Object[])new Object[]{this.mySystemId.getReadableName()}));
        return dialog2.showAndGet();
    }

    public boolean canExecuteTask(RunConfiguration configuration, ExternalSystemBeforeRunTask beforeRunTask) {
        ExternalSystemTaskExecutionSettings executionSettings = beforeRunTask.getTaskExecutionSettings();
        ArrayList tasks = ContainerUtilRt.newArrayList();
        for (String taskName : executionSettings.getTaskNames()) {
            tasks.add(new ExternalTaskPojo(taskName, executionSettings.getExternalProjectPath(), null));
        }
        if (tasks.isEmpty()) {
            return true;
        }
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment(this.myProject, this.mySystemId, executionSettings, DefaultRunExecutor.EXECUTOR_ID);
        if (environment == null) {
            return false;
        }
        return environment.getRunner().canRun(DefaultRunExecutor.EXECUTOR_ID, environment.getRunProfile());
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, ExternalSystemBeforeRunTask beforeRunTask) {
        ExternalSystemTaskExecutionSettings executionSettings = beforeRunTask.getTaskExecutionSettings();
        ArrayList tasks = ContainerUtilRt.newArrayList();
        for (String taskName : executionSettings.getTaskNames()) {
            tasks.add(new ExternalTaskPojo(taskName, executionSettings.getExternalProjectPath(), null));
        }
        if (tasks.isEmpty()) {
            return true;
        }
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment(this.myProject, this.mySystemId, executionSettings, DefaultRunExecutor.EXECUTOR_ID);
        if (environment == null) {
            return false;
        }
        ProgramRunner runner = environment.getRunner();
        environment.setExecutionId(env.getExecutionId());
        return RunConfigurationBeforeRunProvider.doRunTask(DefaultRunExecutor.getRunExecutorInstance().getId(), environment, runner);
    }

    public String getDescription(ExternalSystemBeforeRunTask task) {
        String externalProjectPath = task.getTaskExecutionSettings().getExternalProjectPath();
        if (task.getTaskExecutionSettings().getTaskNames().isEmpty()) {
            return ExternalSystemBundle.message((String)"tasks.before.run.empty", (Object[])new Object[]{this.mySystemId.getReadableName()});
        }
        String desc = StringUtil.join((Collection)task.getTaskExecutionSettings().getTaskNames(), (String)" ");
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!this.mySystemId.toString().equals(module2.getOptionValue("external.system.id")) || !StringUtil.equals((CharSequence)externalProjectPath, (CharSequence)module2.getOptionValue("external.linked.project.path"))) continue;
            desc = module2.getName() + ": " + desc;
            break;
        }
        return ExternalSystemBundle.message((String)"tasks.before.run", (Object[])new Object[]{this.mySystemId.getReadableName(), desc});
    }
}

