/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolWindowManager {
    public static void handle(final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager", "handle"));
        }
        for (final ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            final AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project2);
            settings.subscribe((ExternalSystemSettingsListener)new ExternalSystemSettingsListenerAdapter(){

                public void onProjectsLinked(@NotNull Collection linked) {
                    if (linked == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linked", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager$1", "onProjectsLinked"));
                    }
                    if (settings.getLinkedProjectsSettings().size() != 1) {
                        return;
                    }
                    ToolWindow toolWindow = ExternalToolWindowManager.getToolWindow(project2, manager.getSystemId());
                    if (toolWindow != null) {
                        toolWindow.setAvailable(true, null);
                    } else {
                        StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

                            public void run() {
                                if (project2.isDisposed()) {
                                    return;
                                }
                                ExternalSystemUtil.ensureToolWindowInitialized(project2, manager.getSystemId());
                                ToolWindowManager.getInstance((Project)project2).invokeLater(() -> {
                                    if (project2 == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager$1$1", "lambda$run$0"));
                                    }
                                    if (project2.isDisposed()) {
                                        return;
                                    }
                                    ToolWindow toolWindow1 = ExternalToolWindowManager.getToolWindow(project2, manager.getSystemId());
                                    if (toolWindow1 != null) {
                                        toolWindow1.setAvailable(true, null);
                                    }
                                });
                            }
                        });
                    }
                }

                public void onProjectsUnlinked(@NotNull Set linkedProjectPaths) {
                    if (linkedProjectPaths == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPaths", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager$1", "onProjectsUnlinked"));
                    }
                    if (!settings.getLinkedProjectsSettings().isEmpty()) {
                        return;
                    }
                    ToolWindow toolWindow = ExternalToolWindowManager.getToolWindow(project2, manager.getSystemId());
                    if (toolWindow != null) {
                        UIUtil.invokeLaterIfNeeded(() -> toolWindow.setAvailable(false, null));
                    }
                }
            });
        }
    }

    @Nullable
    private static ToolWindow getToolWindow(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager", "getToolWindow"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager", "getToolWindow"));
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
        if (toolWindowManager == null) {
            return null;
        }
        ToolWindow result2 = toolWindowManager.getToolWindow(externalSystemId.getReadableName());
        if (result2 instanceof ToolWindowImpl) {
            ((ToolWindowImpl)result2).ensureContentInitialized();
        }
        return result2;
    }
}

