/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRenderer {
    private static final Color GRAYED = SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
    private static final Color HIDDEN = SimpleTextAttributes.DARK_TEXT.getFgColor();

    public <T> ColoredListCellRenderer<T> forList() {
        return new ColoredListCellRenderer<T>(){

            protected void customizeCellRenderer(@NotNull JList<? extends T> list, T value, int index, boolean selected, boolean focused) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileChooser/tree/FileRenderer$1", "customizeCellRenderer"));
                }
                FileRenderer.this.customize((SimpleColoredComponent)this, value, selected, focused);
            }
        };
    }

    public ColoredTableCellRenderer forTable() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean focused, int row, int column) {
                FileRenderer.this.customize((SimpleColoredComponent)this, value, selected, focused);
            }
        };
    }

    public ColoredTreeCellRenderer forTree() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focused) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/fileChooser/tree/FileRenderer$3", "customizeCellRenderer"));
                }
                FileRenderer.this.customize((SimpleColoredComponent)this, value, selected, focused);
            }
        };
    }

    protected void customize(SimpleColoredComponent renderer, Object value, boolean selected, boolean focused) {
        int style = 0;
        Color color = null;
        Icon icon = null;
        String name = null;
        String comment = null;
        boolean hidden = false;
        boolean valid = true;
        if (value instanceof FileNode) {
            FileNode node = (FileNode)value;
            icon = node.getIcon();
            name = node.getName();
            comment = node.getComment();
            hidden = node.isHidden();
            valid = node.isValid();
        } else if (value instanceof VirtualFile) {
            VirtualFile file2 = (VirtualFile)value;
            name = file2.getName();
            hidden = FileElement.isFileHidden((VirtualFile)file2);
            valid = file2.isValid();
        } else if (value != null) {
            name = value.toString();
            color = GRAYED;
        }
        if (!valid) {
            style |= 4;
        }
        if (hidden) {
            color = HIDDEN;
        }
        renderer.setIcon(!hidden || icon == null ? icon : IconLoader.getTransparentIcon((Icon)icon));
        SimpleTextAttributes attributes = new SimpleTextAttributes(style, color);
        if (name != null) {
            renderer.append(name, attributes);
        }
        if (comment != null) {
            renderer.append(comment, attributes);
        }
    }
}

