/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Producer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class AsyncEditorLoader {
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"AsyncEditorLoader pool", (int)2);
    private static final Key<AsyncEditorLoader> ASYNC_LOADER = Key.create((String)"ASYNC_LOADER");
    private static final int SYNCHRONOUS_LOADING_WAITING_TIME_MS = 200;
    private static final int RETRY_TIME_MS = 10;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final TextEditorImpl myTextEditor;
    @NotNull
    private final TextEditorComponent myEditorComponent;
    @NotNull
    private final TextEditorProvider myProvider;
    private final List<Runnable> myDelayedActions;
    private TextEditorState myDelayedState;
    private final CompletableFuture<?> myLoadingFinished;

    AsyncEditorLoader(@NotNull TextEditorImpl textEditor, @NotNull TextEditorComponent component, @NotNull TextEditorProvider provider) {
        if (textEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditor", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "<init>"));
        }
        this.myDelayedActions = new ArrayList<Runnable>();
        this.myLoadingFinished = new CompletableFuture();
        this.myProvider = provider;
        this.myTextEditor = textEditor;
        this.myProject = textEditor.myProject;
        this.myEditorComponent = component;
        this.myEditor = textEditor.getEditor();
        this.myEditor.putUserData(ASYNC_LOADER, (Object)this);
        this.myEditorComponent.getContentPanel().setVisible(false);
    }

    @NotNull
    Future<?> start() {
        Runnable continuation;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Future<Runnable> continuationFuture = this.scheduleLoading();
        boolean showProgress = true;
        if (this.worthWaiting() && (continuation = AsyncEditorLoader.resultInTimeOrNull(continuationFuture, 200L)) != null) {
            showProgress = false;
            this.loadingFinished(continuation);
        }
        if (showProgress) {
            this.myEditorComponent.startLoading();
        }
        CompletableFuture<?> completableFuture = this.myLoadingFinished;
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "start"));
        }
        return completableFuture;
    }

    private Future<Runnable> scheduleLoading() {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        long startStamp = this.myEditor.getDocument().getModificationStamp();
        return ourExecutor.submit(() -> {
            Ref ref = new Ref();
            try {
                while (!this.myEditorComponent.isDisposed()) {
                    ProgressIndicatorUtils.runWithWriteActionPriority(() -> ref.set(psiDocumentManager.commitAndRunReadAction(() -> this.myProject.isDisposed() ? EmptyRunnable.INSTANCE : this.myTextEditor.loadEditorInBackground())), new ProgressIndicatorBase());
                    Runnable continuation = (Runnable)ref.get();
                    if (continuation != null) {
                        AsyncEditorLoader.invokeLater(() -> {
                            if (startStamp == this.myEditor.getDocument().getModificationStamp()) {
                                this.loadingFinished(continuation);
                            } else if (!this.myProject.isDisposed() && !this.myEditorComponent.isDisposed()) {
                                this.scheduleLoading();
                            }
                        });
                        Runnable runnable2 = continuation;
                        return runnable2;
                    }
                    ProgressIndicatorUtils.yieldToPendingWriteActions();
                }
            }
            finally {
                if (ref.isNull()) {
                    AsyncEditorLoader.invokeLater(() -> this.loadingFinished(null));
                }
            }
            return null;
        });
    }

    private static void invokeLater(Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.any());
    }

    private boolean worthWaiting() {
        return !PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments() && !ApplicationManager.getApplication().isWriteAccessAllowed();
    }

    private static <T> T resultInTimeOrNull(Future<T> future2, long timeMs) {
        try {
            return future2.get(timeMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException exception) {
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void loadingFinished(Runnable continuation) {
        if (this.myLoadingFinished.isDone()) {
            return;
        }
        this.myLoadingFinished.complete(null);
        this.myEditor.putUserData(ASYNC_LOADER, null);
        if (this.myEditorComponent.isDisposed()) {
            return;
        }
        if (continuation != null) {
            continuation.run();
        }
        if (this.myEditorComponent.isLoading()) {
            this.myEditorComponent.stopLoading();
        }
        this.myEditorComponent.getContentPanel().setVisible(true);
        if (this.myDelayedState != null) {
            TextEditorState state = new TextEditorState();
            state.setFoldingState(this.myDelayedState.getFoldingState());
            this.myProvider.setStateImpl(this.myProject, this.myEditor, state);
            this.myDelayedState = null;
        }
        for (Runnable runnable2 : this.myDelayedActions) {
            this.myEditor.getScrollingModel().disableAnimation();
            runnable2.run();
        }
        this.myEditor.getScrollingModel().enableAnimation();
        if (FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor() == this.myEditor) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject((Component)this.myTextEditor.getPreferredFocusedComponent(), this.myProject);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myTextEditor.myFile);
    }

    public static void performWhenLoaded(@NotNull Editor editor, @NotNull Runnable runnable2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "performWhenLoaded"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "performWhenLoaded"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AsyncEditorLoader loader = (AsyncEditorLoader)editor.getUserData(ASYNC_LOADER);
        if (loader == null) {
            runnable2.run();
        } else {
            loader.myDelayedActions.add(runnable2);
        }
    }

    @NotNull
    TextEditorState getEditorState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "getEditorState"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TextEditorState state = this.myProvider.getStateImpl(this.myProject, this.myEditor, level);
        if (!this.myLoadingFinished.isDone() && this.myDelayedState != null) {
            state.setDelayedFoldState((Producer<CodeFoldingState>)((Producer)this.myDelayedState::getFoldingState));
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "getEditorState"));
        }
        return textEditorState;
    }

    void setEditorState(@NotNull TextEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "setEditorState"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myLoadingFinished.isDone()) {
            this.myDelayedState = state;
        }
        this.myProvider.setStateImpl(this.myProject, this.myEditor, state);
    }

    public static boolean isEditorLoaded(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "isEditorLoaded"));
        }
        return editor.getUserData(ASYNC_LOADER) == null;
    }
}

