/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.reference.SoftReference;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyProcessorContext {
    private final List<AnAction> myActions = new ArrayList<AnAction>();
    private WeakReference<JComponent> myFoundComponent;
    private boolean myHasSecondStroke;
    private DataContext myDataContext;
    private boolean isModalContext;
    private WeakReference<Component> myFocusOwner;
    private KeyEvent myInputEvent;

    @NotNull
    List<AnAction> getActions() {
        List<AnAction> list = this.myActions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeyProcessorContext", "getActions"));
        }
        return list;
    }

    @Nullable
    public JComponent getFoundComponent() {
        return (JComponent)SoftReference.dereference(this.myFoundComponent);
    }

    public void setFoundComponent(JComponent foundComponent) {
        this.myFoundComponent = new WeakReference<JComponent>(foundComponent);
    }

    public void setHasSecondStroke(boolean hasSecondStroke) {
        this.myHasSecondStroke = hasSecondStroke;
    }

    public boolean isHasSecondStroke() {
        return this.myHasSecondStroke;
    }

    public DataContext getDataContext() {
        return this.myDataContext;
    }

    public void setDataContext(DataContext dataContext) {
        this.myDataContext = dataContext;
    }

    public boolean isModalContext() {
        return this.isModalContext;
    }

    public void setModalContext(boolean modalContext) {
        this.isModalContext = modalContext;
    }

    @Nullable
    public Component getFocusOwner() {
        return (Component)SoftReference.dereference(this.myFocusOwner);
    }

    public void setFocusOwner(Component focusOwner) {
        this.myFocusOwner = new WeakReference<Component>(focusOwner);
    }

    public void setInputEvent(KeyEvent e) {
        this.myInputEvent = e;
    }

    public KeyEvent getInputEvent() {
        return this.myInputEvent;
    }

    public void clear() {
        this.myInputEvent = null;
        this.myActions.clear();
        this.myFocusOwner = null;
        this.myDataContext = null;
    }
}

