/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

class WeakKeymapManagerListener
implements KeymapManagerListener {
    private final KeymapManagerEx myKeymapManager;
    private final Reference<KeymapManagerListener> myRef;

    WeakKeymapManagerListener(@NotNull KeymapManagerEx keymapManager2, @NotNull KeymapManagerListener delegate) {
        if (keymapManager2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymapManager", "com/intellij/openapi/keymap/impl/WeakKeymapManagerListener", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/keymap/impl/WeakKeymapManagerListener", "<init>"));
        }
        this.myKeymapManager = keymapManager2;
        this.myRef = new WeakReference<KeymapManagerListener>(delegate);
    }

    public boolean isDead() {
        return this.myRef.get() == null;
    }

    public boolean isWrapped(@NotNull KeymapManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/keymap/impl/WeakKeymapManagerListener", "isWrapped"));
        }
        return this.myRef.get() == listener2;
    }

    public void activeKeymapChanged(Keymap keymap) {
        KeymapManagerListener delegate = this.myRef.get();
        if (delegate == null) {
            this.myKeymapManager.removeKeymapManagerListener(this);
        } else {
            delegate.activeKeymapChanged(keymap);
        }
    }
}

