/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.UnknownModuleType;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleFileListener;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectModuleManager", storages={@Storage(value="modules.xml")})
public class ModuleManagerComponent
extends ModuleManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerComponent");

    public ModuleManagerComponent(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/ModuleManagerComponent", "<init>"));
        }
        super(project2);
        this.myMessageBusConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                ModuleManagerComponent.this.cleanCachedStuff();
            }
        });
        this.myMessageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        if (project2.isDefault()) {
            return;
        }
        this.myMessageBusConnection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

            public void projectComponentsInitialized(@NotNull Project project2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/ModuleManagerComponent$2", "projectComponentsInitialized"));
                }
                if (project2 != ModuleManagerComponent.this.myProject) {
                    return;
                }
                long t = System.currentTimeMillis();
                ModuleManagerComponent.this.loadModules(ModuleManagerComponent.this.myModuleModel);
                t = System.currentTimeMillis() - t;
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.info(ModuleManagerComponent.this.myModuleModel.getModules().length + " module(s) loaded in " + t + " ms");
                }
            }
        });
        this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new ModuleFileListener(this));
    }

    @Override
    protected void showUnknownModuleTypeNotification(@NotNull List<Module> modulesWithUnknownTypes) {
        if (modulesWithUnknownTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesWithUnknownTypes", "com/intellij/openapi/module/impl/ModuleManagerComponent", "showUnknownModuleTypeNotification"));
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesWithUnknownTypes.isEmpty()) {
            String message;
            if (modulesWithUnknownTypes.size() == 1) {
                message = ProjectBundle.message((String)"module.unknown.type.single.error", (Object[])new Object[]{modulesWithUnknownTypes.get(0).getName(), ModuleType.get((Module)modulesWithUnknownTypes.get(0)).getId()});
            } else {
                StringBuilder modulesBuilder = new StringBuilder();
                for (Module module2 : modulesWithUnknownTypes) {
                    modulesBuilder.append("<br>\"");
                    modulesBuilder.append(module2.getName()).append("\" (type '").append(ModuleType.get((Module)module2).getId()).append("')");
                }
                modulesBuilder.append("<br>");
                message = ProjectBundle.message((String)"module.unknown.type.multiple.error", (Object[])new Object[]{modulesBuilder.toString()});
            }
            Notifications.Bus.notify((Notification)new Notification("Module Manager", ProjectBundle.message((String)"module.unknown.type.title", (Object[])new Object[0]), message, NotificationType.WARNING), (Project)this.myProject);
        }
    }

    @Override
    @NotNull
    protected ModuleEx createModule(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerComponent", "createModule"));
        }
        ModuleImpl moduleImpl = new ModuleImpl(filePath, this.myProject);
        if (moduleImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerComponent", "createModule"));
        }
        return moduleImpl;
    }

    @Override
    @NotNull
    protected ModuleEx createAndLoadModule(@NotNull String filePath, @NotNull VirtualFile file2) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerComponent", "createAndLoadModule"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/ModuleManagerComponent", "createAndLoadModule"));
        }
        ModuleImpl moduleImpl = new ModuleImpl(filePath, this.myProject);
        if (moduleImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerComponent", "createAndLoadModule"));
        }
        return moduleImpl;
    }

    @Override
    protected boolean isUnknownModuleType(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/impl/ModuleManagerComponent", "isUnknownModuleType"));
        }
        return ModuleType.get((Module)module2) instanceof UnknownModuleType;
    }

    @Override
    protected void fireModulesAdded() {
        for (Module module2 : this.myModuleModel.getModules()) {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> this.fireModuleAddedInWriteAction((ModuleEx)module2));
        }
    }

    @Override
    protected void deliverPendingEvents() {
        this.myMessageBusConnection.deliverImmediately();
    }
}

