/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundTaskUtil {
    private static final Logger LOG = Logger.getInstance(BackgroundTaskUtil.class);

    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, long waitMillis) {
        if (backgroundTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeAndTryWait"));
        }
        ProgressIndicator progressIndicator = BackgroundTaskUtil.executeAndTryWait(backgroundTask, onSlowAction, waitMillis, false);
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeAndTryWait"));
        }
        return progressIndicator;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, long waitMillis, boolean bl) {
        void forceEDT;
        if (backgroundTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeAndTryWait"));
        }
        ModalityState modality = ModalityState.current();
        if (forceEDT != false) {
            EmptyProgressIndicator indicator2 = new EmptyProgressIndicator(modality);
            try {
                Runnable callback2 = (Runnable)backgroundTask.fun((Object)indicator2);
                BackgroundTaskUtil.finish(callback2, (ProgressIndicator)indicator2);
            }
            catch (ProcessCanceledException callback2) {
            }
            catch (Throwable t) {
                LOG.error(t);
            }
            EmptyProgressIndicator emptyProgressIndicator = indicator2;
            if (emptyProgressIndicator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeAndTryWait"));
            }
            return emptyProgressIndicator;
        }
        Pair<Runnable, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (callback, indicator) -> ApplicationManager.getApplication().invokeLater(() -> BackgroundTaskUtil.finish(callback, indicator), modality), modality, waitMillis);
        Runnable callback3 = (Runnable)pair.first;
        ProgressIndicator indicator3 = (ProgressIndicator)pair.second;
        if (callback3 != null) {
            BackgroundTaskUtil.finish(callback3, indicator3);
        } else if (onSlowAction != null) {
            onSlowAction.run();
        }
        ProgressIndicator progressIndicator = indicator3;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeAndTryWait"));
        }
        return progressIndicator;
    }

    private static void finish(@NotNull Runnable result2, @NotNull ProgressIndicator indicator) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "finish"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "finish"));
        }
        if (!indicator.isCanceled()) {
            result2.run();
        }
    }

    @Nullable
    public static <T> T tryComputeFast(@NotNull Function<ProgressIndicator, T> backgroundTask, long waitMillis) {
        if (backgroundTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "tryComputeFast"));
        }
        Pair<T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (result2, indicator) -> {}, ModalityState.defaultModalityState(), waitMillis);
        Object result3 = pair.first;
        ProgressIndicator indicator2 = (ProgressIndicator)pair.second;
        indicator2.cancel();
        return (T)result3;
    }

    @Nullable
    public static <T> T computeInBackgroundAndTryWait(@NotNull Computable<T> computable, @NotNull Consumer<T> asyncCallback, long waitMillis) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "computeInBackgroundAndTryWait"));
        }
        if (asyncCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncCallback", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "computeInBackgroundAndTryWait"));
        }
        Pair<T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(indicator -> {
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$computeInBackgroundAndTryWait$3"));
            }
            return computable.compute();
        }, (result2, indicator) -> {
            if (asyncCallback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncCallback", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$computeInBackgroundAndTryWait$4"));
            }
            asyncCallback.consume(result2);
        }, ModalityState.defaultModalityState(), waitMillis);
        return (T)pair.first;
    }

    @NotNull
    public static <T> Pair<T, ProgressIndicator> computeInBackgroundAndTryWait(@NotNull Function<ProgressIndicator, T> task, @NotNull PairConsumer<T, ProgressIndicator> asyncCallback, @NotNull ModalityState modality, long waitMillis) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "computeInBackgroundAndTryWait"));
        }
        if (asyncCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncCallback", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "computeInBackgroundAndTryWait"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "computeInBackgroundAndTryWait"));
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(modality);
        Helper helper = new Helper();
        indicator.start();
        ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$computeInBackgroundAndTryWait$6(task, (ProgressIndicator)indicator, helper, asyncCallback));
        Object result2 = null;
        if (helper.await(waitMillis)) {
            result2 = helper.getResult();
        }
        Pair pair = Pair.create(result2, (Object)indicator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "computeInBackgroundAndTryWait"));
        }
        return pair;
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Runnable runnable2, @NotNull Disposable parent) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        ProgressIndicator progressIndicator = BackgroundTaskUtil.executeOnPooledThread((Consumer<ProgressIndicator>)((Consumer)indicator -> {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$executeOnPooledThread$7"));
            }
            runnable2.run();
        }), parent);
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        return progressIndicator;
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Consumer<ProgressIndicator> task, @NotNull Disposable parent) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        ModalityState modalityState = ModalityState.defaultModalityState();
        ProgressIndicator progressIndicator = BackgroundTaskUtil.executeOnPooledThread(task, parent, modalityState);
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        return progressIndicator;
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Consumer<ProgressIndicator> task, @NotNull Disposable parent, @NotNull ModalityState modalityState) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(modalityState);
        Disposable disposable = new Disposable((ProgressIndicator)indicator){
            final /* synthetic */ ProgressIndicator val$indicator;
            {
                this.val$indicator = progressIndicator;
            }

            public void dispose() {
                if (this.val$indicator.isRunning()) {
                    this.val$indicator.cancel();
                }
            }
        };
        Disposer.register((Disposable)parent, (Disposable)disposable);
        indicator.start();
        ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$executeOnPooledThread$9(task, (ProgressIndicator)indicator, disposable));
        EmptyProgressIndicator emptyProgressIndicator = indicator;
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        return emptyProgressIndicator;
    }

    private static /* synthetic */ void lambda$executeOnPooledThread$9(@NotNull Consumer task, ProgressIndicator indicator, Disposable disposable) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$executeOnPooledThread$9"));
        }
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$null$8"));
            }
            try {
                task.consume((Object)indicator);
            }
            finally {
                indicator.stop();
                Disposer.dispose((Disposable)disposable);
            }
        }, indicator);
    }

    private static /* synthetic */ void lambda$computeInBackgroundAndTryWait$6(@NotNull Function task, ProgressIndicator indicator, Helper helper, @NotNull PairConsumer asyncCallback) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$computeInBackgroundAndTryWait$6"));
        }
        if (asyncCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncCallback", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$computeInBackgroundAndTryWait$6"));
        }
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$null$5"));
            }
            if (asyncCallback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncCallback", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$null$5"));
            }
            try {
                Object result2 = task.fun((Object)indicator);
                if (!helper.setResult(result2)) {
                    asyncCallback.consume(result2, (Object)indicator);
                }
            }
            finally {
                indicator.stop();
            }
        }, indicator);
    }

    private static class Helper<T> {
        private static final Object INITIAL_STATE = new Object();
        private static final Object SLOW_OPERATION_STATE = new Object();
        private final Semaphore mySemaphore = new Semaphore(0);
        private final AtomicReference<Object> myResultRef = new AtomicReference<Object>(INITIAL_STATE);

        private Helper() {
        }

        public boolean setResult(T result2) {
            boolean isFast = this.myResultRef.compareAndSet(INITIAL_STATE, result2);
            this.mySemaphore.release();
            return isFast;
        }

        public boolean await(long waitMillis) {
            try {
                this.mySemaphore.tryAcquire(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myResultRef.compareAndSet(INITIAL_STATE, SLOW_OPERATION_STATE);
        }

        public T getResult() {
            Object result2 = this.myResultRef.get();
            assert (result2 != INITIAL_STATE && result2 != SLOW_OPERATION_STATE);
            return (T)result2;
        }
    }
}

