/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ProjectRootUtil {
    @NotNull
    public static VirtualFile findSymlinkedFileInContent(@NotNull Project project2, @NotNull VirtualFile forFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ProjectRootUtil", "findSymlinkedFileInContent"));
        }
        if (forFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forFile", "com/intellij/openapi/roots/ProjectRootUtil", "findSymlinkedFileInContent"));
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        if (scope.contains(forFile)) {
            VirtualFile virtualFile = forFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ProjectRootUtil", "findSymlinkedFileInContent"));
            }
            return virtualFile;
        }
        VirtualFile canonicalForFile = forFile.getCanonicalFile();
        if (canonicalForFile == null) {
            canonicalForFile = forFile;
        }
        Collection<VirtualFile> projectFiles = FilenameIndex.getVirtualFilesByName(project2, canonicalForFile.getName(), true, scope);
        for (VirtualFile eachContentFile : projectFiles) {
            if (!canonicalForFile.equals(eachContentFile.getCanonicalFile())) continue;
            VirtualFile virtualFile = eachContentFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ProjectRootUtil", "findSymlinkedFileInContent"));
            }
            return virtualFile;
        }
        VirtualFile virtualFile = forFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ProjectRootUtil", "findSymlinkedFileInContent"));
        }
        return virtualFile;
    }
}

