/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.LocateLibraryDialog;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class IdeaProjectModelModifier
extends JavaProjectModelModifier {
    private static final Logger LOG = Logger.getInstance(IdeaProjectModelModifier.class);
    private final Project myProject;

    public IdeaProjectModelModifier(Project project2) {
        this.myProject = project2;
    }

    @Override
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addModuleDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addModuleDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addModuleDependency"));
        }
        ModuleRootModificationUtil.addDependency((Module)from, (Module)to, (DependencyScope)scope, (boolean)false);
        return Promises.resolvedPromise(null);
    }

    @Override
    public Promise<Void> addExternalLibraryDependency(final @NotNull Collection<Module> modules, final @NotNull ExternalLibraryDescriptor descriptor, final @NotNull DependencyScope scope) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addExternalLibraryDependency"));
        }
        List<String> defaultRoots = descriptor.getLibraryClassesRoots();
        Module firstModule = (Module)ContainerUtil.getFirstItem(modules);
        LOG.assertTrue(firstModule != null);
        LocateLibraryDialog dialog2 = new LocateLibraryDialog(firstModule, defaultRoots, descriptor.getPresentableName());
        List<String> classesRoots = dialog2.showAndGetResult();
        if (!classesRoots.isEmpty()) {
            String libraryName = classesRoots.size() > 1 ? descriptor.getPresentableName() : null;
            final List<String> urls = OrderEntryFix.refreshAndConvertToUrls(classesRoots);
            if (modules.size() == 1) {
                ModuleRootModificationUtil.addModuleLibrary((Module)firstModule, (String)libraryName, urls, Collections.emptyList(), (DependencyScope)scope);
            } else {
                new WriteAction(){

                    protected void run(@NotNull Result result2) {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier$1", "run"));
                        }
                        Library library = LibraryUtil.createLibrary((LibraryTable)LibraryTablesRegistrar.getInstance().getLibraryTable(IdeaProjectModelModifier.this.myProject), (String)descriptor.getPresentableName());
                        Library.ModifiableModel model = library.getModifiableModel();
                        for (String url : urls) {
                            model.addRoot(url, OrderRootType.CLASSES);
                        }
                        model.commit();
                        for (Module module2 : modules) {
                            ModuleRootModificationUtil.addDependency((Module)module2, (Library)library, (DependencyScope)scope, (boolean)false);
                        }
                    }
                }.execute();
            }
        }
        return Promises.resolvedPromise(null);
    }

    @Override
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addLibraryDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addLibraryDependency"));
        }
        OrderEntryUtil.addLibraryToRoots(from, library);
        return Promises.resolvedPromise(null);
    }

    @Override
    public Promise<Void> changeLanguageLevel(@NotNull Module module2, @NotNull LanguageLevel level) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "changeLanguageLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "changeLanguageLevel"));
        }
        LanguageLevel moduleLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module2).getLanguageLevel();
        if (moduleLevel != null && JavaSdkUtil.isLanguageLevelAcceptable(this.myProject, module2, level)) {
            ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
            ((LanguageLevelModuleExtension)rootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
            rootModel.commit();
        } else {
            LanguageLevelProjectExtension.getInstance((Project)this.myProject).setLanguageLevel(level);
            ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.INSTANCE, false, true);
        }
        return Promises.resolvedPromise(null);
    }
}

