/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InheritedJdkOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements InheritedJdkOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    @NonNls
    public static final String ENTRY_TYPE = "inheritedJdk";
    private final MyJdkTableListener myJdkTableListener = new MyJdkTableListener();
    private final MyProjectJdkListener myListener = new MyProjectJdkListener();

    InheritedJdkOrderEntryImpl(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.myProjectRootManagerImpl.addProjectJdkListener(this.myListener);
        this.myProjectRootManagerImpl.addJdkTableListener(this.myJdkTableListener);
        this.init();
    }

    InheritedJdkOrderEntryImpl(Element element, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        this(rootModel, projectRootManager);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException(element.getName());
        }
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new InheritedJdkOrderEntryImpl(rootModel, projectRootManager);
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getJdk() != null;
    }

    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitInheritedJdkOrderEntry((InheritedJdkOrderEntry)this, initialValue);
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element orderEntryElement = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        rootElement.addContent(orderEntryElement);
    }

    public Sdk getJdk() {
        Project project2 = this.getRootModel().getModule().getProject();
        return this.getRootModel().getConfigurationAccessor().getProjectSdk(project2);
    }

    public String getJdkName() {
        Project project2 = this.getRootModel().getModule().getProject();
        return this.getRootModel().getConfigurationAccessor().getProjectSdkName(project2);
    }

    @Override
    protected RootProvider getRootProvider() {
        Sdk projectJdk = this.myProjectRootManagerImpl.getProjectSdk();
        return projectJdk == null ? null : projectJdk.getRootProvider();
    }

    @NotNull
    public String getPresentableName() {
        String string = "< " + this.getJdkName() + " >";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/InheritedJdkOrderEntryImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myProjectRootManagerImpl.removeJdkTableListener(this.myJdkTableListener);
        this.myProjectRootManagerImpl.removeProjectJdkListener(this.myListener);
    }

    private class MyProjectJdkListener
    implements ProjectRootManagerEx.ProjectJdkListener {
        private MyProjectJdkListener() {
        }

        public void projectJdkChanged() {
            InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
        }
    }

    private class MyJdkTableListener
    implements ProjectJdkTable.Listener {
        private MyJdkTableListener() {
        }

        public void jdkRemoved(Sdk jdk2) {
            if (jdk2.equals(InheritedJdkOrderEntryImpl.this.getJdk())) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        public void jdkAdded(Sdk jdk2) {
            if (this.isAffectedByJdk(jdk2)) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        public void jdkNameChanged(Sdk jdk2, String previousName) {
            if (this.isAffectedByJdk(jdk2)) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        private boolean isAffectedByJdk(Sdk jdk2) {
            return jdk2.getName().equals(InheritedJdkOrderEntryImpl.this.getJdkName());
        }
    }
}

