/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="NewModuleRootManager", storages={@Storage(value="$MODULE_FILE$"), @Storage(storageClass=ClasspathStorage.class)})
public class ModuleRootManagerComponent
extends ModuleRootManagerImpl
implements PersistentStateComponentWithModificationTracker<ModuleRootManagerImpl.ModuleRootManagerState>,
StateStorageChooserEx {
    public ModuleRootManagerComponent(Module module2, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        super(module2, projectRootManager, filePointerManager);
    }

    @NotNull
    public StateStorageChooserEx.Resolution getResolution(@NotNull Storage storage2, @NotNull StateStorageOperation operation) {
        boolean isEffectiveStorage;
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/roots/impl/ModuleRootManagerComponent", "getResolution"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/roots/impl/ModuleRootManagerComponent", "getResolution"));
        }
        boolean isDefault = storage2.storageClass() == StateStorage.class;
        boolean bl = isEffectiveStorage = ClassPathStorageUtil.isDefaultStorage(this.getModule()) == isDefault;
        if (operation == StateStorageOperation.READ) {
            StateStorageChooserEx.Resolution resolution = isEffectiveStorage ? StateStorageChooserEx.Resolution.DO : StateStorageChooserEx.Resolution.SKIP;
            if (resolution == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerComponent", "getResolution"));
            }
            return resolution;
        }
        StateStorageChooserEx.Resolution resolution = isEffectiveStorage ? StateStorageChooserEx.Resolution.DO : (isDefault ? StateStorageChooserEx.Resolution.CLEAR : StateStorageChooserEx.Resolution.SKIP);
        if (resolution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerComponent", "getResolution"));
        }
        return resolution;
    }

    public long getStateModificationCount() {
        Module module2 = this.getModule();
        if (!module2.isLoaded() || !(module2 instanceof ModuleEx)) {
            return this.myModificationCount;
        }
        long[] result2 = new long[]{this.myModificationCount};
        result2[0] = result2[0] + ((ModuleEx)module2).getOptionsModificationCount();
        SmartList handledLibraryTables = new SmartList();
        this.getRootModel().orderEntries().forEachLibrary(arg_0 -> this.lambda$getStateModificationCount$0((List)handledLibraryTables, result2, arg_0));
        return result2[0] + this.myRootModel.getStateModificationCount();
    }

    private /* synthetic */ boolean lambda$getStateModificationCount$0(List handledLibraryTables, long[] result2, Library library) {
        LibraryTable table = library.getTable();
        if (table instanceof LibraryTableBase && !handledLibraryTables.contains(table.getTableLevel())) {
            handledLibraryTables.add(table.getTableLevel());
            long count = ((LibraryTableBase)table).getStateModificationCount();
            if (count > 0L && Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
                LOG.error("modification count changed due to library  " + library.getName() + " change (" + count + "), module " + this.getModule().getName());
            }
            result2[0] = result2[0] + count;
        }
        return true;
    }
}

