/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ComplexElementSubstitutionParameters;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.PackagingElementDraggingObject;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactRootNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingTreeNodeFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPropertiesPanel;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutTreeComponent
implements DnDTarget,
Disposable {
    @NonNls
    private static final String EMPTY_CARD = "<empty>";
    @NonNls
    private static final String PROPERTIES_CARD = "properties";
    private final ArtifactEditorImpl myArtifactsEditor;
    private final LayoutTree myTree;
    private final JPanel myTreePanel;
    private final ComplexElementSubstitutionParameters mySubstitutionParameters;
    private final ArtifactEditorContext myContext;
    private final Artifact myOriginalArtifact;
    private SelectedElementInfo<?> mySelectedElementInfo = new SelectedElementInfo(this, null);
    private JPanel myPropertiesPanelWrapper;
    private JPanel myPropertiesPanel;
    private final LayoutTreeBuilder myBuilder;
    private boolean mySortElements;
    private final LayoutTreeStructure myTreeStructure;

    public LayoutTreeComponent(ArtifactEditorImpl artifactsEditor, ComplexElementSubstitutionParameters substitutionParameters, ArtifactEditorContext context, Artifact originalArtifact, boolean sortElements) {
        this.myArtifactsEditor = artifactsEditor;
        this.mySubstitutionParameters = substitutionParameters;
        this.myContext = context;
        this.myOriginalArtifact = originalArtifact;
        this.mySortElements = sortElements;
        this.myTree = new LayoutTree(this.myArtifactsEditor);
        this.myTreeStructure = new LayoutTreeStructure();
        this.myBuilder = new LayoutTreeBuilder();
        Disposer.register((Disposable)this, (Disposable)this.myTree);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                LayoutTreeComponent.this.updatePropertiesPanel(false);
            }
        });
        this.createPropertiesPanel();
        this.myTreePanel = new JPanel(new BorderLayout());
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree)), "Center");
        this.myTreePanel.add((Component)this.myPropertiesPanelWrapper, "South");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)this.myTree));
        }
    }

    @Nullable
    private WeightBasedComparator getComparator() {
        return this.mySortElements ? new WeightBasedComparator(true) : null;
    }

    public void setSortElements(boolean sortElements) {
        this.mySortElements = sortElements;
        this.myBuilder.setNodeDescriptorComparator((Comparator)this.getComparator());
        this.myArtifactsEditor.getContext().getParent().getDefaultSettings().setSortElements(sortElements);
    }

    @Nullable
    private static PackagingElementNode getNode(Object value) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        return userObject instanceof PackagingElementNode ? (PackagingElementNode)((Object)userObject) : null;
    }

    private void createPropertiesPanel() {
        this.myPropertiesPanel = new JPanel(new BorderLayout());
        JPanel emptyPanel = new JPanel();
        emptyPanel.setMinimumSize((Dimension)JBUI.emptySize());
        emptyPanel.setPreferredSize((Dimension)JBUI.emptySize());
        this.myPropertiesPanelWrapper = new JPanel(new CardLayout());
        this.myPropertiesPanel.setBorder((Border)new CustomLineBorder(1, 0, 0, 0));
        this.myPropertiesPanelWrapper.add(EMPTY_CARD, emptyPanel);
        this.myPropertiesPanelWrapper.add(PROPERTIES_CARD, this.myPropertiesPanel);
    }

    public Artifact getArtifact() {
        return this.myArtifactsEditor.getArtifact();
    }

    public LayoutTree getLayoutTree() {
        return this.myTree;
    }

    public void updatePropertiesPanel(boolean force) {
        PackagingElement<?> selected = this.getSelection().getElementIfSingle();
        if (!force && Comparing.equal(selected, (Object)((SelectedElementInfo)this.mySelectedElementInfo).myElement)) {
            return;
        }
        this.mySelectedElementInfo.save();
        this.mySelectedElementInfo = new SelectedElementInfo(this, selected);
        this.mySelectedElementInfo.showPropertiesPanel();
    }

    public void saveElementProperties() {
        this.mySelectedElementInfo.save();
    }

    public void rebuildTree() {
        this.myBuilder.updateFromRoot(true);
        this.updatePropertiesPanel(true);
        this.myArtifactsEditor.queueValidation();
    }

    public LayoutTreeSelection getSelection() {
        return this.myTree.getSelection();
    }

    public void addNewPackagingElement(@NotNull PackagingElementType<?> type) {
        CompositePackagingElement parent;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "addNewPackagingElement"));
        }
        PackagingElementNode<?> parentNode = this.getParentNode(this.myTree.getSelection());
        Object element = parentNode.getFirstElement();
        if (element instanceof CompositePackagingElement) {
            parent = (CompositePackagingElement)element;
        } else {
            parent = this.getArtifact().getRootElement();
            parentNode = this.myTree.getRootPackagingNode();
        }
        if (!this.checkCanAdd(parent, parentNode)) {
            return;
        }
        List children2 = type.chooseAndCreate(this.myContext, this.getArtifact(), parent);
        PackagingElementNode<?> finalParentNode = parentNode;
        this.editLayout(() -> {
            CompositePackagingElement<?> actualParent = LayoutTreeComponent.getOrCreateModifiableParent(parent, finalParentNode);
            for (PackagingElement child : children2) {
                actualParent.addOrFindChild(child);
            }
        });
        this.updateAndSelect(parentNode, children2);
    }

    private static CompositePackagingElement<?> getOrCreateModifiableParent(CompositePackagingElement<?> parentElement, PackagingElementNode<?> node) {
        CompositePackagingElementNode current;
        ArrayList<String> dirNames = new ArrayList<String>();
        for (current = node; current != null && !(current instanceof ArtifactRootNode); current = current.getParentNode()) {
            Object packagingElement = current.getFirstElement();
            if (!(packagingElement instanceof DirectoryPackagingElement)) {
                return parentElement;
            }
            dirNames.add(((DirectoryPackagingElement)((Object)packagingElement)).getDirectoryName());
        }
        if (current == null) {
            return parentElement;
        }
        Object rootElement = current.getElementIfSingle();
        if (!(rootElement instanceof CompositePackagingElement)) {
            return parentElement;
        }
        Collections.reverse(dirNames);
        String path = StringUtil.join(dirNames, (String)"/");
        return PackagingElementFactory.getInstance().getOrCreateDirectory((CompositePackagingElement)rootElement, path);
    }

    public boolean checkCanModify(@NotNull PackagingElement<?> element, @NotNull PackagingElementNode<?> node) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "checkCanModify"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "checkCanModify"));
        }
        return this.checkCanModify(node.getNodeSource(element));
    }

    public boolean checkCanModifyChildren(@NotNull PackagingElement<?> parentElement, @NotNull PackagingElementNode<?> parentNode, @NotNull Collection<? extends PackagingElementNode<?>> children2) {
        if (parentElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentElement", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "checkCanModifyChildren"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "checkCanModifyChildren"));
        }
        if (children2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "checkCanModifyChildren"));
        }
        ArrayList<PackagingNodeSource> sources = new ArrayList<PackagingNodeSource>(parentNode.getNodeSource(parentElement));
        for (PackagingElementNode<?> child : children2) {
            sources.addAll(child.getNodeSources());
        }
        return this.checkCanModify(sources);
    }

    public boolean checkCanModify(Collection<PackagingNodeSource> nodeSources) {
        if (nodeSources.isEmpty()) {
            return true;
        }
        if (nodeSources.size() > 1) {
            Messages.showErrorDialog((Component)this.myArtifactsEditor.getMainComponent(), (String)"The selected node consist of several elements so it cannot be edited.\nSwitch off 'Show content of elements' checkbox to edit the output layout.");
        } else {
            PackagingNodeSource source = (PackagingNodeSource)ContainerUtil.getFirstItem(nodeSources, null);
            if (source != null) {
                Messages.showErrorDialog((Component)this.myArtifactsEditor.getMainComponent(), (String)("The selected node belongs to '" + source.getPresentableName() + "' element so it cannot be edited.\nSwitch off 'Show content of elements' checkbox to edit the output layout."));
            }
        }
        return false;
    }

    public boolean checkCanAdd(CompositePackagingElement<?> parentElement, PackagingElementNode<?> parentNode) {
        boolean allParentsAreDirectories = true;
        for (CompositePackagingElementNode current = parentNode; current != null && !(current instanceof ArtifactRootNode); current = current.getParentNode()) {
            Object element = current.getFirstElement();
            if (element instanceof DirectoryPackagingElement) continue;
            allParentsAreDirectories = false;
            break;
        }
        return allParentsAreDirectories || this.checkCanModify((PackagingElement<?>)parentElement, parentNode);
    }

    public boolean checkCanRemove(List<? extends PackagingElementNode<?>> nodes) {
        HashSet<PackagingNodeSource> rootSources = new HashSet<PackagingNodeSource>();
        for (PackagingElementNode<?> node : nodes) {
            rootSources.addAll(LayoutTreeComponent.getRootNodeSources(node.getNodeSources()));
        }
        if (!rootSources.isEmpty()) {
            String message;
            if (rootSources.size() == 1) {
                String name = ((PackagingNodeSource)rootSources.iterator().next()).getPresentableName();
                message = "The selected node belongs to '" + name + "' element. Do you want to remove the whole '" + name + "' element from the artifact?";
            } else {
                message = "The selected node belongs to " + nodes.size() + " elements. Do you want to remove all these elements from the artifact?";
            }
            int answer = Messages.showYesNoDialog((Component)this.myArtifactsEditor.getMainComponent(), (String)message, (String)"Remove Elements", null);
            if (answer != 0) {
                return false;
            }
        }
        return true;
    }

    public void updateAndSelect(PackagingElementNode<?> node, List<? extends PackagingElement<?>> toSelect) {
        this.myArtifactsEditor.queueValidation();
        this.myTreeStructure.clearCaches();
        this.myBuilder.queueUpdateFrom(node, true).doWhenDone(() -> {
            List<PackagingElementNode<?>> nodes = this.myTree.findNodes(toSelect);
            this.myBuilder.select(ArrayUtil.toObjectArray(nodes), null);
        });
    }

    public void selectNode(@NotNull String parentPath, @NotNull PackagingElement<?> element) {
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "selectNode"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "selectNode"));
        }
        PackagingElementNode<?> parent = this.myTree.findCompositeNodeByPath(parentPath);
        if (parent == null) {
            return;
        }
        for (SimpleNode node : parent.getChildren()) {
            if (!(node instanceof PackagingElementNode)) continue;
            List elements = ((PackagingElementNode)node).getPackagingElements();
            for (PackagingElement packagingElement : elements) {
                if (!packagingElement.isEqualTo(element)) continue;
                this.myBuilder.select(node);
                return;
            }
        }
    }

    public void selectNode(@NotNull String parentPath, @NotNull String nodeName) {
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "selectNode"));
        }
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "selectNode"));
        }
        PackagingElementNode<?> parent = this.myTree.findCompositeNodeByPath(parentPath);
        if (parent == null) {
            return;
        }
        for (SimpleNode node : parent.getChildren()) {
            if (!(node instanceof PackagingElementNode) || !nodeName.equals(((PackagingElementNode)node).getElementPresentation().getSearchName())) continue;
            this.myBuilder.select(node);
            return;
        }
    }

    public void editLayout(Runnable action) {
        this.myContext.editLayout(this.myOriginalArtifact, action);
    }

    public void removeSelectedElements() {
        LayoutTreeSelection selection = this.myTree.getSelection();
        if (!this.checkCanRemove(selection.getNodes())) {
            return;
        }
        this.editLayout(() -> this.removeNodes(selection.getNodes()));
        this.myArtifactsEditor.rebuildTries();
    }

    public void removeNodes(List<PackagingElementNode<?>> nodes) {
        HashSet parents = new HashSet();
        for (PackagingElementNode<?> node : nodes) {
            List<?> toDelete = node.getPackagingElements();
            for (PackagingElement element : toDelete) {
                Collection<PackagingNodeSource> nodeSources = node.getNodeSource(element);
                if (nodeSources.isEmpty()) {
                    CompositePackagingElement<?> parent = node.getParentElement(element);
                    if (parent == null) continue;
                    parents.add(parent);
                    parent.removeChild(element);
                    continue;
                }
                Collection<PackagingNodeSource> rootSources = LayoutTreeComponent.getRootNodeSources(nodeSources);
                for (PackagingNodeSource source : rootSources) {
                    parents.add(source.getSourceParentElement());
                    source.getSourceParentElement().removeChild(source.getSourceElement());
                }
            }
        }
        List<PackagingElementNode<?>> parentNodes = this.myTree.findNodes(parents);
        for (PackagingElementNode<?> parentNode : parentNodes) {
            this.myTree.addSubtreeToUpdate(parentNode);
        }
    }

    private static Collection<PackagingNodeSource> getRootNodeSources(Collection<PackagingNodeSource> nodeSources) {
        HashSet<PackagingNodeSource> result2 = new HashSet<PackagingNodeSource>();
        LayoutTreeComponent.collectRootNodeSources(nodeSources, result2);
        return result2;
    }

    private static void collectRootNodeSources(Collection<PackagingNodeSource> nodeSources, Set<PackagingNodeSource> result2) {
        for (PackagingNodeSource nodeSource : nodeSources) {
            Collection<PackagingNodeSource> parentSources = nodeSource.getParentSources();
            if (parentSources.isEmpty()) {
                result2.add(nodeSource);
                continue;
            }
            LayoutTreeComponent.collectRootNodeSources(parentSources, result2);
        }
    }

    private PackagingElementNode<?> getParentNode(LayoutTreeSelection selection) {
        PackagingElementNode<?> node = selection.getNodeIfSingle();
        if (node != null) {
            if (node.getFirstElement() instanceof CompositePackagingElement) {
                return node;
            }
            CompositePackagingElementNode parent = node.getParentNode();
            if (parent != null) {
                return parent;
            }
        }
        return this.myTree.getRootPackagingNode();
    }

    public JPanel getTreePanel() {
        return this.myTreePanel;
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.myTree));
        }
    }

    public boolean update(DnDEvent aEvent) {
        DefaultMutableTreeNode parent;
        aEvent.setDropPossible(false);
        aEvent.hideHighlighter();
        Object object = aEvent.getAttachedObject();
        if (object instanceof PackagingElementDraggingObject && (parent = this.findParentCompositeElementNode(aEvent.getRelativePoint().getPoint((Component)((Object)this.myTree)))) != null) {
            Object element;
            PackagingElementDraggingObject draggingObject = (PackagingElementDraggingObject)object;
            PackagingElementNode node = LayoutTreeComponent.getNode(parent);
            if (node != null && draggingObject.canDropInto(node) && (element = node.getFirstElement()) instanceof CompositePackagingElement) {
                draggingObject.setTargetNode(node);
                draggingObject.setTargetElement((CompositePackagingElement)element);
                Rectangle bounds = this.myTree.getPathBounds(TreeUtil.getPathFromRoot((TreeNode)parent));
                aEvent.setHighlighting(new RelativeRectangle((Component)((Object)this.myTree), bounds), 1);
                aEvent.setDropPossible(true);
            }
        }
        return false;
    }

    public void drop(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        if (object instanceof PackagingElementDraggingObject) {
            PackagingElementDraggingObject draggingObject = (PackagingElementDraggingObject)object;
            PackagingElementNode<?> targetNode = draggingObject.getTargetNode();
            CompositePackagingElement<?> targetElement = draggingObject.getTargetElement();
            if (targetElement == null || targetNode == null || !draggingObject.checkCanDrop()) {
                return;
            }
            if (!this.checkCanAdd(targetElement, targetNode)) {
                return;
            }
            ArrayList toSelect = new ArrayList();
            this.editLayout(() -> {
                draggingObject.beforeDrop();
                CompositePackagingElement<?> parent = LayoutTreeComponent.getOrCreateModifiableParent(targetElement, targetNode);
                for (PackagingElement<?> element : draggingObject.createPackagingElements(this.myContext)) {
                    toSelect.add(element);
                    parent.addOrFindChild(element);
                }
            });
            this.updateAndSelect(targetNode, toSelect);
            this.myArtifactsEditor.getSourceItemsTree().rebuildTree();
        }
    }

    @Nullable
    private DefaultMutableTreeNode findParentCompositeElementNode(Point point) {
        for (TreePath path = this.myTree.getPathForLocation(point.x, point.y); path != null; path = path.getParentPath()) {
            PackagingElement<?> element = this.myTree.getElementByPath(path);
            if (!(element instanceof CompositePackagingElement)) continue;
            return (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }

    public void startRenaming(TreePath path) {
        this.myTree.startEditingAtPath(path);
    }

    public boolean isEditing() {
        return this.myTree.isEditing();
    }

    public void setRootElement(CompositePackagingElement<?> rootElement) {
        this.myContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.myOriginalArtifact).setRootElement(rootElement);
        this.myTreeStructure.updateRootElement();
        DefaultMutableTreeNode node = this.myTree.getRootNode();
        node.setUserObject(this.myTreeStructure.getRootElement());
        this.myBuilder.updateNode(node);
        this.rebuildTree();
        this.myArtifactsEditor.getSourceItemsTree().rebuildTree();
    }

    public CompositePackagingElement<?> getRootElement() {
        return this.myContext.getRootElement(this.myOriginalArtifact);
    }

    public void updateTreeNodesPresentation() {
        this.myBuilder.updateFromRoot(false);
    }

    public void updateRootNode() {
        this.myBuilder.updateNode(this.myTree.getRootNode());
    }

    public void initTree() {
        this.myBuilder.initRootNode();
        this.mySelectedElementInfo.showPropertiesPanel();
    }

    public void putIntoDefaultLocations(@NotNull List<? extends PackagingSourceItem> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "putIntoDefaultLocations"));
        }
        ArrayList toSelect = new ArrayList();
        this.editLayout(() -> {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "lambda$putIntoDefaultLocations$4"));
            }
            CompositePackagingElement rootElement = this.getArtifact().getRootElement();
            ArtifactType artifactType = this.getArtifact().getArtifactType();
            for (PackagingSourceItem item : items) {
                String path = artifactType.getDefaultPathFor(item);
                if (path == null) continue;
                CompositePackagingElement parent = path.endsWith("!/") ? PackagingElementFactory.getInstance().getOrCreateArchive(rootElement, StringUtil.trimEnd((String)path, (String)"!/")) : PackagingElementFactory.getInstance().getOrCreateDirectory(rootElement, path);
                List elements = item.createElements(this.myContext);
                toSelect.addAll(parent.addOrFindChildren((Collection)elements));
            }
        });
        this.myArtifactsEditor.getSourceItemsTree().rebuildTree();
        this.updateAndSelect(this.myTree.getRootPackagingNode(), toSelect);
    }

    public void putElements(@NotNull String path, @NotNull List<? extends PackagingElement<?>> elements) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "putElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "putElements"));
        }
        ArrayList toSelect = new ArrayList();
        this.editLayout(() -> {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "lambda$putElements$5"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "lambda$putElements$5"));
            }
            CompositePackagingElement directory = PackagingElementFactory.getInstance().getOrCreateDirectory(this.getArtifact().getRootElement(), path);
            toSelect.addAll(directory.addOrFindChildren((Collection)elements));
        });
        this.myArtifactsEditor.getSourceItemsTree().rebuildTree();
        this.updateAndSelect(this.myTree.getRootPackagingNode(), toSelect);
    }

    public void packInto(@NotNull List<? extends PackagingSourceItem> items, String pathToJar) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "packInto"));
        }
        ArrayList toSelect = new ArrayList();
        CompositePackagingElement rootElement = this.getArtifact().getRootElement();
        this.editLayout(() -> {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent", "lambda$packInto$6"));
            }
            CompositePackagingElement archive = PackagingElementFactory.getInstance().getOrCreateArchive(rootElement, pathToJar);
            for (PackagingSourceItem item : items) {
                List elements = item.createElements(this.myContext);
                archive.addOrFindChildren((Collection)elements);
            }
            toSelect.add(archive);
        });
        this.myArtifactsEditor.getSourceItemsTree().rebuildTree();
        this.updateAndSelect(this.myTree.getRootPackagingNode(), toSelect);
    }

    public boolean isPropertiesModified() {
        PackagingElementPropertiesPanel panel2 = ((SelectedElementInfo)this.mySelectedElementInfo).myCurrentPanel;
        return panel2 != null && panel2.isModified();
    }

    public void resetElementProperties() {
        PackagingElementPropertiesPanel panel2 = ((SelectedElementInfo)this.mySelectedElementInfo).myCurrentPanel;
        if (panel2 != null) {
            panel2.reset();
        }
    }

    public boolean isSortElements() {
        return this.mySortElements;
    }

    private class LayoutTreeBuilder
    extends SimpleTreeBuilder {
        public LayoutTreeBuilder() {
            super((JTree)((Object)LayoutTreeComponent.this.myTree), LayoutTreeComponent.this.myTree.getBuilderModel(), (AbstractTreeStructure)LayoutTreeComponent.this.myTreeStructure, (Comparator)LayoutTreeComponent.this.getComparator());
        }

        public void updateNode(DefaultMutableTreeNode node) {
            super.updateNode(node);
        }
    }

    private class LayoutTreeStructure
    extends SimpleTreeStructure {
        private ArtifactRootNode myRootNode;

        private LayoutTreeStructure() {
        }

        public Object getRootElement() {
            if (this.myRootNode == null) {
                this.myRootNode = PackagingTreeNodeFactory.createRootNode(LayoutTreeComponent.this.myArtifactsEditor, LayoutTreeComponent.this.myContext, LayoutTreeComponent.this.mySubstitutionParameters, LayoutTreeComponent.this.getArtifact().getArtifactType());
            }
            return this.myRootNode;
        }

        public void updateRootElement() {
            this.myRootNode = null;
        }
    }

    private static class SelectedElementInfo<E extends PackagingElement<?>> {
        private final E myElement;
        private PackagingElementPropertiesPanel myCurrentPanel;
        final /* synthetic */ LayoutTreeComponent this$0;

        private SelectedElementInfo(E element) {
            this.this$0 = var1_1;
            this.myElement = element;
            if (this.myElement != null) {
                this.myCurrentPanel = element.getType().createElementPropertiesPanel(this.myElement, ((LayoutTreeComponent)var1_1).myContext);
                ((LayoutTreeComponent)var1_1).myPropertiesPanel.removeAll();
                if (this.myCurrentPanel != null) {
                    ((LayoutTreeComponent)var1_1).myPropertiesPanel.add("Center", ScrollPaneFactory.createScrollPane((Component)this.myCurrentPanel.createComponent(), (boolean)true));
                    this.myCurrentPanel.reset();
                    ((LayoutTreeComponent)var1_1).myPropertiesPanel.revalidate();
                }
            }
        }

        public void save() {
            if (this.myCurrentPanel != null && this.myCurrentPanel.isModified()) {
                this.this$0.editLayout(() -> this.myCurrentPanel.apply());
            }
        }

        public void showPropertiesPanel() {
            CardLayout cardLayout = (CardLayout)this.this$0.myPropertiesPanelWrapper.getLayout();
            if (this.myCurrentPanel != null) {
                cardLayout.show(this.this$0.myPropertiesPanelWrapper, LayoutTreeComponent.PROPERTIES_CARD);
            } else {
                cardLayout.show(this.this$0.myPropertiesPanelWrapper, LayoutTreeComponent.EMPTY_CARD);
            }
            this.this$0.myPropertiesPanelWrapper.repaint();
        }
    }
}

