/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.nodes;

import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ComplexElementSubstitutionParameters;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactRootNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ComplexPackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingTreeNodeFactory {
    private PackagingTreeNodeFactory() {
    }

    public static void addNodes(@NotNull List<? extends PackagingElement<?>> elements, @NotNull CompositePackagingElementNode parentNode, @NotNull CompositePackagingElement parentElement, @NotNull ArtifactEditorContext context, @NotNull ComplexElementSubstitutionParameters substitutionParameters, @NotNull Collection<PackagingNodeSource> nodeSources, @NotNull List<PackagingElementNode<?>> nodes, ArtifactType artifactType, Set<PackagingElement<?>> processed2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingTreeNodeFactory", "addNodes"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingTreeNodeFactory", "addNodes"));
        }
        if (parentElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentElement", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingTreeNodeFactory", "addNodes"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingTreeNodeFactory", "addNodes"));
        }
        if (substitutionParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionParameters", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingTreeNodeFactory", "addNodes"));
        }
        if (nodeSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeSources", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingTreeNodeFactory", "addNodes"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingTreeNodeFactory", "addNodes"));
        }
        for (PackagingElement<?> element : elements) {
            PackagingElementNode<?> prev = PackagingTreeNodeFactory.findEqual(nodes, element);
            if (prev != null) {
                prev.addElement(element, parentElement, nodeSources);
                continue;
            }
            if (element instanceof ArtifactRootElement) {
                throw new AssertionError((Object)"artifact root not expected here");
            }
            if (element instanceof CompositePackagingElement) {
                nodes.add(new CompositePackagingElementNode((CompositePackagingElement)element, context, parentNode, parentElement, substitutionParameters, nodeSources, artifactType));
                continue;
            }
            if (element instanceof ComplexPackagingElement) {
                List substitution;
                ComplexPackagingElement complexElement = (ComplexPackagingElement)element;
                if (processed2.add(element) && substitutionParameters.shouldSubstitute(complexElement) && (substitution = complexElement.getSubstitution((PackagingElementResolvingContext)context, artifactType)) != null) {
                    PackagingNodeSource source = new PackagingNodeSource(complexElement, parentNode, parentElement, nodeSources);
                    PackagingTreeNodeFactory.addNodes(substitution, parentNode, parentElement, context, substitutionParameters, Collections.singletonList(source), nodes, artifactType, processed2);
                    continue;
                }
                nodes.add(new ComplexPackagingElementNode(complexElement, context, parentNode, parentElement, substitutionParameters, nodeSources));
                continue;
            }
            nodes.add(new PackagingElementNode(element, context, parentNode, parentElement, nodeSources));
        }
    }

    @Nullable
    private static PackagingElementNode<?> findEqual(List<PackagingElementNode<?>> children2, PackagingElement<?> element) {
        for (PackagingElementNode<?> node : children2) {
            if (!node.getFirstElement().isEqualTo(element)) continue;
            return node;
        }
        return null;
    }

    @NotNull
    public static ArtifactRootNode createRootNode(ArtifactEditorImpl artifactsEditor, ArtifactEditorContext context, ComplexElementSubstitutionParameters substitutionParameters, ArtifactType artifactType) {
        ArtifactRootNode artifactRootNode = new ArtifactRootNode(artifactsEditor, context, substitutionParameters, artifactType);
        if (artifactRootNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingTreeNodeFactory", "createRootNode"));
        }
        return artifactRootNode;
    }
}

