/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.DelegatedSourceItemPresentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleSourceItemGroup;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.packaging.ui.TreeNodePresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedPackagingSourceItemsProvider<F extends Facet, E extends PackagingElement<?>>
extends PackagingSourceItemsProvider {
    private final FacetTypeId<F> myFacetTypeId;
    private final PackagingElementType<E> myElementType;

    protected FacetBasedPackagingSourceItemsProvider(FacetTypeId<F> facetTypeId, PackagingElementType<E> elementType) {
        this.myFacetTypeId = facetTypeId;
        this.myElementType = elementType;
    }

    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, @Nullable PackagingSourceItem parent) {
        if (editorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorContext", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider", "getSourceItems"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider", "getSourceItems"));
        }
        if (parent instanceof ModuleSourceItemGroup) {
            Module module2 = ((ModuleSourceItemGroup)parent).getModule();
            HashSet facets = new HashSet(editorContext.getFacetsProvider().getFacetsByType(module2, this.myFacetTypeId));
            ArtifactUtil.processPackagingElements(artifact, this.myElementType, e -> {
                F facet = this.getFacet(e);
                if (facet != null) {
                    facets.remove(facet);
                }
                return true;
            }, (PackagingElementResolvingContext)editorContext, true);
            if (!facets.isEmpty()) {
                List<FacetBasedSourceItem<Facet>> list = Collections.singletonList(new FacetBasedSourceItem<Facet>(this, (Facet)facets.iterator().next()));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider", "getSourceItems"));
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider", "getSourceItems"));
        }
        return list;
    }

    protected PackagingElementOutputKind getKindOfProducedElements() {
        return PackagingElementOutputKind.OTHER;
    }

    @Nullable
    protected abstract F getFacet(E var1);

    protected abstract TreeNodePresentation createPresentation(F var1);

    protected abstract PackagingElement<?> createElement(ArtifactEditorContext var1, F var2);

    protected static class FacetBasedSourceItem<F extends Facet>
    extends PackagingSourceItem {
        private final FacetBasedPackagingSourceItemsProvider<F, ?> myProvider;
        private final F myFacet;

        public FacetBasedSourceItem(FacetBasedPackagingSourceItemsProvider<F, ?> provider, F facet) {
            this.myProvider = provider;
            this.myFacet = facet;
        }

        public boolean equals(Object obj) {
            return obj instanceof FacetBasedSourceItem && this.myFacet.equals(((FacetBasedSourceItem)((Object)obj)).myFacet) && ((Object)this.myProvider).equals(((FacetBasedSourceItem)((Object)obj)).myProvider);
        }

        public int hashCode() {
            return this.myFacet.hashCode() + 31 * ((Object)this.myProvider).hashCode();
        }

        public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem", "createPresentation"));
            }
            return new DelegatedSourceItemPresentation(this.myProvider.createPresentation(this.myFacet));
        }

        @NotNull
        public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem", "createElements"));
            }
            List<PackagingElement<?>> list = Collections.singletonList(this.myProvider.createElement(context, this.myFacet));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem", "createElements"));
            }
            return list;
        }

        @NotNull
        public PackagingElementOutputKind getKindOfProducedElements() {
            PackagingElementOutputKind packagingElementOutputKind = this.myProvider.getKindOfProducedElements();
            if (packagingElementOutputKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem", "getKindOfProducedElements"));
            }
            return packagingElementOutputKind;
        }
    }
}

