/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelActionBase;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeLibraryLevelInClasspathAction
extends ChangeLibraryLevelActionBase {
    private final ClasspathPanel myPanel;

    public ChangeLibraryLevelInClasspathAction(@NotNull ClasspathPanel panel2, @NotNull String targetTableName, @NotNull String targetTableLevel) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelInClasspathAction", "<init>"));
        }
        if (targetTableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetTableName", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelInClasspathAction", "<init>"));
        }
        if (targetTableLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetTableLevel", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelInClasspathAction", "<init>"));
        }
        super(panel2.getProject(), targetTableName, targetTableLevel, targetTableLevel.equals("module"));
        this.myPanel = panel2;
    }

    public void actionPerformed(AnActionEvent event) {
        OrderEntry entry = this.myPanel.getSelectedEntry();
        if (!(entry instanceof LibraryOrderEntry)) {
            return;
        }
        LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entry;
        LibraryEx library = (LibraryEx)libraryEntry.getLibrary();
        if (library == null) {
            return;
        }
        Library copied = this.doCopy(library);
        if (copied == null) {
            return;
        }
        if (!this.isConvertingToModuleLibrary()) {
            OrderEntryUtil.replaceLibrary(this.myPanel.getRootModel(), (Library)library, copied);
        } else {
            OrderEntryUtil.replaceLibraryEntryByAdded(this.myPanel.getRootModel(), libraryEntry);
        }
    }

    @Override
    protected boolean isEnabled() {
        LibraryOrderEntry libraryOrderEntry;
        OrderEntry entry = this.myPanel.getSelectedEntry();
        boolean enabled = false;
        if (entry instanceof LibraryOrderEntry && (libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary() != null) {
            boolean isToModuleLibrary;
            boolean isFromModuleLibrary = libraryOrderEntry.isModuleLevel();
            enabled = isFromModuleLibrary != (isToModuleLibrary = this.isConvertingToModuleLibrary());
        }
        return enabled;
    }

    @Override
    protected LibraryTableModifiableModelProvider getModifiableTableModelProvider() {
        return this.myPanel.getModifiableModelProvider(this.myTargetTableLevel);
    }

    @Override
    protected JComponent getParentComponent() {
        return this.myPanel.getComponent();
    }

    @Override
    @Nullable
    protected VirtualFile getBaseDir() {
        if (this.isConvertingToModuleLibrary()) {
            VirtualFile[] roots = this.myPanel.getRootModel().getContentRoots();
            if (roots.length > 0) {
                return roots[0];
            }
            VirtualFile moduleFile = this.myPanel.getRootModel().getModule().getModuleFile();
            if (moduleFile != null) {
                return moduleFile.getParent();
            }
        }
        return super.getBaseDir();
    }
}

