/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;

class ProjectStructureElementRenderer
extends ColoredTreeCellRenderer {
    private StructureConfigurableContext myContext;

    public ProjectStructureElementRenderer(StructureConfigurableContext context) {
        this.myContext = context;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof MasterDetailsComponent.MyNode) {
            ProjectStructureElement projectStructureElement;
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)value;
            NamedConfigurable namedConfigurable = node.getConfigurable();
            if (namedConfigurable == null) {
                return;
            }
            String displayName = node.getDisplayName();
            Icon icon = namedConfigurable.getIcon(expanded);
            this.setIcon(icon);
            this.setToolTipText(null);
            this.setFont(UIUtil.getTreeFont());
            SimpleTextAttributes textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (node.isDisplayInBold()) {
                textAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            } else if (namedConfigurable instanceof ProjectStructureElementConfigurable && (projectStructureElement = ((ProjectStructureElementConfigurable)namedConfigurable).getProjectStructureElement()) != null) {
                ProjectStructureDaemonAnalyzer daemonAnalyzer = this.myContext.getDaemonAnalyzer();
                ProjectStructureProblemsHolderImpl problemsHolder = daemonAnalyzer.getProblemsHolder(projectStructureElement);
                if (problemsHolder != null && problemsHolder.containsProblems()) {
                    int style;
                    boolean isUnused = problemsHolder.containsProblems(ProjectStructureProblemType.Severity.UNUSED);
                    boolean haveWarnings = problemsHolder.containsProblems(ProjectStructureProblemType.Severity.WARNING);
                    boolean haveErrors = problemsHolder.containsProblems(ProjectStructureProblemType.Severity.ERROR);
                    Color foreground = isUnused ? UIUtil.getInactiveTextColor() : null;
                    int n = style = haveWarnings || haveErrors ? 8 : -1;
                    JBColor waveColor = haveErrors ? JBColor.RED : (haveWarnings ? JBColor.GRAY : null);
                    textAttributes = textAttributes.derive(style, foreground, null, (Color)waveColor);
                    this.setToolTipText(problemsHolder.composeTooltipMessage());
                }
                this.append(displayName, textAttributes);
                String description = projectStructureElement.getDescription();
                if (description != null) {
                    this.append(" (" + description + ")", SimpleTextAttributes.GRAY_ATTRIBUTES, false);
                }
                return;
            }
            this.append(displayName, textAttributes);
        }
    }
}

