/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CheckRemoteStatusCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/openapi/vcs/CheckRemoteStatusCheckinHandlerFactory", "createHandler"));
        }
        if (commitContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/openapi/vcs/CheckRemoteStatusCheckinHandlerFactory", "createHandler"));
        }
        MyCheckinHandler myCheckinHandler = new MyCheckinHandler(panel2);
        if (myCheckinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/CheckRemoteStatusCheckinHandlerFactory", "createHandler"));
        }
        return myCheckinHandler;
    }

    private static class MyCheckinHandler
    extends CheckinHandler {
        private final CheckinProjectPanel myPanel;
        private final VcsConfiguration myVcsConfiguration;

        private MyCheckinHandler(CheckinProjectPanel panel2) {
            this.myPanel = panel2;
            this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myPanel.getProject());
        }

        public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
            final JCheckBox checkUpToDate = new JCheckBox(VcsBundle.message((String)"checkbox.checkin.options.check.files.up.to.date", (Object[])new Object[0]));
            return new RefreshableOnComponent(){

                public JComponent getComponent() {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.add((Component)checkUpToDate, "West");
                    return panel2;
                }

                public void refresh() {
                }

                public void saveState() {
                    ((MyCheckinHandler)this).myVcsConfiguration.CHECK_FILES_UP_TO_DATE_BEFORE_COMMIT = checkUpToDate.isSelected();
                }

                public void restoreState() {
                    checkUpToDate.setSelected(((MyCheckinHandler)this).myVcsConfiguration.CHECK_FILES_UP_TO_DATE_BEFORE_COMMIT);
                }
            };
        }

        public void includedChangesChanged() {
        }

        private void doCheck() {
            this.myPanel.getFiles();
        }
    }
}

