/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotateLocalFileAction {
    private static final Logger LOG = Logger.getInstance(AnnotateLocalFileAction.class);

    private static boolean isEnabled(AnActionEvent e) {
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createContextOn(e);
        Project project2 = context.getProject();
        if (project2 == null || project2.isDisposed()) {
            return false;
        }
        VirtualFile file2 = context.getSelectedFile();
        if (file2 == null || file2.isDirectory() || file2.getFileType().isBinary()) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project2).getVcsFor(file2);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (annotationProvider == null) {
            return false;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project2).getStatus(file2);
        return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED && fileStatus != FileStatus.IGNORED;
    }

    private static boolean isSuspended(AnActionEvent e) {
        VirtualFile file2 = (VirtualFile)ObjectUtils.assertNotNull((Object)VcsContextFactory.SERVICE.getInstance().createContextOn(e).getSelectedFile());
        return VcsAnnotateUtil.getBackgroundableLock((Project)e.getRequiredData(CommonDataKeys.PROJECT), file2).isLocked();
    }

    private static boolean isAnnotated(AnActionEvent e) {
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createContextOn(e);
        Editor editor = context.getEditor();
        if (editor != null) {
            return editor.getGutter().isAnnotationsShown();
        }
        return ContainerUtil.exists(AnnotateLocalFileAction.getEditors(context), (Condition)new Condition<Editor>(){

            public boolean value(Editor editor) {
                return editor.getGutter().isAnnotationsShown();
            }
        });
    }

    private static void perform(AnActionEvent e, boolean selected) {
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createContextOn(e);
        if (!selected) {
            for (Editor editor : AnnotateLocalFileAction.getEditors(context)) {
                editor.getGutter().closeAllAnnotations();
            }
        } else {
            Project project2 = (Project)ObjectUtils.assertNotNull((Object)context.getProject());
            VirtualFile selectedFile = (VirtualFile)ObjectUtils.assertNotNull((Object)context.getSelectedFile());
            Editor editor = context.getEditor();
            if (editor == null) {
                FileEditor[] fileEditors;
                for (FileEditor fileEditor : fileEditors = FileEditorManager.getInstance((Project)project2).openFile(selectedFile, false)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    editor = ((TextEditor)fileEditor).getEditor();
                }
            }
            LOG.assertTrue(editor != null);
            AnnotateLocalFileAction.doAnnotate(editor, project2);
        }
    }

    private static void doAnnotate(final @NotNull Editor editor, final @NotNull Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction", "doAnnotate"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction", "doAnnotate"));
        }
        final VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file2 == null) {
            return;
        }
        final AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project2).getVcsFor(file2);
        if (vcs == null) {
            return;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        assert (annotationProvider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        VcsAnnotateUtil.getBackgroundableLock(project2, file2).lock();
        Task.Backgroundable annotateTask = new Task.Backgroundable(project2, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction$2", "run"));
                }
                try {
                    fileAnnotationRef.set((Object)annotationProvider.annotate(file2));
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    exceptionRef.set((Object)new VcsException(t));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                VcsAnnotateUtil.getBackgroundableLock(project2, file2).unlock();
                if (!exceptionRef.isNull()) {
                    LOG.warn((Throwable)exceptionRef.get());
                    AbstractVcsHelper.getInstance((Project)project2).showErrors(Collections.singletonList(exceptionRef.get()), VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                }
                if (!fileAnnotationRef.isNull()) {
                    AnnotateToggleAction.doAnnotate(editor, project2, file2, (FileAnnotation)fileAnnotationRef.get(), vcs);
                }
            }
        };
        ProgressManager.getInstance().run((Task)annotateTask);
    }

    @NotNull
    private static List<Editor> getEditors(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction", "getEditors"));
        }
        Project project2 = (Project)ObjectUtils.assertNotNull((Object)context.getProject());
        VirtualFile file2 = (VirtualFile)ObjectUtils.assertNotNull((Object)context.getSelectedFile());
        List<Editor> list = VcsAnnotateUtil.getEditors(project2, file2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction", "getEditors"));
        }
        return list;
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateLocalFileAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(AnActionEvent e) {
            return AnnotateLocalFileAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateLocalFileAction.isAnnotated(e);
        }

        @Override
        public void perform(AnActionEvent e, boolean selected) {
            AnnotateLocalFileAction.perform(e, selected);
        }
    }
}

