/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends AbstractVcsAction {
    @Override
    protected void update(@NotNull VcsContext context, @NotNull Presentation presentation) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "update"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "update"));
        }
        Project project2 = context.getProject();
        presentation.setEnabled(this.isEnabled(context));
        presentation.setVisible(project2 != null && ProjectLevelVcsManager.getInstance((Project)project2).hasActiveVcss());
    }

    protected boolean isEnabled(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "isEnabled"));
        }
        boolean result2 = false;
        Project project2 = context.getProject();
        if (project2 != null) {
            Pair<FilePath, VirtualFile> pair = TabbedShowHistoryAction.getPathAndParentFile(context);
            if (pair.first != null && pair.second != null) {
                result2 = TabbedShowHistoryAction.isEnabled(project2, (FilePath)pair.first, (VirtualFile)pair.second);
            }
        }
        return result2;
    }

    private static boolean isEnabled(@NotNull Project project2, @NotNull FilePath path, @NotNull VirtualFile fileOrParent) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "isEnabled"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "isEnabled"));
        }
        if (fileOrParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrParent", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "isEnabled"));
        }
        boolean fileInVcs = AbstractVcs.fileInVcsByFileStatus((Project)project2, (VirtualFile)fileOrParent);
        if (!fileInVcs) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project2);
        if (vcs == null) {
            return false;
        }
        return TabbedShowHistoryAction.canShowNewFileHistory(project2, path) || TabbedShowHistoryAction.canShowOldFileHistory(vcs, path, fileOrParent);
    }

    private static boolean canShowOldFileHistory(@NotNull AbstractVcs vcs, @NotNull FilePath path, @NotNull VirtualFile fileOrParent) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "canShowOldFileHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "canShowOldFileHistory"));
        }
        if (fileOrParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrParent", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "canShowOldFileHistory"));
        }
        VcsHistoryProvider provider = vcs.getVcsHistoryProvider();
        return provider != null && (provider.supportsHistoryForDirectories() || !path.isDirectory()) && provider.canShowHistoryFor(fileOrParent);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project2, @NotNull FilePath path) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "canShowNewFileHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "canShowNewFileHistory"));
        }
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        return historyProvider != null && historyProvider.canShowFileHistory(project2, path);
    }

    @NotNull
    private static Pair<FilePath, VirtualFile> getPathAndParentFile(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getPathAndParentFile"));
        }
        if (context.getSelectedFilesStream().findAny().isPresent()) {
            VirtualFile file2 = (VirtualFile)UtilKt.getIfSingle(context.getSelectedFilesStream());
            Pair pair = file2 != null ? Pair.create((Object)VcsUtil.getFilePath((VirtualFile)file2), (Object)file2) : Pair.empty();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getPathAndParentFile"));
            }
            return pair;
        }
        File[] ioFiles = context.getSelectedIOFiles();
        if (ioFiles != null && ioFiles.length > 0) {
            for (File ioFile : ioFiles) {
                VirtualFile parent = TabbedShowHistoryAction.getParentVirtualFile(ioFile);
                if (parent == null) continue;
                Pair pair = Pair.create((Object)VcsUtil.getFilePath((VirtualFile)parent, (String)ioFile.getName()), (Object)parent);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getPathAndParentFile"));
                }
                return pair;
            }
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getPathAndParentFile"));
        }
        return pair;
    }

    @Nullable
    private static VirtualFile getParentVirtualFile(@NotNull File ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getParentVirtualFile"));
        }
        File parentIoFile = ioFile.getParentFile();
        return parentIoFile != null ? LocalFileSystem.getInstance().findFileByIoFile(parentIoFile) : null;
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "actionPerformed"));
        }
        Project project2 = (Project)ObjectUtils.assertNotNull((Object)context.getProject());
        Pair<FilePath, VirtualFile> pair = TabbedShowHistoryAction.getPathAndParentFile(context);
        FilePath path = (FilePath)ObjectUtils.assertNotNull((Object)pair.first);
        VirtualFile fileOrParent = (VirtualFile)ObjectUtils.assertNotNull((Object)pair.second);
        AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project2));
        if (TabbedShowHistoryAction.canShowNewFileHistory(project2, path)) {
            TabbedShowHistoryAction.showNewFileHistory(project2, path);
        } else {
            TabbedShowHistoryAction.showOldFileHistory(project2, vcs, path);
        }
    }

    private static void showNewFileHistory(@NotNull Project project2, @NotNull FilePath path) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "showNewFileHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "showNewFileHistory"));
        }
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(project2, path, null);
    }

    private static void showOldFileHistory(@NotNull Project project2, @NotNull AbstractVcs vcs, @NotNull FilePath path) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "showOldFileHistory"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "showOldFileHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "showOldFileHistory"));
        }
        VcsHistoryProvider provider = (VcsHistoryProvider)ObjectUtils.assertNotNull((Object)vcs.getVcsHistoryProvider());
        AbstractVcsHelper.getInstance((Project)project2).showFileHistory(provider, vcs.getAnnotationProvider(), path, null, vcs);
    }
}

