/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsAnnotateUtil {
    @NotNull
    public static List<Editor> getEditors(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/VcsAnnotateUtil", "getEditors"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/actions/VcsAnnotateUtil", "getEditors"));
        }
        Object[] editors = FileEditorManager.getInstance((Project)project2).getEditors(file2);
        List list = ContainerUtil.mapNotNull((Object[])editors, (Function)new Function<FileEditor, Editor>(){

            public Editor fun(FileEditor fileEditor) {
                return fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsAnnotateUtil", "getEditors"));
        }
        return list;
    }

    @NotNull
    public static BackgroundableActionLock getBackgroundableLock(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/VcsAnnotateUtil", "getBackgroundableLock"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/actions/VcsAnnotateUtil", "getBackgroundableLock"));
        }
        BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock(project2, new Object[]{VcsBackgroundableActions.ANNOTATE, file2.getPath()});
        if (backgroundableActionLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsAnnotateUtil", "getBackgroundableLock"));
        }
        return backgroundableActionLock;
    }
}

