/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.SpecificFilesViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class IgnoredViewDialog
extends SpecificFilesViewDialog {
    public IgnoredViewDialog(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/IgnoredViewDialog", "<init>"));
        }
        super(project2, "Ignored Files", ChangesListView.IGNORED_FILES_DATA_KEY, ChangeListManagerImpl.getInstanceImpl(project2).getIgnoredFiles());
    }

    @Override
    protected void addCustomActions(@NotNull DefaultActionGroup group, @NotNull ActionToolbar actionToolbar) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/vcs/changes/IgnoredViewDialog", "addCustomActions"));
        }
        if (actionToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionToolbar", "com/intellij/openapi/vcs/changes/IgnoredViewDialog", "addCustomActions"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        final AnAction deleteAction = EmptyAction.registerWithShortcutSet((String)"ChangesView.DeleteUnversioned.From.Dialog", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)((Object)this.myView));
        actionManager.addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                if (action.equals(deleteAction)) {
                    IgnoredViewDialog.this.refreshView();
                    SpecificFilesViewDialog.refreshChanges(IgnoredViewDialog.this.myProject, SpecificFilesViewDialog.getBrowserBase(IgnoredViewDialog.this.myView));
                }
            }
        }, this.myDisposable);
        group.add(deleteAction);
        this.myView.setMenuActions((ActionGroup)new DefaultActionGroup(new AnAction[]{deleteAction}));
    }

    @Override
    @NotNull
    protected List<VirtualFile> getFiles() {
        List<VirtualFile> list = ChangeListManagerImpl.getInstanceImpl(this.myProject).getIgnoredFiles();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/IgnoredViewDialog", "getFiles"));
        }
        return list;
    }
}

