/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangeListImpl
extends LocalChangeList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeList");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<Change> myChanges;
    private Set<Change> myReadChangesCache;
    @NotNull
    private String myId;
    @NotNull
    private String myName;
    @NotNull
    private String myComment;
    @Nullable
    private Object myData;
    private boolean myIsDefault;
    private boolean myIsReadOnly;
    private OpenTHashSet<Change> myChangesBeforeUpdate;

    @NotNull
    public static LocalChangeListImpl createEmptyChangeListImpl(@NotNull Project project2, @NotNull String name) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "createEmptyChangeListImpl"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "createEmptyChangeListImpl"));
        }
        LocalChangeListImpl localChangeListImpl = new LocalChangeListImpl(project2, name);
        if (localChangeListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "createEmptyChangeListImpl"));
        }
        return localChangeListImpl;
    }

    private LocalChangeListImpl(@NotNull Project project2, @NotNull String name) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "<init>"));
        }
        this.myReadChangesCache = null;
        this.myComment = "";
        this.myIsDefault = false;
        this.myIsReadOnly = false;
        this.myProject = project2;
        this.myId = UUID.randomUUID().toString();
        this.myName = LocalChangeListImpl.validateName(name);
        this.myChanges = ContainerUtil.newHashSet();
    }

    private LocalChangeListImpl(@NotNull LocalChangeListImpl origin) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "<init>"));
        }
        this.myReadChangesCache = null;
        this.myComment = "";
        this.myIsDefault = false;
        this.myIsReadOnly = false;
        this.myId = origin.getId();
        this.myProject = origin.myProject;
        this.myName = origin.myName;
        this.myComment = origin.myComment;
        this.myIsDefault = origin.myIsDefault;
        this.myIsReadOnly = origin.myIsReadOnly;
        this.myData = origin.myData;
        this.myChanges = ContainerUtil.newHashSet(origin.myChanges);
        if (this.myChangesBeforeUpdate != null) {
            this.myChangesBeforeUpdate = new OpenTHashSet(origin.myChangesBeforeUpdate);
        }
        if (this.myReadChangesCache != null) {
            this.myReadChangesCache = ContainerUtil.newHashSet(origin.myReadChangesCache);
        }
    }

    @NotNull
    public Set<Change> getChanges() {
        this.createReadChangesCache();
        Set<Change> set2 = this.myReadChangesCache;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getChanges"));
        }
        return set2;
    }

    private void createReadChangesCache() {
        if (this.myReadChangesCache == null) {
            this.myReadChangesCache = Collections.unmodifiableSet(ContainerUtil.newHashSet(this.myChanges));
        }
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getId"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "setName"));
        }
        this.myName = LocalChangeListImpl.validateName(name);
    }

    @NotNull
    private static String validateName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "validateName"));
        }
        if (StringUtil.isEmptyOrSpaces((String)name) && Registry.is((String)"vcs.log.empty.change.list.creation")) {
            LOG.info("Creating a changelist with empty name");
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "validateName"));
        }
        return string;
    }

    @NotNull
    public String getComment() {
        String string = this.myComment;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getComment"));
        }
        return string;
    }

    public void setComment(@Nullable String comment) {
        this.myComment = comment != null ? comment : "";
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    void setDefault(boolean isDefault) {
        this.myIsDefault = isDefault;
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.myIsReadOnly = isReadOnly;
    }

    void setData(@Nullable Object data) {
        this.myData = data;
    }

    @Nullable
    public Object getData() {
        return this.myData;
    }

    void addChange(Change change) {
        this.myReadChangesCache = null;
        this.myChanges.add(change);
        LOG.debug("List: " + this.myName + ". addChange: " + change);
    }

    @Nullable
    Change removeChange(@Nullable Change change) {
        if (this.myChanges.remove(change)) {
            LOG.debug("List: " + this.myName + ". removeChange: " + change);
            this.myReadChangesCache = null;
            return change;
        }
        return null;
    }

    Collection<Change> startProcessingChanges(Project project2, @Nullable VcsDirtyScope scope) {
        this.createReadChangesCache();
        ArrayList<Change> result2 = new ArrayList<Change>();
        this.myChangesBeforeUpdate = new OpenTHashSet(this.myChanges);
        for (Change oldBoy : this.myChangesBeforeUpdate) {
            ContentRevision before = oldBoy.getBeforeRevision();
            ContentRevision after2 = oldBoy.getAfterRevision();
            if (!(scope == null || before != null && scope.belongsTo(before.getFile()) || after2 != null && scope.belongsTo(after2.getFile())) && !LocalChangeListImpl.isIgnoredChange(oldBoy, project2)) continue;
            result2.add(oldBoy);
            this.myChanges.remove(oldBoy);
            LOG.debug("List: " + this.myName + ". removed change during processing: " + oldBoy);
            this.myReadChangesCache = null;
        }
        return result2;
    }

    private static boolean isIgnoredChange(@NotNull Change change, @NotNull Project project2) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "isIgnoredChange"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "isIgnoredChange"));
        }
        boolean beforeRevIgnored = change.getBeforeRevision() == null || LocalChangeListImpl.isIgnoredRevision(change.getBeforeRevision(), project2);
        boolean afterRevIgnored = change.getAfterRevision() == null || LocalChangeListImpl.isIgnoredRevision(change.getAfterRevision(), project2);
        return beforeRevIgnored && afterRevIgnored;
    }

    private static boolean isIgnoredRevision(@NotNull ContentRevision revision, @NotNull Project project2) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "isIgnoredRevision"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "isIgnoredRevision"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "lambda$isIgnoredRevision$0"));
            }
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "lambda$isIgnoredRevision$0"));
            }
            if (project2.isDisposed()) {
                return false;
            }
            VirtualFile vFile = revision.getFile().getVirtualFile();
            return vFile != null && ProjectLevelVcsManager.getInstance((Project)project2).isIgnored(vFile);
        });
    }

    boolean processChange(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "processChange"));
        }
        LOG.debug("[process change] for '" + this.myName + "' isDefault: " + this.myIsDefault + " change: " + ChangesUtil.getFilePath((Change)change).getPath());
        if (this.myIsDefault) {
            LOG.debug("[process change] adding because default");
            this.addChange(change);
            return true;
        }
        if (this.myChangesBeforeUpdate.contains((Object)change)) {
            LOG.debug("[process change] adding because equal to old: " + ChangesUtil.getFilePath((Change)change).getPath());
            this.addChange(change);
            return true;
        }
        LOG.debug("[process change] not found");
        return false;
    }

    boolean doneProcessingChanges(List<Change> removedChanges, List<Change> addedChanges) {
        boolean changesDetected = this.myChanges.size() != this.myChangesBeforeUpdate.size();
        for (Change newChange : this.myChanges) {
            Change oldChange = this.findOldChange(newChange);
            if (oldChange != null) continue;
            addedChanges.add(newChange);
        }
        changesDetected |= !addedChanges.isEmpty();
        ArrayList<Change> removed = new ArrayList<Change>((Collection<Change>)this.myChangesBeforeUpdate);
        removed.removeAll(this.myChanges);
        removedChanges.addAll(removed);
        changesDetected = changesDetected || !removedChanges.isEmpty();
        this.myReadChangesCache = null;
        return changesDetected;
    }

    @Nullable
    private Change findOldChange(Change newChange) {
        Change oldChange = (Change)this.myChangesBeforeUpdate.get((Object)newChange);
        if (oldChange != null && LocalChangeListImpl.sameBeforeRevision(oldChange, newChange) && newChange.getFileStatus().equals(oldChange.getFileStatus())) {
            return oldChange;
        }
        return null;
    }

    private static boolean sameBeforeRevision(Change change1, Change change2) {
        ContentRevision b1 = change1.getBeforeRevision();
        ContentRevision b2 = change2.getBeforeRevision();
        if (b1 != null && b2 != null) {
            VcsRevisionNumber rn1 = b1.getRevisionNumber();
            VcsRevisionNumber rn2 = b2.getRevisionNumber();
            boolean isBinary1 = b1 instanceof BinaryContentRevision;
            boolean isBinary2 = b2 instanceof BinaryContentRevision;
            return rn1 != VcsRevisionNumber.NULL && rn2 != VcsRevisionNumber.NULL && rn1.compareTo((Object)rn2) == 0 && isBinary1 == isBinary2;
        }
        return b1 == null && b2 == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LocalChangeListImpl list = (LocalChangeListImpl)((Object)o);
        return this.myName.equals(list.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName.trim();
    }

    public LocalChangeList copy() {
        return new LocalChangeListImpl(this);
    }

    public void setId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "setId"));
        }
        this.myId = id;
    }
}

