/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsAnnotationLocalChangesListenerImpl
implements Disposable,
VcsAnnotationLocalChangesListener {
    private final ZipperUpdater myUpdater;
    private final MessageBusConnection myConnection;
    private final Runnable myUpdateStuff;
    private final Set<String> myDirtyPaths;
    private final Set<VirtualFile> myDirtyFiles;
    private final Map<String, VcsRevisionNumber> myDirtyChanges;
    private final LocalFileSystem myLocalFileSystem;
    private final ProjectLevelVcsManager myVcsManager;
    private final Set<VcsKey> myVcsKeySet;
    private final Object myLock;
    private final MultiMap<VirtualFile, FileAnnotation> myFileAnnotationMap;

    public VcsAnnotationLocalChangesListenerImpl(@NotNull Project project2, ProjectLevelVcsManager vcsManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/VcsAnnotationLocalChangesListenerImpl", "<init>"));
        }
        this.myLock = new Object();
        this.myUpdateStuff = this.createUpdateStuff();
        this.myUpdater = new ZipperUpdater(ApplicationManager.getApplication().isUnitTestMode() ? 10 : 300, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
        this.myConnection = project2.getMessageBus().connect();
        this.myLocalFileSystem = LocalFileSystem.getInstance();
        VcsAnnotationRefresher handler2 = this.createHandler();
        this.myDirtyPaths = new HashSet<String>();
        this.myDirtyChanges = new HashMap<String, VcsRevisionNumber>();
        this.myDirtyFiles = new HashSet<VirtualFile>();
        this.myFileAnnotationMap = MultiMap.createSet();
        this.myVcsManager = vcsManager;
        this.myVcsKeySet = new HashSet<VcsKey>();
        this.myConnection.subscribe(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED, (Object)handler2);
    }

    private Runnable createUpdateStuff() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet vcsToRefresh;
                HashSet paths = new HashSet();
                HashMap changes = new HashMap();
                HashSet files = new HashSet();
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    vcsToRefresh = new HashSet(VcsAnnotationLocalChangesListenerImpl.this.myVcsKeySet);
                    paths.addAll(VcsAnnotationLocalChangesListenerImpl.this.myDirtyPaths);
                    changes.putAll(VcsAnnotationLocalChangesListenerImpl.this.myDirtyChanges);
                    files.addAll(VcsAnnotationLocalChangesListenerImpl.this.myDirtyFiles);
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyPaths.clear();
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyChanges.clear();
                    VcsAnnotationLocalChangesListenerImpl.this.myVcsKeySet.clear();
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyFiles.clear();
                }
                VcsAnnotationLocalChangesListenerImpl.this.closeForVcs(vcsToRefresh);
                VcsAnnotationLocalChangesListenerImpl.this.checkByDirtyScope(paths, changes, files);
            }
        };
    }

    private void checkByDirtyScope(Set<String> removed, Map<String, VcsRevisionNumber> refresh, Set<VirtualFile> files) {
        for (String string : removed) {
            this.refreshForPath(string, null);
        }
        for (Map.Entry entry : refresh.entrySet()) {
            this.refreshForPath((String)entry.getKey(), (VcsRevisionNumber)entry.getValue());
        }
        for (VirtualFile virtualFile : files) {
            this.processUnderFile(virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnderFile(VirtualFile file2) {
        MultiMap annotations = new MultiMap();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            for (VirtualFile virtualFile : this.myFileAnnotationMap.keySet()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)virtualFile, (boolean)true)) continue;
                Collection values = this.myFileAnnotationMap.get((Object)virtualFile);
                for (FileAnnotation value : values) {
                    annotations.putValue((Object)virtualFile, (Object)value);
                }
            }
        }
        if (!annotations.isEmpty()) {
            for (Map.Entry entry : annotations.entrySet()) {
                VirtualFile key2 = (VirtualFile)entry.getKey();
                VcsRevisionNumber number = this.fromDiffProvider(key2);
                if (number == null) continue;
                Collection fileAnnotations = (Collection)entry.getValue();
                for (FileAnnotation annotation : fileAnnotations) {
                    if (!annotation.isBaseRevisionChanged(number)) continue;
                    annotation.close();
                }
            }
        }
    }

    private void refreshForPath(String path, VcsRevisionNumber number) {
        File file2 = new File(path);
        VirtualFile vf = this.myLocalFileSystem.findFileByIoFile(file2);
        if (vf == null) {
            vf = this.myLocalFileSystem.refreshAndFindFileByIoFile(file2);
        }
        if (vf == null) {
            return;
        }
        this.processFile(number, vf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(VcsRevisionNumber number, VirtualFile vf) {
        ArrayList annotations;
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            annotations = ContainerUtil.newArrayList((Iterable)this.myFileAnnotationMap.get((Object)vf));
        }
        if (!annotations.isEmpty()) {
            if (number == null) {
                number = this.fromDiffProvider(vf);
            }
            if (number == null) {
                return;
            }
            for (FileAnnotation annotation : annotations) {
                if (!annotation.isBaseRevisionChanged(number)) continue;
                annotation.close();
            }
        }
    }

    private VcsRevisionNumber fromDiffProvider(VirtualFile vf) {
        DiffProvider diffProvider;
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(vf);
        if (vcsRoot != null && vcsRoot.getVcs() != null && (diffProvider = vcsRoot.getVcs().getDiffProvider()) != null) {
            return diffProvider.getCurrentRevision(vf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeForVcs(Set<VcsKey> refresh) {
        if (refresh.isEmpty()) {
            return;
        }
        HashSet<FileAnnotation> copy = new HashSet<FileAnnotation>();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            for (FileAnnotation annotation : this.myFileAnnotationMap.values()) {
                VcsKey key2 = annotation.getVcsKey();
                if (key2 == null || !refresh.contains(key2)) continue;
                copy.add(annotation);
            }
        }
        for (FileAnnotation annotation : copy) {
            annotation.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAnnotation(VirtualFile file2, FileAnnotation annotation) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFileAnnotationMap.putValue((Object)file2, (Object)annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAnnotation(VirtualFile file2, FileAnnotation annotation) {
        Object object = this.myLock;
        synchronized (object) {
            Collection annotations = this.myFileAnnotationMap.get((Object)file2);
            if (!annotations.isEmpty()) {
                annotations.remove(annotation);
            }
            if (annotations.isEmpty()) {
                this.myFileAnnotationMap.remove((Object)file2);
            }
        }
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.myUpdater.stop();
    }

    private VcsAnnotationRefresher createHandler() {
        return new VcsAnnotationRefresher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dirtyUnder(VirtualFile file2) {
                if (file2 == null) {
                    return;
                }
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyFiles.add(file2);
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dirty(BaseRevision currentRevision) {
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyChanges.put(currentRevision.getPath().getPath(), currentRevision.getRevision());
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dirty(String path) {
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyPaths.add(path);
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void configurationChanged(VcsKey vcsKey) {
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myVcsKeySet.add(vcsKey);
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }
        };
    }
}

