/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommitChangesAction
extends AbstractCommonCheckinAction {
    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "getRoots"));
        }
        FilePath[] filePathArray = AbstractCommitChangesAction.getAllContentRoots(context);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "getRoots"));
        }
        return filePathArray;
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "approximatelyHasRoots"));
        }
        return ProjectLevelVcsManager.getInstance((Project)dataContext.getProject()).hasAnyMappings();
    }

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "update"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "update"));
        }
        super.update(vcsContext, presentation);
        if (presentation.isEnabledAndVisible()) {
            Object[] changes = vcsContext.getSelectedChanges();
            if (((String)vcsContext.getPlace()).equals("ChangesViewPopup")) {
                Object[] changeLists = vcsContext.getSelectedChangeLists();
                presentation.setEnabled(!ArrayUtil.isEmpty((Object[])changeLists) ? changeLists.length == 1 && !changeLists[0].getChanges().isEmpty() : !ArrayUtil.isEmpty((Object[])changes));
            }
            if (presentation.isEnabled() && !ArrayUtil.isEmpty((Object[])changes)) {
                AbstractCommitChangesAction.disableIfAnyHijackedChanges((Project)ObjectUtils.notNull((Object)vcsContext.getProject()), presentation, (Change[])changes);
            }
        }
    }

    private static void disableIfAnyHijackedChanges(@NotNull Project project2, @NotNull Presentation presentation, @NotNull Change[] changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "disableIfAnyHijackedChanges"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "disableIfAnyHijackedChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "disableIfAnyHijackedChanges"));
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        boolean hasHijackedChanges = Stream.of(changes).anyMatch(change -> change.getFileStatus() == FileStatus.HIJACKED && manager.getChangeList(change) == null);
        presentation.setEnabled(!hasHijackedChanges);
    }
}

