/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.impl.DiffViewerWrapper;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProvider;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffViewerWrapperProvider;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequestProducer
implements DiffRequestProducer {
    private static final Logger LOG = Logger.getInstance(ChangeDiffRequestProducer.class);
    public static Key<Change> CHANGE_KEY = Key.create((String)"DiffRequestPresentable.Change");
    @Nullable
    private final Project myProject;
    @NotNull
    private final Change myChange;
    @NotNull
    private final Map<Key, Object> myChangeContext;

    private ChangeDiffRequestProducer(@Nullable Project project2, @NotNull Change change, @NotNull Map<Key, Object> changeContext) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "<init>"));
        }
        if (changeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeContext", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "<init>"));
        }
        this.myChange = change;
        this.myProject = project2;
        this.myChangeContext = changeContext;
    }

    @NotNull
    public Change getChange() {
        Change change = this.myChange;
        if (change == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getChange"));
        }
        return change;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getName() {
        String string = ChangesUtil.getFilePath((Change)this.myChange).getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getName"));
        }
        return string;
    }

    public static boolean isEquals(@NotNull Change change1, @NotNull Change change2) {
        ThreeState equals;
        if (change1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change1", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "isEquals"));
        }
        if (change2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change2", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "isEquals"));
        }
        if (!Comparing.equal((Object)ChangesUtil.getBeforePath((Change)change1), (Object)ChangesUtil.getBeforePath((Change)change2)) || !Comparing.equal((Object)ChangesUtil.getAfterPath((Change)change1), (Object)ChangesUtil.getAfterPath((Change)change2))) {
            return false;
        }
        for (ChangeDiffViewerWrapperProvider changeDiffViewerWrapperProvider : (ChangeDiffViewerWrapperProvider[])ChangeDiffViewerWrapperProvider.EP_NAME.getExtensions()) {
            equals = changeDiffViewerWrapperProvider.isEquals(change1, change2);
            if (equals != ThreeState.NO) continue;
            return false;
        }
        for (ChangeDiffRequestProvider changeDiffRequestProvider : (ChangeDiffRequestProvider[])ChangeDiffRequestProvider.EP_NAME.getExtensions()) {
            equals = changeDiffRequestProvider.isEquals(change1, change2);
            if (equals == ThreeState.YES) {
                return true;
            }
            if (equals != ThreeState.NO) continue;
            return false;
        }
        if (!Comparing.equal(change1.getClass(), change2.getClass())) {
            return false;
        }
        if (!ChangeDiffRequestProducer.isEquals(change1.getBeforeRevision(), change2.getBeforeRevision())) {
            return false;
        }
        return ChangeDiffRequestProducer.isEquals(change1.getAfterRevision(), change2.getAfterRevision());
    }

    private static boolean isEquals(@Nullable ContentRevision revision1, @Nullable ContentRevision revision2) {
        if (Comparing.equal((Object)revision1, (Object)revision2)) {
            return true;
        }
        if (revision1 instanceof CurrentContentRevision && revision2 instanceof CurrentContentRevision) {
            VirtualFile vFile1 = ((CurrentContentRevision)revision1).getVirtualFile();
            VirtualFile vFile2 = ((CurrentContentRevision)revision2).getVirtualFile();
            return Comparing.equal((Object)vFile1, (Object)vFile2);
        }
        return false;
    }

    public static int hashCode(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "hashCode"));
        }
        return ChangeDiffRequestProducer.hashCode(change.getBeforeRevision()) + 31 * ChangeDiffRequestProducer.hashCode(change.getAfterRevision());
    }

    private static int hashCode(@Nullable ContentRevision revision) {
        return revision != null ? revision.getFile().hashCode() : 0;
    }

    @Nullable
    public static ChangeDiffRequestProducer create(@Nullable Project project2, @NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "create"));
        }
        return ChangeDiffRequestProducer.create(project2, change, Collections.emptyMap());
    }

    @Nullable
    public static ChangeDiffRequestProducer create(@Nullable Project project2, @NotNull Change change, @NotNull Map<Key, Object> changeContext) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "create"));
        }
        if (changeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeContext", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "create"));
        }
        if (!ChangeDiffRequestProducer.canCreate(project2, change)) {
            return null;
        }
        return new ChangeDiffRequestProducer(project2, change, changeContext);
    }

    public static boolean canCreate(@Nullable Project project2, @NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "canCreate"));
        }
        for (ChangeDiffViewerWrapperProvider changeDiffViewerWrapperProvider : (ChangeDiffViewerWrapperProvider[])ChangeDiffViewerWrapperProvider.EP_NAME.getExtensions()) {
            if (!changeDiffViewerWrapperProvider.canCreate(project2, change)) continue;
            return true;
        }
        for (ChangeDiffRequestProvider changeDiffRequestProvider : (ChangeDiffRequestProvider[])ChangeDiffRequestProvider.EP_NAME.getExtensions()) {
            if (!changeDiffRequestProvider.canCreate(project2, change)) continue;
            return true;
        }
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        if (bRev == null && aRev == null) {
            return false;
        }
        if (bRev != null && bRev.getFile().isDirectory()) {
            return false;
        }
        return aRev == null || !aRev.getFile().isDirectory();
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        DiffRequest diffRequest;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "process"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "process"));
        }
        try {
            diffRequest = this.loadCurrentContents(context, indicator);
        }
        catch (DiffRequestProducerException | ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            throw new DiffRequestProducerException(e.getMessage());
        }
        if (diffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "process"));
        }
        return diffRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected DiffRequest loadCurrentContents(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "loadCurrentContents"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "loadCurrentContents"));
        }
        DiffRequestProducerException wrapperException = null;
        DiffRequestProducerException requestException = null;
        DiffViewerWrapper wrapper = null;
        try {
            void var8_12;
            ChangeDiffViewerWrapperProvider[] changeDiffViewerWrapperProviderArray = (ChangeDiffViewerWrapperProvider[])ChangeDiffViewerWrapperProvider.EP_NAME.getExtensions();
            int n = changeDiffViewerWrapperProviderArray.length;
            boolean bl = false;
            while (var8_12 < n) {
                ChangeDiffViewerWrapperProvider provider = changeDiffViewerWrapperProviderArray[var8_12];
                if (provider.canCreate(this.myProject, this.myChange)) {
                    wrapper = provider.process(this, context, indicator);
                    break;
                }
                ++var8_12;
            }
        }
        catch (DiffRequestProducerException e) {
            wrapperException = e;
        }
        ErrorDiffRequest request = null;
        try {
            for (ChangeDiffRequestProvider provider : (ChangeDiffRequestProvider[])ChangeDiffRequestProvider.EP_NAME.getExtensions()) {
                if (!provider.canCreate(this.myProject, this.myChange)) continue;
                request = provider.process(this, context, indicator);
                break;
            }
            if (request == null) {
                request = this.createRequest(this.myProject, this.myChange, context, indicator);
            }
        }
        catch (DiffRequestProducerException e) {
            requestException = e;
        }
        if (requestException != null && wrapperException != null) {
            String message = requestException.getMessage() + "\n\n" + wrapperException.getMessage();
            throw new DiffRequestProducerException(message);
        }
        if (requestException != null) {
            request = new ErrorDiffRequest(ChangeDiffRequestProducer.getRequestTitle(this.myChange), (Throwable)requestException);
            LOG.info("Request: " + requestException.getMessage());
        }
        if (wrapperException != null) {
            LOG.info("Wrapper: " + wrapperException.getMessage());
        }
        request.putUserData(CHANGE_KEY, (Object)this.myChange);
        request.putUserData(DiffViewerWrapper.KEY, wrapper);
        for (Map.Entry entry : this.myChangeContext.entrySet()) {
            request.putUserData((Key)entry.getKey(), entry.getValue());
        }
        DiffUtil.putDataKey((UserDataHolder)request, VcsDataKeys.CURRENT_CHANGE, this.myChange);
        ErrorDiffRequest errorDiffRequest = request;
        if (errorDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "loadCurrentContents"));
        }
        return errorDiffRequest;
    }

    @NotNull
    private DiffRequest createRequest(@Nullable Project project2, @NotNull Change change, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createRequest"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createRequest"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createRequest"));
        }
        if (ChangesUtil.isTextConflictingChange((Change)change)) {
            SimpleDiffRequest simpleDiffRequest;
            FilePath path = ChangesUtil.getFilePath((Change)change);
            VirtualFile file2 = path.getVirtualFile();
            if (file2 == null) {
                file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(path.getPath());
            }
            if (file2 == null) {
                throw new DiffRequestProducerException("Can't show merge conflict - file not found");
            }
            if (project2 == null) {
                throw new DiffRequestProducerException("Can't show merge conflict - project is unknown");
            }
            AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)project2);
            if (vcs == null || vcs.getMergeProvider() == null) {
                throw new DiffRequestProducerException("Can't show merge conflict - operation nos supported");
            }
            try {
                Ref exceptionRef = new Ref();
                Ref mergeDataRef = new Ref();
                VirtualFile finalFile = file2;
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    try {
                        mergeDataRef.set((Object)vcs.getMergeProvider().loadRevisions(finalFile));
                    }
                    catch (VcsException e) {
                        exceptionRef.set((Object)e);
                    }
                });
                if (!exceptionRef.isNull()) {
                    Throwable e = (Throwable)exceptionRef.get();
                    if (e instanceof VcsException) {
                        throw (VcsException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                MergeData mergeData = (MergeData)mergeDataRef.get();
                ContentRevision bRev = change.getBeforeRevision();
                ContentRevision aRev = change.getAfterRevision();
                String beforeRevisionTitle = ChangeDiffRequestProducer.getRevisionTitle(bRev, "Your version");
                String afterRevisionTitle = ChangeDiffRequestProducer.getRevisionTitle(aRev, "Server version");
                String title = DiffRequestFactory.getInstance().getTitle(file2);
                List titles = ContainerUtil.list((Object[])new String[]{beforeRevisionTitle, "Base Version", afterRevisionTitle});
                DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                List contents = ContainerUtil.list((Object[])new DiffContent[]{contentFactory.createFromBytes(project2, mergeData.CURRENT, file2), contentFactory.createFromBytes(project2, mergeData.ORIGINAL, file2), contentFactory.createFromBytes(project2, mergeData.LAST, file2)});
                SimpleDiffRequest request = new SimpleDiffRequest(title, contents, titles);
                MergeUtil.putRevisionInfos((DiffRequest)request, mergeData);
                simpleDiffRequest = request;
            }
            catch (VcsException | IOException e) {
                LOG.info(e);
                throw new DiffRequestProducerException(e);
            }
            if (simpleDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createRequest"));
            }
            return simpleDiffRequest;
        }
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        if (bRev == null && aRev == null) {
            LOG.warn("Both revision contents are empty");
            throw new DiffRequestProducerException("Bad revisions contents");
        }
        if (bRev != null) {
            ChangeDiffRequestProducer.checkContentRevision(project2, bRev, context, indicator);
        }
        if (aRev != null) {
            ChangeDiffRequestProducer.checkContentRevision(project2, aRev, context, indicator);
        }
        String title = ChangeDiffRequestProducer.getRequestTitle(change);
        indicator.setIndeterminate(true);
        DiffContent content1 = ChangeDiffRequestProducer.createContent(project2, bRev, context, indicator);
        DiffContent content2 = ChangeDiffRequestProducer.createContent(project2, aRev, context, indicator);
        String userLeftRevisionTitle = (String)this.myChangeContext.get(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE);
        String beforeRevisionTitle = userLeftRevisionTitle != null ? userLeftRevisionTitle : ChangeDiffRequestProducer.getRevisionTitle(bRev, "Base version");
        String userRightRevisionTitle = (String)this.myChangeContext.get(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE);
        String afterRevisionTitle = userRightRevisionTitle != null ? userRightRevisionTitle : ChangeDiffRequestProducer.getRevisionTitle(aRev, "Your version");
        SimpleDiffRequest request = new SimpleDiffRequest(title, content1, content2, beforeRevisionTitle, afterRevisionTitle);
        boolean bRevCurrent = bRev instanceof CurrentContentRevision;
        boolean aRevCurrent = aRev instanceof CurrentContentRevision;
        if (bRevCurrent && !aRevCurrent) {
            request.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.LEFT);
        }
        if (!bRevCurrent && aRevCurrent) {
            request.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.RIGHT);
        }
        SimpleDiffRequest simpleDiffRequest = request;
        if (simpleDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createRequest"));
        }
        return simpleDiffRequest;
    }

    @NotNull
    public static String getRequestTitle(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getRequestTitle"));
        }
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        assert (bRev != null || aRev != null);
        if (bRev != null && aRev != null) {
            FilePath aPath;
            FilePath bPath = bRev.getFile();
            if (bPath.equals(aPath = aRev.getFile())) {
                String string = DiffRequestFactoryImpl.getContentTitle(bPath);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getRequestTitle"));
                }
                return string;
            }
            String string = DiffRequestFactoryImpl.getTitle(bPath, aPath, " -> ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getRequestTitle"));
            }
            return string;
        }
        if (bRev != null) {
            String string = DiffRequestFactoryImpl.getContentTitle(bRev.getFile());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getRequestTitle"));
            }
            return string;
        }
        String string = DiffRequestFactoryImpl.getContentTitle(aRev.getFile());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getRequestTitle"));
        }
        return string;
    }

    @NotNull
    public static String getRevisionTitle(@Nullable ContentRevision revision, @NotNull String defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getRevisionTitle"));
        }
        if (revision == null) {
            String string = defaultValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getRevisionTitle"));
            }
            return string;
        }
        String title = revision.getRevisionNumber().asString();
        if (title == null || title.isEmpty()) {
            String string = defaultValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getRevisionTitle"));
            }
            return string;
        }
        String string = title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "getRevisionTitle"));
        }
        return string;
    }

    @NotNull
    public static DiffContent createContent(@Nullable Project project2, @Nullable ContentRevision revision, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        DocumentContent documentContent;
        DiffContentFactoryEx contentFactory;
        FilePath filePath;
        block20: {
            block19: {
                block18: {
                    block17: {
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createContent"));
                        }
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createContent"));
                        }
                        indicator.checkCanceled();
                        if (revision != null) break block17;
                        EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
                        if (emptyContent == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createContent"));
                        }
                        return emptyContent;
                    }
                    filePath = revision.getFile();
                    contentFactory = DiffContentFactoryEx.getInstanceEx();
                    if (!(revision instanceof CurrentContentRevision)) break block18;
                    VirtualFile vFile = ((CurrentContentRevision)revision).getVirtualFile();
                    if (vFile == null) {
                        throw new DiffRequestProducerException("Can't get current revision content");
                    }
                    DiffContent diffContent = contentFactory.create(project2, vFile);
                    if (diffContent == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createContent"));
                    }
                    return diffContent;
                }
                if (!(revision instanceof BinaryContentRevision)) break block19;
                byte[] content = ((BinaryContentRevision)revision).getBinaryContent();
                if (content == null) {
                    throw new DiffRequestProducerException("Can't get binary revision content");
                }
                DiffContent diffContent = contentFactory.createFromBytes(project2, content, filePath);
                if (diffContent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createContent"));
                }
                return diffContent;
            }
            if (!(revision instanceof ByteBackedContentRevision)) break block20;
            byte[] revisionContent = ((ByteBackedContentRevision)revision).getContentAsBytes();
            if (revisionContent == null) {
                throw new DiffRequestProducerException("Can't get revision content");
            }
            DiffContent diffContent = contentFactory.createFromBytes(project2, revisionContent, filePath);
            if (diffContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createContent"));
            }
            return diffContent;
        }
        try {
            String revisionContent = revision.getContent();
            if (revisionContent == null) {
                throw new DiffRequestProducerException("Can't get revision content");
            }
            documentContent = contentFactory.create(project2, revisionContent, filePath);
        }
        catch (VcsException | IOException e) {
            LOG.info(e);
            throw new DiffRequestProducerException(e);
        }
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "createContent"));
        }
        return documentContent;
    }

    public static void checkContentRevision(@Nullable Project project2, @NotNull ContentRevision rev, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "checkContentRevision"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "checkContentRevision"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer", "checkContentRevision"));
        }
        if (rev.getFile().isDirectory()) {
            throw new DiffRequestProducerException("Can't show diff for directory");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeDiffRequestProducer that = (ChangeDiffRequestProducer)o;
        return this.myChange.equals((Object)that.myChange);
    }

    public int hashCode() {
        return this.myChange.hashCode();
    }
}

