/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.ChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListByDateComparator;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class DateChangeListGroupingStrategy
implements ChangeListGroupingStrategy {
    @NonNls
    private final SimpleDateFormat myMonthYearFormat = new SimpleDateFormat("MMMM yyyy", Locale.ENGLISH);
    private long myTimeToRecalculateAfter;
    private Calendar myCurrentCalendar;
    private Calendar myCalendar = Calendar.getInstance();
    private final WeekDayFormatCache myWeekDayFormatCache = new WeekDayFormatCache(this.myCalendar);
    private final MonthsCache myMonthsCache = new MonthsCache(this.myCalendar);

    public String toString() {
        return VcsBundle.message((String)"date.group.title", (Object[])new Object[0]);
    }

    @Override
    public boolean changedSinceApply() {
        return System.currentTimeMillis() > this.myTimeToRecalculateAfter;
    }

    @Override
    public void beforeStart() {
        this.myCurrentCalendar = Calendar.getInstance();
        this.myCurrentCalendar.setTimeInMillis(0L);
        this.myCurrentCalendar.set(10, 0);
        this.myCurrentCalendar.set(12, 0);
        this.myTimeToRecalculateAfter = this.myCurrentCalendar.getTimeInMillis() + 82800000L;
        this.myCurrentCalendar.setTime(new Date());
    }

    @Override
    public String getGroupName(CommittedChangeList changeList) {
        return this.getGroupName(changeList.getCommitDate());
    }

    public String getGroupName(Date date) {
        this.myCalendar.setTime(date);
        if (this.myCurrentCalendar.get(1) == this.myCalendar.get(1)) {
            if (this.myCurrentCalendar.get(6) == this.myCalendar.get(6)) {
                return VcsBundle.message((String)"date.group.today", (Object[])new Object[0]);
            }
            if (this.myCurrentCalendar.get(3) == this.myCalendar.get(3)) {
                return this.myWeekDayFormatCache.get(this.myCalendar.get(7));
            }
            if (this.myCurrentCalendar.get(3) == this.myCalendar.get(3) + 1) {
                return VcsBundle.message((String)"date.group.last.week", (Object[])new Object[0]);
            }
            return this.myMonthsCache.get(this.myCalendar.get(2));
        }
        return this.myMonthYearFormat.format(date);
    }

    @Override
    public Comparator<CommittedChangeList> getComparator() {
        return CommittedChangeListByDateComparator.DESCENDING;
    }

    private static class WeekDayFormatCache {
        @NonNls
        private final SimpleDateFormat myWeekdayFormat = new SimpleDateFormat("EEEE", Locale.ENGLISH);
        private final Map<Integer, String> myCache = new HashMap<Integer, String>();

        private WeekDayFormatCache(Calendar calendarForInit) {
            for (int i2 = 1; i2 < 8; ++i2) {
                calendarForInit.set(7, i2);
                this.myCache.put(i2, this.myWeekdayFormat.format(calendarForInit.getTime()));
            }
        }

        public String get(int dayOfWeek) {
            return this.myCache.get(dayOfWeek);
        }
    }

    private static class MonthsCache {
        @NonNls
        private final SimpleDateFormat myMonthFormat = new SimpleDateFormat("MMMM", Locale.ENGLISH);
        private final Map<Integer, String> myCache = new HashMap<Integer, String>();

        private MonthsCache(Calendar calendarForInit) {
            for (int i2 = 0; i2 < 12; ++i2) {
                calendarForInit.set(2, i2);
                this.myCache.put(i2, this.myMonthFormat.format(calendarForInit.getTime()));
            }
        }

        public String get(int month) {
            return this.myCache.get(month);
        }
    }
}

